/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.recipe;

import com.petrolpark.destroy.Destroy;
import com.petrolpark.destroy.block.entity.behaviour.ExtendedBasinBehaviour;
import com.petrolpark.destroy.capability.level.pollution.LevelPollution;
import com.petrolpark.destroy.chemistry.Mixture;
import com.petrolpark.destroy.chemistry.ReactionResult;
import com.petrolpark.destroy.chemistry.reactionresult.CombinedReactionResult;
import com.petrolpark.destroy.chemistry.reactionresult.PrecipitateReactionResult;
import com.petrolpark.destroy.fluid.DestroyFluids;
import com.petrolpark.destroy.fluid.MixtureFluid;
import com.petrolpark.destroy.util.vat.IVatHeaterBlock;
import com.simibubi.create.content.kinetics.mixer.MixingRecipe;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;

public class ReactionInBasinRecipe
extends MixingRecipe {
    private static final int BASIN_MAX_OUTPUT = 1000;

    public ReactionInBasinRecipe(ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        super(params);
    }

    @Nullable
    public static ReactionInBasinRecipe create(Collection<FluidStack> availableFluids, Collection<ItemStack> availableItems, BasinBlockEntity basin) {
        ProcessingRecipeBuilder builder = new ProcessingRecipeBuilder(ReactionInBasinRecipe::new, Destroy.asResource("reaction_in_basin_"));
        List<ItemStack> availableItemsCopy = availableItems.stream().map(ItemStack::m_41777_).filter(stack -> !stack.m_41619_()).toList();
        boolean canReact = true;
        boolean isBasinTooFullToReact = false;
        Level level = basin.m_58904_();
        BlockPos pos = basin.m_58899_();
        float heatingPower = IVatHeaterBlock.getHeatingPower(level, pos.m_7495_(), Direction.UP);
        float outsideTemperature = LevelPollution.getLocalTemperature(level, pos);
        HashMap<Mixture, Double> mixtures = new HashMap<Mixture, Double>(availableFluids.size());
        int totalAmount = 0;
        for (FluidStack fluidStack : availableFluids) {
            if (!DestroyFluids.isMixture(fluidStack)) {
                canReact = false;
                break;
            }
            int amount = fluidStack.getAmount();
            totalAmount += amount;
            Mixture mixture = Mixture.readNBT(fluidStack.getOrCreateTag().m_128469_("Mixture"));
            mixtures.put(mixture, (double)amount / 1000.0);
        }
        if (canReact) {
            Mixture mixture = Mixture.mix(mixtures);
            ReactionInBasinResult result = mixture.reactInBasin(totalAmount, availableItemsCopy, heatingPower, outsideTemperature);
            if (result.ticks() == 0) {
                canReact = false;
            } else {
                Mixture.Phases phases = mixture.separatePhases(result.amount());
                FluidStack outputMixtureStack = MixtureFluid.of((int)Math.round(phases.liquidVolume()), phases.liquidMixture());
                builder.output(outputMixtureStack);
                if (outputMixtureStack.getAmount() > 1000) {
                    isBasinTooFullToReact = true;
                    canReact = false;
                }
                int duration = Mth.m_14045_((int)result.ticks(), (int)40, (int)600);
                builder.duration(duration);
                availableItemsCopy.stream().forEach(stack -> {
                    if (stack.m_41619_()) {
                        return;
                    }
                    builder.output(stack);
                });
                availableFluids.stream().map(FluidIngredient::fromFluidStack).forEach(arg_0 -> ((ProcessingRecipeBuilder)builder).require(arg_0));
                availableItems.stream().forEach(stack -> {
                    if (stack.m_41619_()) {
                        return;
                    }
                    for (int i = 0; i < stack.m_41613_(); ++i) {
                        builder.require(Ingredient.m_43929_((ItemLike[])new ItemLike[]{stack.m_41720_()}));
                    }
                });
                HashMap<ReactionResult, Integer> reactionResults = new HashMap<ReactionResult, Integer>();
                ReactionInBasinRecipe.gatherReactionResults(result.reactionresults(), reactionResults, (ProcessingRecipeBuilder<ReactionInBasinRecipe>)builder);
                ExtendedBasinBehaviour behaviour = (ExtendedBasinBehaviour)basin.getBehaviour(ExtendedBasinBehaviour.TYPE);
                behaviour.setReactionResults(reactionResults);
                behaviour.evaporatedFluid = MixtureFluid.of((int)Math.round(phases.gasVolume()), phases.gasMixture());
            }
        }
        ((ExtendedBasinBehaviour)basin.getBehaviour(ExtendedBasinBehaviour.TYPE)).tooFullToReact = isBasinTooFullToReact;
        basin.sendData();
        if (!canReact) {
            return null;
        }
        return (ReactionInBasinRecipe)builder.build();
    }

    private static void gatherReactionResults(Map<ReactionResult, Integer> resultsOfReaction, Map<ReactionResult, Integer> resultsToEnact, ProcessingRecipeBuilder<ReactionInBasinRecipe> builder) {
        for (ReactionResult reactionresult : resultsOfReaction.keySet()) {
            if (reactionresult instanceof CombinedReactionResult) {
                CombinedReactionResult combinedResult = (CombinedReactionResult)reactionresult;
                HashMap<ReactionResult, Integer> childMap = new HashMap<ReactionResult, Integer>();
                for (ReactionResult childResult : combinedResult.getChildren()) {
                    childMap.put(childResult, resultsOfReaction.get(combinedResult));
                }
                ReactionInBasinRecipe.gatherReactionResults(childMap, resultsToEnact, builder);
                continue;
            }
            if (reactionresult instanceof PrecipitateReactionResult) {
                PrecipitateReactionResult precipitationResult = (PrecipitateReactionResult)reactionresult;
                builder.output(precipitationResult.getPrecipitate());
                continue;
            }
            resultsToEnact.put(reactionresult, resultsOfReaction.get(reactionresult));
        }
    }

    protected int getMaxFluidInputCount() {
        return 4;
    }

    public record ReactionInBasinResult(int ticks, Map<ReactionResult, Integer> reactionresults, int amount) {
    }
}

