/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.registrate;

import com.petrolpark.destroy.Destroy;
import com.petrolpark.destroy.MoveToPetrolparkLibrary;
import com.petrolpark.destroy.advancement.BadgeAdvancementRewards;
import com.petrolpark.destroy.advancement.SimpleDestroyTrigger;
import com.petrolpark.destroy.badge.Badge;
import com.petrolpark.destroy.item.BadgeItem;
import com.petrolpark.destroy.registrate.DestroyRegistrate;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.builders.AbstractBuilder;
import com.tterrag.registrate.builders.BuilderCallback;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import com.tterrag.registrate.util.nullness.NonnullType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;

@MoveToPetrolparkLibrary
public class BadgeBuilder<T extends Badge, P>
extends AbstractBuilder<Badge, T, P, BadgeBuilder<T, P>> {
    private final NonNullSupplier<T> factory;
    protected ItemEntry<BadgeItem> item;
    protected Ingredient duplicationIngredient;

    public static <T extends Badge, P> BadgeBuilder<T, P> create(DestroyRegistrate owner, P parent, String name, BuilderCallback callback, NonNullSupplier<T> factory) {
        return new BadgeBuilder<T, P>(owner, parent, name, callback, factory);
    }

    public BadgeBuilder(DestroyRegistrate owner, P parent, String name, BuilderCallback callback, NonNullSupplier<T> factory) {
        super((AbstractRegistrate)owner, parent, name, callback, Destroy.BADGE_REGISTRY_KEY);
        this.factory = factory;
        this.duplicationIngredient = Ingredient.f_43901_;
        this.item = this.getOwner().item("badge/" + this.getName(), p -> new BadgeItem((Item.Properties)p, () -> (Badge)this.getEntry())).tab(null).properties(p -> p.m_41487_(1)).register();
    }

    public BadgeBuilder<T, P> duplicationIngredient(Ingredient ingredient) {
        this.duplicationIngredient = ingredient;
        return this;
    }

    @NonnullType
    protected T createEntry() {
        Badge badge = (Badge)this.factory.get();
        badge.setId(new ResourceLocation(this.getOwner().getModid(), this.getName()));
        SimpleDestroyTrigger advancementTrigger = new SimpleDestroyTrigger("get_badge_" + this.getOwner().getModid() + "_" + this.getName());
        badge.setAdvancementTrigger(advancementTrigger);
        CriteriaTriggers.m_10595_((CriterionTrigger)advancementTrigger);
        badge.setBadgeItem(this.item);
        badge.setDuplicationItem(this.duplicationIngredient);
        return (T)badge;
    }

    public static Map<ResourceLocation, Advancement.Builder> getAdvancements() {
        HashMap<ResourceLocation, Advancement.Builder> advancements = new HashMap<ResourceLocation, Advancement.Builder>();
        for (Badge badge : Badge.badgeRegistry().getValues()) {
            Advancement.Builder advancementBuilder = Advancement.Builder.m_138353_();
            advancementBuilder.m_138396_(new ResourceLocation("petrolpark", "badge_root")).m_138356_((AdvancementRewards)new BadgeAdvancementRewards(badge)).m_138386_("get_badge", (CriterionTriggerInstance)badge.advancementTrigger.instance()).m_143951_((String[][])new String[][]{{"get_badge"}});
            advancements.put(new ResourceLocation(badge.getId().m_135827_(), "badge/" + badge.getId().m_135815_()), advancementBuilder);
        }
        return advancements;
    }

    public static Collection<CraftingRecipe> getExampleDuplicationRecipes() {
        return Badge.badgeRegistry().getValues().stream().map(Badge::getExampleDuplicationRecipe).filter(r -> r != null).toList();
    }
}

