/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.util;

import com.petrolpark.destroy.capability.entity.EntityChemicalPoison;
import com.petrolpark.destroy.chemistry.Molecule;
import com.petrolpark.destroy.chemistry.ReadOnlyMixture;
import com.petrolpark.destroy.chemistry.index.DestroyMolecules;
import com.petrolpark.destroy.effect.DestroyMobEffects;
import com.petrolpark.destroy.fluid.DestroyFluids;
import com.petrolpark.destroy.util.DestroyTags;
import com.petrolpark.destroy.world.damage.DestroyDamageSources;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;

public class ChemistryDamageHelper {
    public static void damage(Level level, LivingEntity entity, FluidStack stack, boolean skinContact) {
        Player player;
        boolean gasMask;
        if (!DestroyFluids.isMixture(stack)) {
            return;
        }
        ReadOnlyMixture mixture = ReadOnlyMixture.readNBT(ReadOnlyMixture::new, stack.getOrCreateChildTag("Mixture"));
        if (mixture.isEmpty()) {
            return;
        }
        boolean burning = mixture.getConcentrationOf(DestroyMolecules.PROTON) > 0.01f || mixture.getConcentrationOf(DestroyMolecules.HYDROXIDE) > 0.01f;
        boolean nauseating = false;
        boolean carcinogen = false;
        Molecule toxicMolecule = null;
        for (Molecule molecule : mixture.getContents(true)) {
            if (molecule.hasTag(DestroyMolecules.Tags.ACUTELY_TOXIC)) {
                toxicMolecule = molecule;
            }
            if (molecule.hasTag(DestroyMolecules.Tags.SMELLY)) {
                nauseating = true;
            }
            if (molecule.hasTag(DestroyMolecules.Tags.CARCINOGEN)) {
                carcinogen = true;
            }
            if (toxicMolecule == null || !nauseating || !carcinogen) continue;
            break;
        }
        boolean hazmat = (gasMask = DestroyTags.DestroyItemTags.CHEMICAL_PROTECTION_HEAD.matches(entity.m_6844_(EquipmentSlot.HEAD).m_41720_())) && DestroyTags.DestroyItemTags.CHEMICAL_PROTECTION_TORSO.matches(entity.m_6844_(EquipmentSlot.CHEST).m_41720_()) && DestroyTags.DestroyItemTags.CHEMICAL_PROTECTION_LEGS.matches(entity.m_6844_(EquipmentSlot.LEGS).m_41720_()) && DestroyTags.DestroyItemTags.CHEMICAL_PROTECTION_FEET.matches(entity.m_6844_(EquipmentSlot.FEET).m_41720_());
        boolean perfume = entity.m_21023_((MobEffect)DestroyMobEffects.FRAGRANCE.get());
        if (!(!nauseating || perfume || gasMask || entity instanceof Player && (player = (Player)entity).m_7500_())) {
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, 0, false, false));
        }
        if (toxicMolecule != null && !gasMask && !level.m_5776_()) {
            EntityChemicalPoison.setMolecule((Entity)entity, toxicMolecule);
            if (!entity.m_21023_((MobEffect)DestroyMobEffects.CHEMICAL_POISON.get())) {
                entity.m_7292_(new MobEffectInstance((MobEffect)DestroyMobEffects.CHEMICAL_POISON.get(), 219, 0, false, false));
            }
        }
        if (carcinogen && !gasMask && entity.m_217043_().m_188503_(2400) == 0) {
            entity.m_7292_(DestroyMobEffects.cancerInstance());
        }
        if (skinContact) {
            if (hazmat && (burning || nauseating || carcinogen || toxicMolecule != null)) {
                for (ItemStack armor : entity.m_6168_()) {
                    ChemistryDamageHelper.contaminate(armor, stack);
                }
            } else if (burning) {
                entity.m_6469_(DestroyDamageSources.chemicalBurn(level), 5.0f);
            }
        }
    }

    public static void contaminate(ItemStack stack, FluidStack fluidStack) {
        Item item = stack.m_41720_();
        if (LivingEntity.m_147233_((ItemStack)stack) != null && (DestroyTags.DestroyItemTags.CHEMICAL_PROTECTION_FEET.matches(item) || DestroyTags.DestroyItemTags.CHEMICAL_PROTECTION_HEAD.matches(item) || DestroyTags.DestroyItemTags.CHEMICAL_PROTECTION_LEGS.matches(item) || DestroyTags.DestroyItemTags.CHEMICAL_PROTECTION_TORSO.matches(item))) {
            CompoundTag tag = stack.m_41784_();
            if (tag.m_128441_("ContaminatingFluid")) {
                return;
            }
            CompoundTag fluidTag = new CompoundTag();
            fluidStack.writeToNBT(fluidTag);
            tag.m_128365_("ContaminatingFluid", (Tag)fluidTag);
        }
    }

    public static void decontaminate(ItemStack stack) {
        stack.m_41784_().m_128473_("ContaminatingFluid");
    }
}

