/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.util;

import com.simibubi.create.AllTags;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class CropMutation {
    public static final Map<Block, List<CropMutation>> MUTATIONS = new HashMap<Block, List<CropMutation>>();
    private Supplier<Block> startCrop;
    private Supplier<BlockState> endCrop;
    private boolean oreSpecific;
    @Nullable
    private Supplier<Block> ore;
    private boolean successful;

    public CropMutation(Supplier<Block> startCrop, Supplier<BlockState> endCrop) {
        this.startCrop = startCrop;
        this.endCrop = endCrop;
        this.oreSpecific = false;
        this.ore = null;
        this.successful = true;
        this.register();
    }

    public CropMutation(Supplier<Block> startCrop, Supplier<BlockState> endCrop, Supplier<Block> ore) {
        this.startCrop = startCrop;
        this.endCrop = endCrop;
        this.oreSpecific = true;
        this.ore = ore;
        this.successful = true;
        this.register();
    }

    private CropMutation(BlockState crop) {
        this.endCrop = () -> crop;
        this.oreSpecific = false;
        this.successful = false;
    }

    private void register() {
        if (!MUTATIONS.keySet().contains(this.startCrop.get())) {
            MUTATIONS.put(this.startCrop.get(), new ArrayList());
        }
        MUTATIONS.get(this.startCrop.get()).add(this);
    }

    public static CropMutation getMutation(BlockState cropBlockState, BlockState blockUnder) {
        Block cropBlock = cropBlockState.m_60734_();
        CropMutation mutation = null;
        block0: for (Block crop : MUTATIONS.keySet()) {
            if (crop != cropBlock) continue;
            for (CropMutation possibleMutation : MUTATIONS.get(crop)) {
                if (possibleMutation.oreSpecific) {
                    Supplier<Block> ore = possibleMutation.ore;
                    if (ore == null || !blockUnder.m_60713_(ore.get())) continue;
                    mutation = possibleMutation;
                    break block0;
                }
                mutation = possibleMutation;
            }
        }
        if (mutation == null) {
            return new CropMutation(cropBlockState);
        }
        return mutation;
    }

    public Supplier<Block> getStartCropSupplier() {
        return this.startCrop;
    }

    public Supplier<BlockState> getResultantCropSupplier() {
        return this.endCrop;
    }

    public Supplier<Block> getOreSupplier() {
        return this.ore;
    }

    public boolean isOreSpecific() {
        return this.oreSpecific;
    }

    public BlockState getResultantBlockUnder(BlockState ore) {
        if (!this.successful || !this.oreSpecific) {
            return ore;
        }
        if (ore.m_204336_(AllTags.forgeBlockTag((String)"ores_in_ground/deepslate"))) {
            return Blocks.f_152550_.m_49966_();
        }
        if (ore.m_204336_(AllTags.forgeBlockTag((String)"ores_in_ground/netherrack"))) {
            return Blocks.f_50134_.m_49966_();
        }
        if (ore.m_204336_(AllTags.forgeBlockTag((String)"ores_in_ground/end_stone"))) {
            return Blocks.f_50259_.m_49966_();
        }
        return Blocks.f_50069_.m_49966_();
    }

    public boolean isSuccessful() {
        return this.successful;
    }
}

