/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.util;

import com.petrolpark.destroy.MoveToPetrolparkLibrary;
import com.petrolpark.destroy.block.DestroyBlocks;
import com.petrolpark.destroy.config.DestroyAllConfigs;
import com.petrolpark.destroy.fluid.ingredient.MixtureFluidIngredient;
import com.petrolpark.destroy.fluid.ingredient.mixturesubtype.MixtureFluidIngredientSubType;
import com.petrolpark.destroy.util.vat.VatMaterial;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.LangBuilder;
import com.simibubi.create.foundation.utility.LangNumberFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;

@MoveToPetrolparkLibrary
public class DestroyLang {
    private static DecimalFormat df = new DecimalFormat();
    private static String[] subscriptNumbers;
    private static String[] superscriptNumbers;
    private static final float pressureMin = 0.0f;
    private static final float pressureMax = 1000000.0f;
    private static final float conductivityMin = 0.0f;
    private static final float conductivityMax = 100.0f;
    private static final TooltipHelper.Palette GRAYS;

    public static LangBuilder builder() {
        return new LangBuilder("destroy");
    }

    public static LangBuilder translate(String langKey, Object ... args) {
        return DestroyLang.builder().translate(langKey, args);
    }

    public static LangBuilder number(double d) {
        return DestroyLang.builder().text(LangNumberFormat.format((double)d));
    }

    public static LangBuilder direction(Direction direction) {
        return DestroyLang.translate("generic.direction." + Lang.asId((String)direction.name()), new Object[0]);
    }

    public static String shorten(String string, Font font, int maxWidth) {
        if (font.m_92895_((String)string) <= maxWidth) {
            return string;
        }
        if (((String)string).isBlank()) {
            return "";
        }
        String elipses = "...";
        int elipsesWidth = font.m_92895_(elipses);
        while (font.m_92895_((String)string) > maxWidth - elipsesWidth || ((String)string).charAt(((String)string).length() - 1) == ' ') {
            if (!((String)(string = ((String)string).substring(0, ((String)string).length() - 1))).isBlank()) continue;
            return "";
        }
        string = (String)string + elipses;
        return string;
    }

    public static void fluidContainerInfoHeader(List<Component> tooltip) {
        Lang.translate((String)"gui.goggles.fluid_container", (Object[])new Object[0]).forGoggles(tooltip);
    }

    public static void tankInfoTooltip(List<Component> tooltip, LangBuilder tankName, FluidTank tank) {
        DestroyLang.tankInfoTooltip(tooltip, tankName, tank.getFluid(), tank.getCapacity());
    }

    public static void tankInfoTooltip(List<Component> tooltip, LangBuilder tankName, FluidStack contents, int capacity) {
        LangBuilder mb = Lang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        tankName.style(ChatFormatting.GRAY).forGoggles(tooltip, 0);
        if (contents.isEmpty()) {
            Lang.translate((String)"gui.goggles.fluid_container.capacity", (Object[])new Object[0]).add(Lang.number((double)capacity).add(mb).style(ChatFormatting.GOLD)).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
        } else {
            Lang.fluidName((FluidStack)contents).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
            Lang.builder().add(Lang.number((double)contents.getAmount()).add(mb).style(ChatFormatting.GOLD)).text(ChatFormatting.GRAY, " / ").add(Lang.number((double)capacity).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        }
    }

    public static MutableComponent barMeterComponent(int value, int maxValue) {
        return DestroyLang.barMeterComponent(value, maxValue, maxValue);
    }

    public static MutableComponent barMeterComponent(int value, int maxValue, int totalBars) {
        float proportion = (float)value / (float)maxValue;
        ChatFormatting color = (double)proportion <= 0.25 ? ChatFormatting.DARK_RED : ((double)proportion <= 0.5 ? ChatFormatting.GOLD : ChatFormatting.DARK_GREEN);
        int bars = Math.round(proportion * (float)totalBars);
        return Component.m_237119_().m_7220_((Component)Component.m_237113_((String)"|".repeat(bars)).m_130940_(color)).m_7220_((Component)Component.m_237113_((String)"|".repeat(totalBars - bars)).m_130940_(ChatFormatting.DARK_GRAY));
    }

    public static List<Component> mixtureIngredientTooltip(CompoundTag fluidTag) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        MixtureFluidIngredientSubType<?> fluidIngredientType = MixtureFluidIngredient.MIXTURE_FLUID_INGREDIENT_SUBTYPES.get(fluidTag.m_128461_("MixtureFluidIngredientSubtype"));
        tooltip.addAll(fluidIngredientType.getDescription(fluidTag));
        return tooltip;
    }

    public static List<Component> vatMaterialTooltip(ItemStack stack) {
        BlockItem blockItem;
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add(stack.m_41786_());
        Item item = stack.m_41720_();
        if (!(item instanceof BlockItem) || !VatMaterial.isValid((blockItem = (BlockItem)item).m_40614_())) {
            return tooltip;
        }
        tooltip.add((Component)Component.m_237113_((String)""));
        if (DestroyBlocks.VAT_CONTROLLER.isIn(stack)) {
            tooltip.addAll(TooltipHelper.cutTextComponent((Component)DestroyLang.translate("tooltip.vat_material.vat_controller", new Object[0]).component(), (TooltipHelper.Palette)GRAYS));
            return tooltip;
        }
        boolean nerdMode = (Boolean)DestroyAllConfigs.CLIENT.chemistry.nerdMode.get();
        VatMaterial material = VatMaterial.BLOCK_MATERIALS.get(blockItem.m_40614_());
        float conductivityPercent = Mth.m_14036_((float)((material.thermalConductivity() - 0.0f) / 100.0f), (float)0.0f, (float)1.0f);
        float pressurePercent = Mth.m_14036_((float)((material.maxPressure() - 0.0f) / 1000000.0f), (float)0.0f, (float)1.0f);
        tooltip.add((Component)DestroyLang.translate("tooltip.vat_material.pressure", new Object[0]).style(ChatFormatting.WHITE).space().add(Component.m_237113_((String)TooltipHelper.makeProgressBar((int)5, (int)((int)(5.0f * pressurePercent + 0.5f)))).m_130940_(DestroyLang.getStatColor(pressurePercent, false))).component());
        if (nerdMode) {
            tooltip.add((Component)DestroyLang.translate("tooltip.vat_material.pressure.nerd_mode", Float.valueOf(material.maxPressure() / 1000.0f)).component());
        }
        tooltip.addAll(TooltipHelper.cutStringTextComponent((String)DestroyLang.translate("tooltip.vat_material.pressure.description", new Object[0]).string(), (TooltipHelper.Palette)GRAYS));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)DestroyLang.translate("tooltip.vat_material.conductivity", new Object[0]).style(ChatFormatting.WHITE).space().add(Component.m_237113_((String)TooltipHelper.makeProgressBar((int)5, (int)((int)(5.0f * conductivityPercent + 0.5f)))).m_130940_(DestroyLang.getStatColor(conductivityPercent, true))).component());
        if (nerdMode) {
            tooltip.add((Component)DestroyLang.translate("tooltip.vat_material.conductivity.nerd_mode", Float.valueOf(material.thermalConductivity())).component());
        }
        tooltip.addAll(TooltipHelper.cutStringTextComponent((String)DestroyLang.translate("tooltip.vat_material.conductivity.description", new Object[0]).string(), (TooltipHelper.Palette)GRAYS));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)DestroyLang.translate("tooltip.vat_material.transparent", new Object[0]).style(ChatFormatting.WHITE).space().add(material.transparent() ? DestroyLang.tick() : DestroyLang.cross()).component());
        tooltip.addAll(TooltipHelper.cutStringTextComponent((String)DestroyLang.translate("tooltip.vat_material.transparent.description", new Object[0]).string(), (TooltipHelper.Palette)GRAYS));
        return tooltip;
    }

    public static MutableComponent tick() {
        return Component.m_237113_((String)"\u2714").m_130940_(ChatFormatting.GREEN).m_6881_();
    }

    public static MutableComponent cross() {
        return Component.m_237113_((String)"\u2718").m_130940_(ChatFormatting.RED).m_6881_();
    }

    public static ChatFormatting getStatColor(float stat, boolean inverted) {
        if (stat > 0.67f) {
            return inverted ? ChatFormatting.RED : ChatFormatting.GREEN;
        }
        if (stat > 0.33f) {
            return ChatFormatting.YELLOW;
        }
        return inverted ? ChatFormatting.GREEN : ChatFormatting.RED;
    }

    public static String toSubscript(int value) {
        Object string = "";
        for (char c : String.valueOf(value).toCharArray()) {
            if (c == '-') {
                string = (String)string + "\u208b";
            }
            string = (String)string + subscriptNumbers[Integer.valueOf(String.valueOf(c))];
        }
        return string;
    }

    public static String toSuperscript(String value) {
        Object string = "";
        for (char c : value.toCharArray()) {
            if (c == '-') {
                string = (String)string + "\u207b";
            }
            if (c == '+') {
                string = (String)string + "\u207a";
            }
            try {
                string = (String)string + superscriptNumbers[Integer.valueOf(String.valueOf(c))];
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return string;
    }

    static {
        df.setMaximumFractionDigits(2);
        df.setMinimumFractionDigits(2);
        subscriptNumbers = new String[]{"\u2080", "\u2081", "\u2082", "\u2083", "\u2084", "\u2085", "\u2086", "\u2087", "\u2088", "\u2089"};
        superscriptNumbers = new String[]{"\u2070", "\u00b9", "\u00b2", "\u00b3", "\u2074", "\u2075", "\u2076", "\u2077", "\u2078", "\u2079"};
        GRAYS = TooltipHelper.Palette.ofColors((ChatFormatting)ChatFormatting.DARK_GRAY, (ChatFormatting)ChatFormatting.GRAY);
    }

    public static enum TemperatureUnit {
        KELVINS(t -> t, "K"),
        DEGREES_CELCIUS(t -> Float.valueOf(t.floatValue() - 273.0f), "\u00b0C"),
        DEGREES_FARENHEIT(t -> Float.valueOf((t.floatValue() - 273.0f) * 9.0f / 5.0f + 32.0f), "\u00b0F");

        private static final DecimalFormat df;
        private UnaryOperator<Float> conversionFromKelvins;
        private String symbol;

        private TemperatureUnit(UnaryOperator<Float> conversionFromKelvins, String symbol) {
            this.conversionFromKelvins = conversionFromKelvins;
            this.symbol = symbol;
        }

        public String of(float temperature) {
            return df.format(this.conversionFromKelvins.apply(Float.valueOf(temperature))) + this.symbol;
        }

        public String of(float temperature, DecimalFormat df) {
            return df.format(this.conversionFromKelvins.apply(Float.valueOf(temperature))) + this.symbol;
        }

        static {
            df = new DecimalFormat();
            df.setMinimumFractionDigits(1);
            df.setMaximumFractionDigits(1);
        }
    }
}

