/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.util;

import com.petrolpark.destroy.Destroy;
import com.petrolpark.destroy.block.entity.BubbleCapBlockEntity;
import com.petrolpark.destroy.capability.level.pollution.LevelPollution;
import com.petrolpark.destroy.chemistry.Mixture;
import com.petrolpark.destroy.chemistry.Molecule;
import com.petrolpark.destroy.chemistry.ReadOnlyMixture;
import com.petrolpark.destroy.fluid.DestroyFluids;
import com.petrolpark.destroy.fluid.MixtureFluid;
import com.petrolpark.destroy.recipe.DestroyRecipeTypes;
import com.petrolpark.destroy.recipe.DistillationRecipe;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class DistillationTower {
    private static final Object distillationRecipeKey = new Object();
    private static final int PROCESS_TIME = 100;
    private BlockPos position;
    private List<BubbleCapBlockEntity> bubbleCaps;
    private DistillationRecipe lastRecipe;
    private int tick;

    public DistillationTower(Level level, BlockPos controllerPos) {
        BlockEntity be;
        this.position = controllerPos;
        this.bubbleCaps = new ArrayList<BubbleCapBlockEntity>();
        this.tick = 100;
        int i = 0;
        while ((be = level.m_7702_(controllerPos.m_6630_(i))) != null && be instanceof BubbleCapBlockEntity) {
            BubbleCapBlockEntity bubbleCap = (BubbleCapBlockEntity)be;
            this.addBubbleCap(bubbleCap);
            ++i;
        }
    }

    public DistillationTower(CompoundTag compound, Level level, BlockPos pos) {
        this.position = pos;
        this.tick = compound.m_128451_("Tick");
        int height = compound.m_128451_("Height");
        this.bubbleCaps = new ArrayList<BubbleCapBlockEntity>();
        for (int i = 0; i < height; ++i) {
            BlockEntity be = level.m_7702_(this.position.m_6630_(i));
            if (be == null || !(be instanceof BubbleCapBlockEntity)) {
                if (level.m_5776_()) break;
                Destroy.LOGGER.warn("Could not load Distillation Tower starting at " + pos + ". New height is " + (i + 1));
                break;
            }
            BubbleCapBlockEntity bubbleCap = (BubbleCapBlockEntity)be;
            this.addBubbleCap(bubbleCap);
        }
    }

    public BlockPos getControllerPos() {
        return this.position;
    }

    public int getHeight() {
        return this.bubbleCaps.size();
    }

    public BubbleCapBlockEntity getControllerBubbleCap() {
        return this.getHeight() == 0 ? null : this.bubbleCaps.get(0);
    }

    public void addBubbleCap(BubbleCapBlockEntity bubbleCap) {
        if (this.bubbleCaps.contains(bubbleCap)) {
            return;
        }
        bubbleCap.addToDistillationTower(this);
        this.bubbleCaps.add(bubbleCap);
        this.getControllerBubbleCap().sendData();
    }

    public void removeBubbleCap(BubbleCapBlockEntity bubbleCapToRemove) {
        ArrayList<BubbleCapBlockEntity> newBubbleCaps = new ArrayList<BubbleCapBlockEntity>();
        for (BubbleCapBlockEntity bubbleCap : this.bubbleCaps) {
            if (bubbleCap == bubbleCapToRemove) break;
            newBubbleCaps.add(bubbleCap);
        }
        this.bubbleCaps = newBubbleCaps;
    }

    public void tick(Level level) {
        --this.tick;
        if (this.tick <= 0) {
            this.findRecipe(level);
            this.process();
            this.tick = 100;
        }
    }

    public void findRecipe(Level level) {
        if (this.getControllerBubbleCap() == null) {
            return;
        }
        SmartFluidTank inputTank = this.getControllerBubbleCap().getTank();
        if (this.lastRecipe == null || !this.lastRecipe.getRequiredFluid().test(inputTank.getFluid())) {
            List possibleRecipes = RecipeFinder.get((Object)distillationRecipeKey, (Level)level, r -> r.m_6671_() == DestroyRecipeTypes.DISTILLATION.getType()).stream().filter(r -> {
                DistillationRecipe recipe = (DistillationRecipe)((Object)r);
                return recipe.getRequiredFluid().test(inputTank.getFluid());
            }).collect(Collectors.toList());
            this.lastRecipe = possibleRecipes.size() >= 1 ? (DistillationRecipe)((Object)possibleRecipes.get(0)) : null;
        }
    }

    public boolean process() {
        BubbleCapBlockEntity controller = this.getControllerBubbleCap();
        if (controller == null) {
            return false;
        }
        Level level = controller.m_58904_();
        if (level == null) {
            return false;
        }
        FluidStack fluidStack = this.getControllerBubbleCap().getTank().getFluid();
        if (fluidStack.isEmpty()) {
            return false;
        }
        if (DestroyFluids.isMixture(fluidStack.getFluid()) && fluidStack.getOrCreateTag().m_128425_("Mixture", 10)) {
            ReadOnlyMixture mixture = ReadOnlyMixture.readNBT(ReadOnlyMixture::new, fluidStack.getOrCreateTag().m_128469_("Mixture"));
            List<FluidStack> fractions = this.getFractionsOfMixture(mixture, fluidStack.getAmount(), this.getHeight() - 1);
            if (fractions.size() <= 1) {
                return false;
            }
            for (boolean simulate : Iterate.trueAndFalse) {
                int i = 0;
                for (FluidStack fraction : fractions) {
                    SmartFluidTank tankToTryFill;
                    if (i == 0) {
                        ++i;
                        continue;
                    }
                    BubbleCapBlockEntity bubbleCap = this.bubbleCaps.get(i);
                    SmartFluidTank smartFluidTank = tankToTryFill = simulate ? bubbleCap.getTank() : bubbleCap.getInternalTank();
                    if (simulate && !bubbleCap.getInternalTank().isEmpty()) {
                        return false;
                    }
                    if (tankToTryFill.fill(fraction, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE) < fraction.getAmount()) {
                        return false;
                    }
                    if (!simulate) {
                        bubbleCap.setTicksToFill(i * BubbleCapBlockEntity.getTankCapacity() / BubbleCapBlockEntity.getTransferRate());
                    }
                    ++i;
                }
            }
            FluidStack fluidDrained = controller.getTank().drain(BubbleCapBlockEntity.getTankCapacity(), IFluidHandler.FluidAction.EXECUTE);
            controller.getTank().fill(fractions.get(0), IFluidHandler.FluidAction.EXECUTE);
            controller.particleFluid = fluidDrained.copy();
            controller.onDistill();
            return true;
        }
        if (this.lastRecipe == null) {
            return false;
        }
        if (this.lastRecipe.getFractions() > this.getHeight() - 1) {
            return false;
        }
        FluidStack fluidDrained = FluidStack.EMPTY;
        for (boolean simulate : Iterate.trueAndFalse) {
            if (!this.lastRecipe.getRequiredHeat().testBlazeBurner(BasinBlockEntity.getHeatLevelOf((BlockState)controller.m_58904_().m_8055_(controller.m_58899_().m_6625_(1))))) {
                return false;
            }
            int requiredFluidAmount = this.lastRecipe.getRequiredFluid().getRequiredAmount();
            fluidDrained = this.getControllerBubbleCap().getTank().drain(requiredFluidAmount, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
            if (fluidDrained.getAmount() < requiredFluidAmount) {
                return false;
            }
            for (int i = 0; i < this.lastRecipe.getFractions(); ++i) {
                SmartFluidTank tankToTryFill;
                FluidStack distillate = (FluidStack)this.lastRecipe.getFluidResults().get(i);
                BubbleCapBlockEntity bubbleCap = this.bubbleCaps.get(i + 1);
                SmartFluidTank smartFluidTank = tankToTryFill = simulate ? bubbleCap.getTank() : bubbleCap.getInternalTank();
                if (simulate && !bubbleCap.getInternalTank().isEmpty()) {
                    return false;
                }
                if (tankToTryFill.fill(distillate, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE) < distillate.getAmount()) {
                    return false;
                }
                if (simulate) continue;
                bubbleCap.setTicksToFill(i * BubbleCapBlockEntity.getTankCapacity() / BubbleCapBlockEntity.getTransferRate());
            }
        }
        controller.particleFluid = fluidDrained.copy();
        controller.onDistill();
        return true;
    }

    private List<FluidStack> getFractionsOfMixture(ReadOnlyMixture mixture, int mixtureAmount, int numberOfFractions) {
        ArrayList<FluidStack> fractions = new ArrayList<FluidStack>(numberOfFractions);
        float roomTemperature = LevelPollution.getLocalTemperature(this.getControllerBubbleCap().m_58904_(), this.getControllerPos());
        float maxTemperature = Math.max(DistillationTower.getTemperatureForDistillationTower(this.getControllerBubbleCap().m_58904_(), this.getControllerPos()), mixture.getTemperature());
        if (numberOfFractions == 0) {
            return fractions;
        }
        if (numberOfFractions == 1) {
            return List.of(MixtureFluid.of(mixtureAmount, mixture));
        }
        Mixture gasMixture = new Mixture().setTemperature(roomTemperature);
        boolean thereAreGases = false;
        Mixture residueMixture = new Mixture();
        ArrayList<Molecule> liquids = new ArrayList<Molecule>();
        float lowestBoilingPoint = roomTemperature;
        float highestBoilingPoint = roomTemperature;
        for (Molecule molecule : mixture.getContents(false)) {
            if (molecule.getBoilingPoint() < roomTemperature) {
                thereAreGases = true;
                gasMixture.addMolecule(molecule, mixture.getConcentrationOf(molecule));
                continue;
            }
            if (molecule.getBoilingPoint() > maxTemperature) {
                residueMixture.addMolecule(molecule, mixture.getConcentrationOf(molecule));
                continue;
            }
            liquids.add(molecule);
            lowestBoilingPoint = Math.min(lowestBoilingPoint, molecule.getBoilingPoint());
            highestBoilingPoint = Math.max(highestBoilingPoint, molecule.getBoilingPoint());
        }
        if (thereAreGases) {
            --numberOfFractions;
        }
        float interval = (highestBoilingPoint - lowestBoilingPoint) / (float)numberOfFractions;
        ArrayList<Mixture> liquidMixtures = new ArrayList<Mixture>(numberOfFractions);
        for (int i = 0; i < numberOfFractions; ++i) {
            liquidMixtures.add(new Mixture().setTemperature(roomTemperature));
        }
        block2: for (Molecule molecule : liquids) {
            for (int fraction = 0; fraction < numberOfFractions; ++fraction) {
                if (!(molecule.getBoilingPoint() <= lowestBoilingPoint + (float)(fraction + 1) * interval)) continue;
                ((Mixture)liquidMixtures.get(fraction)).addMolecule(molecule, mixture.getConcentrationOf(molecule));
                continue block2;
            }
        }
        int residueAmount = residueMixture.recalculateVolume(mixtureAmount);
        fractions.add(MixtureFluid.of(residueAmount, residueMixture));
        for (int fraction = 0; fraction < numberOfFractions; ++fraction) {
            Mixture fractionMixture = (Mixture)liquidMixtures.get(fraction);
            int amount = fractionMixture.recalculateVolume(mixtureAmount);
            if (amount == 0) continue;
            fractions.add(MixtureFluid.of(amount, fractionMixture));
        }
        if (thereAreGases) {
            int amount = gasMixture.recalculateVolume(mixtureAmount);
            fractions.add(MixtureFluid.of(amount, gasMixture));
        }
        return fractions;
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128405_("Height", this.getHeight());
        compound.m_128405_("Tick", this.tick);
        return compound;
    }

    public static float getTemperatureForDistillationTower(Level level, BlockPos pos) {
        float roomTemperature;
        float temperature = roomTemperature = LevelPollution.getLocalTemperature(level, pos);
        BlazeBurnerBlock.HeatLevel heatLevel = BasinBlockEntity.getHeatLevelOf((BlockState)level.m_8055_(pos.m_7495_()));
        if (heatLevel.name() == "FROSTING") {
            temperature = 273.0f;
        }
        switch (heatLevel) {
            case FADING: {
                temperature = 350.0f;
                break;
            }
            case KINDLED: {
                temperature = 400.0f;
                break;
            }
            case SEETHING: {
                temperature = 600.0f;
                break;
            }
        }
        return temperature;
    }
}

