/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.util;

import com.petrolpark.destroy.advancement.DestroyAdvancements;
import com.petrolpark.destroy.capability.level.pollution.LevelPollution;
import com.petrolpark.destroy.capability.level.pollution.LevelPollutionProvider;
import com.petrolpark.destroy.chemistry.Molecule;
import com.petrolpark.destroy.chemistry.ReadOnlyMixture;
import com.petrolpark.destroy.config.DestroyAllConfigs;
import com.petrolpark.destroy.fluid.DestroyFluids;
import com.petrolpark.destroy.network.DestroyMessages;
import com.petrolpark.destroy.network.packet.EvaporatingFluidS2CPacket;
import com.petrolpark.destroy.util.ChemistryDamageHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fluids.FluidStack;

public class PollutionHelper {
    public static boolean pollutionEnabled() {
        return (Boolean)DestroyAllConfigs.SERVER.pollution.enablePollution.get();
    }

    public static int getPollution(Level level, LevelPollution.PollutionType pollutionType) {
        return level.getCapability(LevelPollutionProvider.LEVEL_POLLUTION).map(levelPollution -> levelPollution.get(pollutionType)).orElse(0);
    }

    public static int setPollution(Level level, LevelPollution.PollutionType pollutionType, int value) {
        return level.getCapability(LevelPollutionProvider.LEVEL_POLLUTION).map(levelPollution -> {
            int newValue = levelPollution.set(pollutionType, value);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (levelPollution.hasPollutionEverBeenMaxed()) {
                    serverLevel.m_6907_().forEach(player -> DestroyAdvancements.FULLY_POLLUTE.award((Level)serverLevel, (Player)player));
                    if (levelPollution.hasPollutionEverBeenFullyReduced()) {
                        serverLevel.m_6907_().forEach(player -> DestroyAdvancements.UNPOLLUTE.award((Level)serverLevel, (Player)player));
                    }
                }
            }
            return newValue;
        }).orElse(0);
    }

    public static int changePollution(Level level, LevelPollution.PollutionType pollutionType, int change) {
        return PollutionHelper.setPollution(level, pollutionType, Mth.m_14045_((int)(PollutionHelper.getPollution(level, pollutionType) + change), (int)0, (int)pollutionType.max));
    }

    public static void pollute(Level level, FluidStack fluidStack) {
        if (DestroyFluids.isMixture(fluidStack) && fluidStack.getOrCreateTag().m_128425_("Mixture", 10)) {
            ReadOnlyMixture mixture = ReadOnlyMixture.readNBT(ReadOnlyMixture::new, fluidStack.getOrCreateTag().m_128469_("Mixture"));
            for (Molecule molecule : mixture.getContents(true)) {
                float pollutionAmount = mixture.getConcentrationOf(molecule) * (float)fluidStack.getAmount() / 1000.0f;
                for (LevelPollution.PollutionType pollutionType : LevelPollution.PollutionType.values()) {
                    if (!molecule.hasTag(pollutionType.moleculeTag) || !(level.f_46441_.m_188501_() <= pollutionAmount)) continue;
                    PollutionHelper.changePollution(level, pollutionType, (int)pollutionAmount);
                }
            }
        }
    }

    public static void pollute(Level level, BlockPos blockPos, int particleWeight, FluidStack ... fluidStacks) {
        if (level.m_5776_()) {
            return;
        }
        List<LivingEntity> nearbyEntities = level.m_45933_(null, new AABB(blockPos).m_82400_(2.0)).stream().filter(e -> e instanceof LivingEntity).map(e -> (LivingEntity)e).toList();
        for (FluidStack fluidStack : List.of(fluidStacks)) {
            PollutionHelper.pollute(level, fluidStack);
            if (particleWeight == 1 || level.m_213780_().m_188503_(particleWeight) == 0) {
                // empty if block
            }
            DestroyMessages.sendToAllClients(new EvaporatingFluidS2CPacket(blockPos, fluidStack));
            for (LivingEntity entity : nearbyEntities) {
                ChemistryDamageHelper.damage(level, entity, fluidStack, true);
            }
        }
    }

    public static void pollute(Level level, BlockPos blockPos, FluidStack ... fluidStacks) {
        PollutionHelper.pollute(level, blockPos, 1, fluidStacks);
    }
}

