/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.util;

import com.google.common.collect.ImmutableList;
import com.petrolpark.destroy.Destroy;
import com.petrolpark.destroy.util.DestroyLang;
import com.simibubi.create.Create;
import com.simibubi.create.content.redstone.link.IRedstoneLinkable;
import com.simibubi.create.content.redstone.link.RedstoneLinkNetworkHandler;
import com.simibubi.create.foundation.utility.Couple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;

public abstract class RedstoneProgram {
    public PlayMode mode = PlayMode.MANUAL;
    protected int length = 20;
    protected int playtime = 0;
    public boolean paused = true;
    protected boolean pausedLastTick = false;
    protected boolean poweredLastTick = false;
    protected List<Channel> channels = new ArrayList<Channel>();
    protected boolean notifiedChange = false;

    public void tick() {
        boolean powered = this.hasPower();
        if (this.paused != this.pausedLastTick) {
            this.notifiedChange = false;
        }
        if (this.mode.powerRequired) {
            boolean bl = this.paused = !powered;
        }
        if (powered && !this.poweredLastTick) {
            if (this.mode == PlayMode.SWITCH_ON_PULSE) {
                this.paused = !this.paused;
            } else if (this.mode == PlayMode.RESTART_ON_PULSE) {
                this.paused = false;
                this.playtime = 0;
            }
        }
        if (!powered && this.mode == PlayMode.LOOP_WITH_POWER) {
            this.playtime = 0;
        }
        if (!this.paused) {
            ++this.playtime;
        }
        if (this.playtime >= this.length) {
            this.playtime = 0;
            if (this.mode.pausesWhenFinished) {
                this.paused = true;
            }
        }
        if (!this.notifiedChange) {
            this.channels.forEach(Channel::updateNetwork);
            if (this.paused) {
                this.notifiedChange = false;
            }
        }
        this.poweredLastTick = powered;
        this.pausedLastTick = this.paused;
    }

    public abstract boolean hasPower();

    public abstract BlockPos getBlockPos();

    public abstract boolean shouldTransmit();

    public abstract LevelAccessor getWorld();

    public ImmutableList<Channel> getChannels() {
        return ImmutableList.copyOf(this.channels);
    }

    public void addBlankChannel(Couple<RedstoneLinkNetworkHandler.Frequency> frequencies) {
        if (!RedstoneProgram.isValidWorld(this.getWorld())) {
            return;
        }
        Channel channel = new Channel(frequencies, new int[this.length]);
        RedstoneProgram.getHandler().addToNetwork(this.getWorld(), (IRedstoneLinkable)channel);
        for (int i = 0; i < this.length; ++i) {
            channel.sequence[i] = 15 * (i / 2 % 2);
        }
        this.paused = false;
        this.mode = PlayMode.LOOP;
        this.channels.add(channel);
    }

    public boolean remove(Channel channel) {
        if (!RedstoneProgram.isValidWorld(this.getWorld())) {
            return false;
        }
        boolean removed = this.channels.remove(channel);
        if (removed) {
            RedstoneProgram.getHandler().removeFromNetwork(this.getWorld(), (IRedstoneLinkable)channel);
        }
        return removed;
    }

    public void swap(Channel channel1, Channel channel2) {
        if (this.channels.contains(channel1) && this.channels.contains(channel2)) {
            Collections.swap(this.channels, this.channels.indexOf(channel1), this.channels.indexOf(channel2));
        }
    }

    public void load() {
        if (!RedstoneProgram.isValidWorld(this.getWorld())) {
            return;
        }
        this.channels.forEach(channel -> RedstoneProgram.getHandler().addToNetwork(this.getWorld(), (IRedstoneLinkable)channel));
        this.notifiedChange = false;
    }

    public void unload() {
        if (!RedstoneProgram.isValidWorld(this.getWorld())) {
            return;
        }
        this.channels.forEach(channel -> RedstoneProgram.getHandler().removeFromNetwork(this.getWorld(), (IRedstoneLinkable)channel));
    }

    public void setDuration(int duration) {
        this.length = duration;
        for (Channel channel : this.channels) {
            channel.sequence = Arrays.copyOf(channel.sequence, duration);
        }
    }

    public CompoundTag write() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("Mode", this.mode.ordinal());
        tag.m_128405_("Length", this.length);
        tag.m_128405_("Playtime", this.playtime);
        tag.m_128379_("Paused", this.paused);
        tag.m_128379_("PoweredLastTick", this.poweredLastTick);
        ListTag sequencesTag = new ListTag();
        for (Channel channel : this.channels) {
            CompoundTag sequenceTag = new CompoundTag();
            sequenceTag.m_128365_("FrequencyFirst", (Tag)((RedstoneLinkNetworkHandler.Frequency)channel.networkKey.getFirst()).getStack().m_41739_(new CompoundTag()));
            sequenceTag.m_128365_("FrequencyLast", (Tag)((RedstoneLinkNetworkHandler.Frequency)channel.networkKey.getSecond()).getStack().m_41739_(new CompoundTag()));
            sequenceTag.m_128385_("Sequence", this.getEncodedSequence(channel));
            sequencesTag.add((Object)sequenceTag);
        }
        tag.m_128365_("Sequences", (Tag)sequencesTag);
        return tag;
    }

    public static <T extends RedstoneProgram> T read(Supplier<T> newProgram, CompoundTag tag) {
        RedstoneProgram program = (RedstoneProgram)newProgram.get();
        program.mode = PlayMode.values()[tag.m_128451_("Mode")];
        program.length = tag.m_128451_("Length");
        program.playtime = tag.m_128451_("Playtime");
        program.paused = tag.m_128471_("Paused");
        program.poweredLastTick = tag.m_128471_("PoweredLastTick");
        tag.m_128437_("Sequences", 10).forEach(t -> {
            CompoundTag sequenceTag = (CompoundTag)t;
            int[] sequence = RedstoneProgram.decodeSequence(program.length, sequenceTag.m_128465_("Sequence"));
            List<Channel> list = program.channels;
            RedstoneProgram redstoneProgram = program;
            Objects.requireNonNull(redstoneProgram);
            list.add(redstoneProgram.new Channel((Couple<RedstoneLinkNetworkHandler.Frequency>)Couple.create((Object)RedstoneLinkNetworkHandler.Frequency.of((ItemStack)ItemStack.m_41712_((CompoundTag)sequenceTag.m_128469_("FrequencyFirst"))), (Object)RedstoneLinkNetworkHandler.Frequency.of((ItemStack)ItemStack.m_41712_((CompoundTag)sequenceTag.m_128469_("FrequencyLast")))), sequence));
        });
        return (T)program;
    }

    public final void write(FriendlyByteBuf buf) {
        buf.writeInt(this.mode.ordinal());
        buf.m_130130_(this.length);
        buf.m_130130_(this.playtime);
        buf.writeBoolean(this.paused);
        buf.writeBoolean(this.poweredLastTick);
        buf.m_130130_(this.channels.size());
        for (Channel channel : this.channels) {
            buf.m_130055_(((RedstoneLinkNetworkHandler.Frequency)channel.networkKey.getFirst()).getStack());
            buf.m_130055_(((RedstoneLinkNetworkHandler.Frequency)channel.networkKey.getSecond()).getStack());
            buf.m_130089_(this.getEncodedSequence(channel));
        }
    }

    public void read(FriendlyByteBuf buf) {
        this.mode = PlayMode.values()[buf.readInt()];
        this.length = buf.m_130242_();
        this.playtime = buf.m_130242_();
        this.paused = buf.readBoolean();
        this.poweredLastTick = buf.readBoolean();
        int channels = buf.m_130242_();
        Destroy.LOGGER.info("Channels");
        for (int i = 0; i < channels; ++i) {
            this.channels.add(new Channel((Couple<RedstoneLinkNetworkHandler.Frequency>)Couple.create((Object)RedstoneLinkNetworkHandler.Frequency.of((ItemStack)buf.m_130267_()), (Object)RedstoneLinkNetworkHandler.Frequency.of((ItemStack)buf.m_130267_())), RedstoneProgram.decodeSequence(this.length, buf.m_130100_())));
        }
    }

    public void copyFrom(RedstoneProgram otherProgram) {
        this.mode = otherProgram.mode;
        this.length = otherProgram.length;
        this.playtime = otherProgram.playtime;
        this.paused = otherProgram.paused;
        this.poweredLastTick = otherProgram.poweredLastTick;
        this.channels = otherProgram.channels;
    }

    private int[] getEncodedSequence(Channel channel) {
        int[] encodedStrengths = new int[this.length / 7 + 1];
        int i = 0;
        while (i < this.length) {
            int encodedStrength = 0;
            for (int j = 6; j >= 0; --j) {
                int strength = i < this.length ? channel.sequence[i] : 0;
                encodedStrength += strength << 4 * j;
                ++i;
            }
            encodedStrengths[(i - 1) / 7] = encodedStrength;
        }
        return encodedStrengths;
    }

    protected static int[] decodeSequence(int length, int[] encodedSequence) {
        int[] sequence = new int[length];
        int i = 0;
        for (int encodedStrength : encodedSequence) {
            for (int j = 6; j >= 0 && i < length; ++i, --j) {
                int strength = encodedStrength >> 4 * j;
                encodedStrength -= strength << 4 * j;
                sequence[i] = strength;
            }
        }
        return sequence;
    }

    protected static RedstoneLinkNetworkHandler getHandler() {
        return Create.REDSTONE_LINK_NETWORK_HANDLER;
    }

    protected static boolean isValidWorld(LevelAccessor level) {
        return level != null && !level.m_5776_();
    }

    public static enum PlayMode {
        MANUAL(true, false, (Component)DestroyLang.translate("tooltip.redstone_programmer.mode.manual", new Object[0]).component()),
        SWITCH_ON_PULSE(false, false, (Component)DestroyLang.translate("tooltip.redstone_programmer.mode.switch_on_pulse", new Object[0]).component()),
        RESTART_ON_PULSE(true, false, (Component)DestroyLang.translate("tooltip.redstone_programmer.mode.restart_on_pulse", new Object[0]).component()),
        RESUME_WITH_POWER(false, true, (Component)DestroyLang.translate("tooltip.redstone_programmer.mode.resume_with_power", new Object[0]).component()),
        RESTART_WITH_POWER(true, true, (Component)DestroyLang.translate("tooltip.redstone_programmer.mode.restart_with_power", new Object[0]).component()),
        LOOP_WITH_POWER(false, true, (Component)DestroyLang.translate("tooltip.redstone_programmer.mode.loop_with_power", new Object[0]).component()),
        LOOP(false, false, (Component)DestroyLang.translate("tooltip.redstone_programmer.mode.loop", new Object[0]).component());

        public final boolean pausesWhenFinished;
        public final boolean powerRequired;
        public final Component description;

        private PlayMode(boolean pausesWhenFinished, boolean powerRequired, Component description) {
            this.pausesWhenFinished = pausesWhenFinished;
            this.powerRequired = powerRequired;
            this.description = description;
        }
    }

    public class Channel
    implements IRedstoneLinkable {
        public final Couple<RedstoneLinkNetworkHandler.Frequency> networkKey;
        protected int[] sequence;

        protected Channel(Couple<RedstoneLinkNetworkHandler.Frequency> networkKey, int[] sequence) {
            this.networkKey = networkKey;
            this.sequence = sequence;
        }

        protected void updateNetwork() {
            if (!RedstoneProgram.isValidWorld(RedstoneProgram.this.getWorld())) {
                return;
            }
            if (RedstoneProgram.this.playtime != 0 && this.sequence[RedstoneProgram.this.playtime] != this.sequence[RedstoneProgram.this.playtime - 1]) {
                RedstoneProgram.getHandler().updateNetworkOf(RedstoneProgram.this.getWorld(), (IRedstoneLinkable)this);
            }
        }

        public void setStrength(int position, int strength) {
            if (position < RedstoneProgram.this.length) {
                if (strength <= 16 || strength < 0) {
                    strength = 0;
                }
                this.sequence[position] = strength;
            }
        }

        public int getTransmittedStrength() {
            if (RedstoneProgram.this.paused || RedstoneProgram.this.playtime >= RedstoneProgram.this.length) {
                return 0;
            }
            return this.sequence[RedstoneProgram.this.playtime];
        }

        public void setReceivedStrength(int power) {
        }

        public boolean isListening() {
            return false;
        }

        public boolean isAlive() {
            return RedstoneProgram.this.shouldTransmit();
        }

        public Couple<RedstoneLinkNetworkHandler.Frequency> getNetworkKey() {
            return this.networkKey;
        }

        public BlockPos getLocation() {
            return RedstoneProgram.this.getBlockPos();
        }
    }
}

