/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.util.vat;

import com.google.common.collect.ImmutableList;
import com.petrolpark.destroy.block.VatControllerBlock;
import com.petrolpark.destroy.util.vat.VatMaterial;
import com.simibubi.create.CreateClient;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Vat {
    public static final int MB_PER_BLOCK = 1000;
    private BlockPos lowerCorner;
    private BlockPos upperCorner;
    private ImmutableList<BlockPos> sides;
    private float maximumPressure;
    private BlockState weakestBlockState;
    private float conductance;

    private Vat(BlockPos lowerCorner, BlockPos upperCorner) {
        this.lowerCorner = lowerCorner;
        this.upperCorner = upperCorner;
    }

    public static Optional<Vat> read(CompoundTag tag) {
        if (!tag.m_128425_("LowerCorner", 10) || !tag.m_128425_("UpperCorner", 10)) {
            return Optional.empty();
        }
        Vat vat = new Vat(NbtUtils.m_129239_((CompoundTag)tag.m_128469_("LowerCorner")), NbtUtils.m_129239_((CompoundTag)tag.m_128469_("UpperCorner")));
        vat.conductance = tag.m_128457_("Conductance");
        vat.weakestBlockState = NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)tag.m_128469_("WeakestBlock"));
        vat.maximumPressure = VatMaterial.BLOCK_MATERIALS.get(vat.weakestBlockState.m_60734_()).maxPressure();
        return Optional.of(vat);
    }

    public void write(CompoundTag tag) {
        tag.m_128365_("LowerCorner", (Tag)NbtUtils.m_129224_((BlockPos)this.lowerCorner));
        tag.m_128365_("UpperCorner", (Tag)NbtUtils.m_129224_((BlockPos)this.upperCorner));
        tag.m_128350_("Conductance", this.conductance);
        tag.m_128365_("WeakestBlock", (Tag)NbtUtils.m_129202_((BlockState)this.weakestBlockState));
    }

    public static Optional<Vat> tryConstruct(Level level, BlockPos pos, BlockPos controllerPos) {
        boolean successful = true;
        EnumMap<Direction, Integer> dimensions = new EnumMap<Direction, Integer>(Direction.class){

            @Override
            public Integer get(Object key) {
                Integer value = (Integer)super.get(key);
                if (value == null) {
                    return 0;
                }
                return value;
            }
        };
        block0: for (Direction direction : Direction.values()) {
            while (true) {
                if ((Integer)dimensions.get(direction) + (Integer)dimensions.get(direction.m_122424_()) > 5) {
                    successful = false;
                    break block0;
                }
                BlockPos newPlaneCentre = new BlockPos((Vec3i)pos).m_5484_(direction, 1 + (Integer)dimensions.get(direction));
                BlockPos lowerCorner = new BlockPos((Vec3i)newPlaneCentre);
                BlockPos upperCorner = new BlockPos((Vec3i)newPlaneCentre);
                for (Direction secondaryDirection : Direction.values()) {
                    if (direction.m_122434_() == secondaryDirection.m_122434_()) continue;
                    if (secondaryDirection.m_122421_() == Direction.AxisDirection.POSITIVE) {
                        upperCorner = upperCorner.m_5484_(secondaryDirection, ((Integer)dimensions.get(secondaryDirection)).intValue());
                        continue;
                    }
                    lowerCorner = lowerCorner.m_5484_(secondaryDirection, ((Integer)dimensions.get(secondaryDirection)).intValue());
                }
                boolean allAir = true;
                boolean allWalls = true;
                for (BlockPos blockPos : BlockPos.m_121940_((BlockPos)lowerCorner, (BlockPos)upperCorner)) {
                    BlockState state = level.m_8055_(blockPos);
                    if (state.m_60795_()) {
                        allWalls = false;
                        continue;
                    }
                    allAir = false;
                    Block block = state.m_60734_();
                    if (VatMaterial.isValid(block) && (!(block instanceof VatControllerBlock) || blockPos.equals((Object)controllerPos))) continue;
                    allWalls = false;
                }
                if (allWalls) continue block0;
                if (!allAir) {
                    successful = false;
                    break block0;
                }
                dimensions.merge(direction, 1, (i1, i2) -> i1 + 1);
            }
        }
        if (!successful) {
            return Optional.empty();
        }
        int topSide = pos.m_123342_() + 1 + (Integer)dimensions.get(Direction.UP);
        int northSide = pos.m_123343_() - 1 - (Integer)dimensions.get(Direction.NORTH);
        int eastSide = pos.m_123341_() + 1 + (Integer)dimensions.get(Direction.EAST);
        int southSide = pos.m_123343_() + 1 + (Integer)dimensions.get(Direction.SOUTH);
        int westSide = pos.m_123341_() - 1 - (Integer)dimensions.get(Direction.WEST);
        int bottomSide = pos.m_123342_() - 1 - (Integer)dimensions.get(Direction.DOWN);
        BlockPos lowerCorner = new BlockPos(westSide, bottomSide, northSide);
        BlockPos upperCorner = new BlockPos(eastSide, topSide, southSide);
        ArrayList<BlockPos> sides = new ArrayList<BlockPos>();
        float maximumPressure = Float.MAX_VALUE;
        float conductance = 0.0f;
        BlockState weakestBlockState = Blocks.f_50016_.m_49966_();
        for (BlockPos blockPos : BlockPos.m_121940_((BlockPos)lowerCorner, (BlockPos)upperCorner)) {
            int z;
            boolean onZSide;
            int y;
            boolean onYSide;
            int x = blockPos.m_123341_();
            boolean onXSide = x == eastSide || x == westSide;
            if (!(onXSide ^ (onYSide = (y = blockPos.m_123342_()) == topSide || y == bottomSide) ^ (onZSide = (z = blockPos.m_123343_()) == northSide || z == southSide)) || onXSide && onYSide) continue;
            BlockState state = level.m_8055_(blockPos);
            if (!VatMaterial.isValid(state.m_60734_())) {
                successful = false;
                break;
            }
            VatMaterial material = VatMaterial.BLOCK_MATERIALS.get(state.m_60734_());
            if (material.maxPressure() < maximumPressure) {
                maximumPressure = material.maxPressure();
                weakestBlockState = state;
            }
            conductance += material.thermalConductivity();
            sides.add(new BlockPos(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_()));
        }
        if (successful) {
            Vat vat = new Vat(lowerCorner, upperCorner);
            vat.sides = ImmutableList.copyOf(sides);
            vat.maximumPressure = maximumPressure;
            vat.conductance = conductance;
            vat.weakestBlockState = weakestBlockState;
            return Optional.of(vat);
        }
        return Optional.empty();
    }

    public int getCapacity() {
        return (this.upperCorner.m_123341_() - this.getInternalLowerCorner().m_123341_()) * this.getInternalHeight() * (this.upperCorner.m_123343_() - this.getInternalLowerCorner().m_123343_()) * 1000;
    }

    public BlockPos getLowerCorner() {
        return this.lowerCorner;
    }

    public BlockPos getInternalLowerCorner() {
        return this.lowerCorner.m_7494_().m_122029_().m_122019_();
    }

    public BlockPos getUpperCorner() {
        return this.upperCorner;
    }

    public BlockPos getInternalUpperCorner() {
        return this.upperCorner.m_7495_().m_122024_().m_122012_();
    }

    public int getInternalHeight() {
        return this.upperCorner.m_123342_() - this.getInternalLowerCorner().m_123342_();
    }

    public int getInternalWidth() {
        return this.upperCorner.m_123341_() - this.getInternalLowerCorner().m_123341_();
    }

    public int getInternalLength() {
        return this.upperCorner.m_123343_() - this.getInternalLowerCorner().m_123343_();
    }

    public int getVolume() {
        return this.getInternalHeight() * this.getInternalWidth() * this.getInternalLength();
    }

    public Vec3 getCenter() {
        return VecHelper.getCenterOf((Vec3i)this.getInternalLowerCorner()).m_82549_(VecHelper.getCenterOf((Vec3i)this.getInternalUpperCorner())).m_82490_(0.5);
    }

    public Collection<BlockPos> getSideBlockPositions() {
        if (this.sides == null) {
            ArrayList<BlockPos> newSides = new ArrayList<BlockPos>();
            for (BlockPos blockPos : BlockPos.m_121940_((BlockPos)this.lowerCorner, (BlockPos)this.upperCorner)) {
                boolean onZSide;
                boolean onYSide;
                int x = blockPos.m_123341_();
                int y = blockPos.m_123342_();
                int z = blockPos.m_123343_();
                boolean onXSide = x == this.lowerCorner.m_123341_() || x == this.upperCorner.m_123341_();
                if (!(onXSide ^ (onYSide = y == this.lowerCorner.m_123342_() || y == this.upperCorner.m_123342_()) ^ (onZSide = z == this.lowerCorner.m_123343_() || z == this.upperCorner.m_123343_())) || onXSide && onYSide) continue;
                newSides.add(new BlockPos(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_()));
            }
            this.sides = ImmutableList.copyOf(newSides);
        }
        return this.sides;
    }

    public BlockState getWeakestBlock() {
        return this.weakestBlockState;
    }

    public float getMaxPressure() {
        return this.maximumPressure;
    }

    public float getConductance() {
        return this.conductance;
    }

    @Nullable
    public Direction whereIsSideFacing(BlockPos sideBlockPos) {
        if (sideBlockPos.m_123341_() == this.getUpperCorner().m_123341_()) {
            return Direction.EAST;
        }
        if (sideBlockPos.m_123341_() == this.getLowerCorner().m_123341_()) {
            return Direction.WEST;
        }
        if (sideBlockPos.m_123342_() == this.getUpperCorner().m_123342_()) {
            return Direction.UP;
        }
        if (sideBlockPos.m_123342_() == this.getLowerCorner().m_123342_()) {
            return Direction.DOWN;
        }
        if (sideBlockPos.m_123343_() == this.getUpperCorner().m_123343_()) {
            return Direction.SOUTH;
        }
        if (sideBlockPos.m_123343_() == this.getLowerCorner().m_123343_()) {
            return Direction.NORTH;
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void showBoundingBox() {
        CreateClient.OUTLINER.showAABB((Object)Pair.of((Object)"outliner", (Object)this.lowerCorner), new AABB(this.lowerCorner, this.upperCorner), 100).colored(-1322210);
    }

    static {
        VatMaterial.registerDestroyVatMaterials();
    }
}

