/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.util.vat;

import com.petrolpark.destroy.block.DestroyBlocks;
import com.simibubi.create.AllBlocks;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public record VatMaterial(float maxPressure, float thermalConductivity, boolean transparent) {
    public static final Map<Block, VatMaterial> BLOCK_MATERIALS = new HashMap<Block, VatMaterial>();
    public static final VatMaterial UNBREAKABLE = new VatMaterial(Float.MAX_VALUE, 0.0f, false);
    public static final VatMaterial GLASS = new VatMaterial(100000.0f, 15.0f, true);

    public static boolean isValid(Block block) {
        return BLOCK_MATERIALS.containsKey(block);
    }

    public static Optional<VatMaterial> getMaterial(Block block) {
        return Optional.ofNullable(BLOCK_MATERIALS.get(block));
    }

    public static void registerDestroyVatMaterials() {
        BLOCK_MATERIALS.put((Block)DestroyBlocks.VAT_CONTROLLER.get(), UNBREAKABLE);
        BLOCK_MATERIALS.put((Block)AllBlocks.COPPER_CASING.get(), new VatMaterial(1000000.0f, 400.0f, false));
        BLOCK_MATERIALS.put(Blocks.f_50075_, new VatMaterial(500000.0f, 50.0f, false));
        BLOCK_MATERIALS.put(Blocks.f_50058_, GLASS);
        BLOCK_MATERIALS.put(Blocks.f_152498_, new VatMaterial(100000.0f, 12.0f, false));
    }
}

