/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.world.damage;

import com.petrolpark.destroy.chemistry.Molecule;
import com.petrolpark.destroy.world.damage.ChemicalDamageSource;
import com.petrolpark.destroy.world.damage.DestroyDamageTypes;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;

public class DestroyDamageSources {
    public static DamageSource alcohol(Level level) {
        return DestroyDamageSources.source(DestroyDamageTypes.Keys.ALCOHOL, (LevelReader)level);
    }

    public static DamageSource chemicalBurn(Level level) {
        return DestroyDamageSources.source(DestroyDamageTypes.Keys.CHEMICAL_BURN, (LevelReader)level);
    }

    public static ChemicalDamageSource chemicalPoison(Level level, Molecule molecule) {
        return DestroyDamageSources.chemicalSource(DestroyDamageTypes.Keys.CHEMICAL_POISON, (LevelReader)level, molecule);
    }

    public static DamageSource headache(Level level) {
        return DestroyDamageSources.source(DestroyDamageTypes.Keys.HEADACHE, (LevelReader)level);
    }

    public static DamageSource babyBlueOverdose(Level level) {
        return DestroyDamageSources.source(DestroyDamageTypes.Keys.BABY_BLUE_OVERDOSE, (LevelReader)level);
    }

    public static DamageSource selfNeedle(Level level) {
        return DestroyDamageSources.source(DestroyDamageTypes.Keys.SELF_NEEDLE, (LevelReader)level);
    }

    public static DamageSource extrusionDie(Level level) {
        return DestroyDamageSources.source(DestroyDamageTypes.Keys.EXTRUSION_DIE, (LevelReader)level);
    }

    public static DamageSource needle(Level level, Entity entity) {
        return DestroyDamageSources.source(DestroyDamageTypes.Keys.NEEDLE, (LevelReader)level, entity);
    }

    private static DamageSource source(ResourceKey<DamageType> key, LevelReader level) {
        Registry registry = level.m_9598_().m_175515_(Registries.f_268580_);
        return new DamageSource((Holder)registry.m_246971_(key));
    }

    private static DamageSource source(ResourceKey<DamageType> key, LevelReader level, Entity entity) {
        Registry registry = level.m_9598_().m_175515_(Registries.f_268580_);
        return new DamageSource((Holder)registry.m_246971_(key), entity);
    }

    private static ChemicalDamageSource chemicalSource(ResourceKey<DamageType> key, LevelReader level, Molecule molecule) {
        Registry registry = level.m_9598_().m_175515_(Registries.f_268580_);
        return new ChemicalDamageSource((Holder<DamageType>)registry.m_246971_(key), molecule);
    }
}

