/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.world.entity.goal;

import com.petrolpark.destroy.block.entity.behaviour.SentimentalBehaviour;
import com.petrolpark.destroy.item.BucketAndSpadeItem;
import com.petrolpark.destroy.item.DestroyItems;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.phys.Vec3;

public class BuildSandCastleGoal
extends MoveToBlockGoal {
    private int ticksSinceReachedGoal;
    private boolean mustHaveBucketAndSpade;

    public BuildSandCastleGoal(PathfinderMob mob, boolean mustHaveBucketAndSpade) {
        super(mob, 0.5, 15);
        this.mustHaveBucketAndSpade = mustHaveBucketAndSpade;
    }

    public boolean m_8036_() {
        block5: {
            block6: {
                if (!this.mustHaveBucketAndSpade) break block5;
                PathfinderMob pathfinderMob = this.f_25598_;
                if (!(pathfinderMob instanceof Villager)) break block6;
                Villager villager = (Villager)pathfinderMob;
                if (villager.m_35311_().m_216874_(arg_0 -> DestroyItems.BUCKET_AND_SPADE.isIn(arg_0))) break block5;
            }
            return false;
        }
        if (this.f_25600_ > 0) {
            --this.f_25600_;
            return false;
        }
        if (this.tryFindBlock()) {
            this.f_25600_ = BuildSandCastleGoal.m_186073_((int)20);
            return true;
        }
        this.f_25600_ = this.m_6099_(this.f_25598_);
        return false;
    }

    private boolean tryFindBlock() {
        return this.f_25602_ != null && this.m_6465_((LevelReader)this.f_25598_.m_9236_(), this.f_25602_) ? true : this.m_25626_();
    }

    public void m_8056_() {
        this.ticksSinceReachedGoal = 0;
        super.m_8056_();
    }

    public void m_8037_() {
        super.m_8037_();
        Level level = this.f_25598_.m_9236_();
        BlockPos targetPos = this.getPosWithBlock(this.f_25598_.m_20183_(), (BlockGetter)level);
        if (this.m_25625_() && targetPos != null) {
            ++this.ticksSinceReachedGoal;
            BlockState blockState = level.m_8055_(targetPos);
            BlockParticleOption particleData = new BlockParticleOption(ParticleTypes.f_123794_, blockState);
            RandomSource rand = this.f_25598_.m_217043_();
            Vec3 v = Vec3.m_82539_((Vec3i)targetPos.m_7494_());
            if (!level.m_5776_()) {
                ((ServerLevel)level).m_8767_((ParticleOptions)particleData, v.f_82479_, v.f_82480_, v.f_82481_, 3, ((double)rand.m_188501_() - 0.5) * 0.08, ((double)rand.m_188501_() - 0.5) * 0.08, ((double)rand.m_188501_() - 0.5) * 0.08, 0.15);
            }
            if (this.ticksSinceReachedGoal % 12 == 0) {
                level.m_5594_(null, targetPos.m_7494_(), SoundEvents.f_12331_, SoundSource.BLOCKS, 0.5f, 0.9f + rand.m_188501_() * 0.2f);
            }
            if (this.ticksSinceReachedGoal > 60) {
                if (level.m_46597_(targetPos.m_7494_(), BucketAndSpadeItem.getSandCastleForMaterial(blockState))) {
                    PathfinderMob pathfinderMob;
                    SentimentalBehaviour ownerBehaviour = (SentimentalBehaviour)BlockEntityBehaviour.get((BlockGetter)level, (BlockPos)targetPos.m_7494_(), SentimentalBehaviour.TYPE);
                    if (ownerBehaviour != null) {
                        ownerBehaviour.setOwner((LivingEntity)this.f_25598_);
                    }
                    if ((pathfinderMob = this.f_25598_) instanceof Villager) {
                        Villager villager = (Villager)pathfinderMob;
                        if (this.mustHaveBucketAndSpade) {
                            SimpleContainer inv = villager.m_35311_();
                            for (int i = 0; i < inv.m_6643_(); ++i) {
                                ItemStack stack = inv.m_8020_(i);
                                if (!DestroyItems.BUCKET_AND_SPADE.isIn(stack)) continue;
                                stack.m_41622_(1, (LivingEntity)villager, p -> p.m_21190_(InteractionHand.MAIN_HAND));
                            }
                        }
                    }
                }
                this.ticksSinceReachedGoal = 0;
                this.m_8041_();
            }
        }
    }

    @Nullable
    private BlockPos getPosWithBlock(BlockPos pos, BlockGetter level) {
        BlockPos[] possiblePositions;
        if (BucketAndSpadeItem.canSandCastleBeBuiltOn(level.m_8055_(pos), level.m_8055_(pos.m_7494_()))) {
            return pos;
        }
        for (BlockPos possiblePos : possiblePositions = new BlockPos[]{pos.m_7495_(), pos.m_122024_(), pos.m_122029_(), pos.m_122012_(), pos.m_122019_(), pos.m_7495_().m_7495_()}) {
            if (!BucketAndSpadeItem.canSandCastleBeBuiltOn(level.m_8055_(possiblePos), level.m_8055_(pos.m_7494_()))) continue;
            return possiblePos;
        }
        return null;
    }

    protected boolean m_6465_(LevelReader level, BlockPos pos) {
        ChunkAccess chunkAccess = level.m_6522_(SectionPos.m_123171_((int)pos.m_123341_()), SectionPos.m_123171_((int)pos.m_123343_()), ChunkStatus.f_62326_, false);
        if (chunkAccess == null) {
            return false;
        }
        return BucketAndSpadeItem.canSandCastleBeBuiltOn(chunkAccess.m_8055_(pos), chunkAccess.m_8055_(pos.m_7494_()));
    }
}

