/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.world.explosion;

import com.petrolpark.destroy.world.explosion.SmartExplosion;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class ExcavationExplosion
extends SmartExplosion {
    private final BlockPos center;
    private final AABB explosionArea;

    public ExcavationExplosion(Level level, Entity source, BlockPos position, AABB explosionArea) {
        super(level, source, null, null, VecHelper.getCenterOf((Vec3i)position), 0.0f, 0.0f);
        this.center = position;
        this.explosionArea = explosionArea;
    }

    @Override
    public SmartExplosion.ExplosionResult getExplosionResult() {
        HashSet<BlockPos> blocksToExplode = new HashSet<BlockPos>();
        HashSet<BlockPos> blocksTriedToExplode = new HashSet<BlockPos>();
        LinkedList<BlockPos> blocksToTryExplode = new LinkedList<BlockPos>();
        blocksToTryExplode.add(this.center);
        while (!blocksToTryExplode.isEmpty()) {
            BlockPos pos = (BlockPos)blocksToTryExplode.remove();
            if (!this.shouldExplode(pos)) continue;
            blocksToExplode.add(pos);
            for (Direction direction : Direction.values()) {
                BlockPos newPos = pos.m_121945_(direction);
                if (blocksTriedToExplode.contains(newPos)) continue;
                blocksTriedToExplode.add(newPos);
                blocksToTryExplode.add(newPos);
            }
        }
        return new SmartExplosion.ExplosionResult(blocksToExplode, Map.of());
    }

    private boolean shouldExplode(BlockPos pos) {
        if (!this.f_46012_.m_46739_(pos)) {
            return false;
        }
        if (!this.explosionArea.m_82390_(VecHelper.getCenterOf((Vec3i)pos))) {
            return false;
        }
        return this.f_46012_.m_8055_(pos).getExplosionResistance((BlockGetter)this.f_46012_, pos, (Explosion)this) < 1000.0f;
    }

    @Override
    public void effects(boolean spawnParticles) {
        Level level;
        if (this.f_46012_.m_5776_()) {
            this.f_46012_.m_7785_(this.position.f_82479_, this.position.f_82480_, this.position.f_82481_, SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + this.f_46011_.m_188501_() * 0.4f) * 0.7f, false);
        }
        if (spawnParticles && (level = this.f_46012_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (double x = this.explosionArea.f_82288_; x < this.explosionArea.f_82291_; x += 3.0) {
                for (double y = this.explosionArea.f_82289_; y < this.explosionArea.f_82292_; y += 3.0) {
                    for (double z = this.explosionArea.f_82290_; z < this.explosionArea.f_82293_; z += 3.0) {
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123813_, x, y, z, 1, 0.0, 0.0, 0.0, 0.15);
                    }
                }
            }
        }
    }

    @Override
    public void explodeBlock(BlockPos pos) {
    }
}

