/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.world.explosion;

import com.petrolpark.destroy.advancement.DestroyAdvancements;
import com.petrolpark.destroy.world.loot.DestroyLootContextParams;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class SmartExplosion
extends Explosion {
    protected final Vec3 position;
    protected Map<BlockPos, List<ItemStack>> stacksToCreate;
    protected final float smoothness;

    public SmartExplosion(Level level, @Nullable Entity source, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator damageCalculator, Vec3 position, float radius, float smoothness) {
        super(level, source, damageSource, damageCalculator, position.f_82479_, position.f_82480_, position.f_82481_, radius, false, Explosion.BlockInteraction.KEEP);
        this.position = position;
        this.smoothness = smoothness > 1.0f ? 1.0f : smoothness;
        this.stacksToCreate = new HashMap<BlockPos, List<ItemStack>>();
    }

    public void m_46061_() {
        this.f_46012_.m_220400_(this.f_46016_, GameEvent.f_157812_, this.position);
        ExplosionResult result = this.getExplosionResult();
        this.f_46020_.addAll(result.blocksToDestroy());
        List entities = result.entities().keySet().stream().toList();
        ForgeEventFactory.onExplosionDetonate((Level)this.f_46012_, (Explosion)this, entities, (double)(this.f_46017_ * 2.0f));
        for (Entity entity : entities) {
            this.explodeEntity(entity, result.entities().get(entity).floatValue());
        }
    }

    public void m_46075_(boolean spawnParticles) {
        boolean createExperience = this.m_253049_() instanceof Player || this.shouldAlwaysDropExperience();
        for (BlockPos livingEntity : this.f_46020_) {
            BlockState state = this.f_46012_.m_8055_(livingEntity);
            this.explodeBlock(livingEntity);
            Level level = this.f_46012_;
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                state.m_222967_(level2, livingEntity, ItemStack.f_41583_, createExperience);
            }
            state.onBlockExploded(this.f_46012_, livingEntity, (Explosion)this);
        }
        for (Map.Entry entry : this.stacksToCreate.entrySet()) {
            BlockPos pos = (BlockPos)entry.getKey();
            if (!this.f_46012_.m_8055_(pos).canDropFromExplosion((BlockGetter)this.f_46012_, pos, (Explosion)this)) continue;
            for (ItemStack stack : (List)entry.getValue()) {
                Block.m_49840_((Level)this.f_46012_, (BlockPos)pos, (ItemStack)stack);
            }
        }
        LivingEntity livingEntity = this.m_252906_();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            DestroyAdvancements.DETONATE.award(this.f_46012_, player);
        }
        this.effects(spawnParticles);
    }

    public ExplosionResult getExplosionResult() {
        HashSet<BlockPos> blocks = new HashSet<BlockPos>();
        HashMap<Entity, Float> entities = new HashMap<Entity, Float>();
        int resolution = 8;
        float maxMomentum = this.f_46017_ * (1.0f + this.smoothness / 2.0f);
        for (int i = -resolution; i <= resolution; ++i) {
            for (int j = -resolution; j <= resolution; ++j) {
                block2: for (int k = -resolution; k <= resolution; ++k) {
                    if (i != -resolution && i != resolution && j != -resolution && j != resolution && k != -resolution && k != resolution) continue;
                    Vec3 direction = new Vec3((double)i, (double)j, (double)k).m_82541_();
                    Vec3 positionToExplode = new Vec3(this.f_46013_, this.f_46014_, this.f_46015_);
                    for (float momentum = this.f_46017_ * (1.0f - this.smoothness / 2.0f + this.f_46011_.m_188501_() * this.smoothness); momentum > 0.0f; momentum -= 0.225f) {
                        EntityHitResult hitResult = ProjectileUtil.m_37304_((Level)this.f_46012_, (Entity)this.f_46016_, (Vec3)this.position, (Vec3)positionToExplode, (AABB)new AABB(this.position, positionToExplode), entity -> !entity.m_6128_());
                        if (hitResult != null) {
                            Entity entity2 = hitResult.m_82443_();
                            entities.merge(hitResult.m_82443_(), Float.valueOf(momentum / maxMomentum), (existingStrength, strength) -> Float.valueOf(Math.max(existingStrength.floatValue(), strength.floatValue())));
                            if (entity2 instanceof LivingEntity) {
                                LivingEntity livingEntity = (LivingEntity)entity2;
                                momentum = (float)((double)momentum - ((double)0.1f + 0.125 * (1.0 - ProtectionEnchantment.m_45135_((LivingEntity)livingEntity, (double)momentum)) * livingEntity.m_21133_(Attributes.f_22278_)));
                            } else {
                                momentum -= 0.1f;
                            }
                        }
                        BlockPos blockPosToExplode = BlockPos.m_274446_((Position)positionToExplode);
                        BlockState blockState = this.f_46012_.m_8055_(blockPosToExplode);
                        FluidState fluidState = this.f_46012_.m_6425_(blockPosToExplode);
                        if (!this.f_46012_.m_46739_(blockPosToExplode)) continue block2;
                        Optional optional = this.f_46019_.m_6617_((Explosion)this, (BlockGetter)this.f_46012_, blockPosToExplode, blockState, fluidState);
                        if (optional.isPresent()) {
                            momentum -= (((Float)optional.get()).floatValue() + 0.3f) * 0.3f;
                        }
                        if (momentum > 0.0f && this.f_46019_.m_6714_((Explosion)this, (BlockGetter)this.f_46012_, blockPosToExplode, blockState, momentum)) {
                            blocks.add(blockPosToExplode);
                        }
                        positionToExplode = positionToExplode.m_82549_(direction.m_82490_((double)0.3f));
                    }
                }
            }
        }
        return new ExplosionResult(blocks, entities);
    }

    public void explodeBlock(BlockPos pos) {
        BlockState state = this.f_46012_.m_8055_(pos);
        Level level = this.f_46012_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockEntity blockEntity = state.m_155947_() ? this.f_46012_.m_7702_(pos) : null;
            LootParams.Builder builder = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_287286_(LootContextParams.f_81464_, (Object)Float.valueOf(this.f_46017_)).m_287289_(LootContextParams.f_81462_, (Object)blockEntity).m_287289_(LootContextParams.f_81455_, (Object)this.f_46016_).m_287289_(DestroyLootContextParams.SMART_EXPLOSION, (Object)this);
            Entity entity = this.m_253049_();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                builder.m_287239_(player.m_36336_());
            }
            this.modifyLoot(pos, builder);
            this.addBlockDrops(pos, state.m_287290_(builder));
        }
    }

    public void modifyLoot(BlockPos pos, LootParams.Builder builder) {
    }

    public void explodeEntity(Entity entity, float strength) {
        Vec3 knockback = entity.m_20182_().m_82546_(this.position).m_82541_().m_82490_((double)(strength * 5.0f));
        if (entity instanceof LivingEntity) {
            Player player;
            LivingEntity livingEntity = (LivingEntity)entity;
            double damageReduction = ProtectionEnchantment.m_45135_((LivingEntity)livingEntity, (double)1.0);
            livingEntity.m_6469_(this.m_46077_(), this.f_46017_ * strength * (float)damageReduction * 5.0f);
            if (!(!(entity instanceof Player) || (player = (Player)entity).m_5833_() || player.m_7500_() && player.m_150110_().f_35935_)) {
                this.f_46021_.put(player, knockback);
            }
            knockback = knockback.m_82490_(damageReduction);
        }
        entity.m_20256_(entity.m_20184_().m_82549_(knockback));
    }

    public void effects(boolean spawnParticles) {
        if (this.f_46012_.m_5776_()) {
            this.f_46012_.m_7785_(this.position.f_82479_, this.position.f_82480_, this.position.f_82481_, SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + this.f_46011_.m_188501_() * 0.4f) * 0.7f, false);
        }
        if (spawnParticles) {
            if (this.f_46017_ > 2.0f) {
                this.f_46012_.m_7106_((ParticleOptions)ParticleTypes.f_123812_, this.position.f_82479_, this.position.f_82480_, this.position.f_82481_, 1.0, 0.0, 0.0);
            } else {
                this.f_46012_.m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.position.f_82479_, this.position.f_82480_, this.position.f_82481_, 1.0, 0.0, 0.0);
            }
        }
    }

    public boolean shouldDoSpecialDrops() {
        return false;
    }

    public boolean shouldAlwaysDropExperience() {
        return false;
    }

    public float getRadius() {
        return this.f_46017_;
    }

    private void addBlockDrops(BlockPos pos, List<ItemStack> stacks) {
        this.stacksToCreate.merge(pos, stacks, (existingStacks, newStacks) -> {
            existingStacks.addAll(newStacks);
            return existingStacks;
        });
    }

    public record ExplosionResult(Collection<BlockPos> blocksToDestroy, Map<Entity, Float> entities) {
        public ExplosionResult {
            Objects.requireNonNullElse(blocksToDestroy, List.of());
            Objects.requireNonNullElse(entities, Map.of());
        }
    }
}

