/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.world.loot.providers.number;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.petrolpark.destroy.capability.level.pollution.LevelPollution;
import com.petrolpark.destroy.util.PollutionHelper;
import com.petrolpark.destroy.world.loot.providers.number.DestroyNumberProviders;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class PollutionNumberProvider
implements NumberProvider {
    private final LevelPollution.PollutionType pollutionType;
    private float scale;
    private boolean invert;

    public PollutionNumberProvider(LevelPollution.PollutionType pollutionType) {
        this.pollutionType = pollutionType;
        this.scale = 1.0f;
        this.invert = false;
    }

    public float m_142688_(LootContext lootContext) {
        float rawProportion = (float)PollutionHelper.getPollution((Level)lootContext.m_78952_(), this.pollutionType) / (float)this.pollutionType.max;
        if (this.invert) {
            rawProportion = 1.0f - rawProportion;
        }
        return rawProportion * this.scale;
    }

    public LootNumberProviderType m_142587_() {
        return (LootNumberProviderType)DestroyNumberProviders.POLLUTION.get();
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<PollutionNumberProvider> {
        public void serialize(JsonObject json, PollutionNumberProvider numberProvider, JsonSerializationContext serializationContext) {
            json.addProperty("pollution_type", numberProvider.toString());
            json.addProperty("scale", (Number)Float.valueOf(numberProvider.scale));
            json.addProperty("invert", Boolean.valueOf(numberProvider.invert));
        }

        public PollutionNumberProvider deserialize(JsonObject json, JsonDeserializationContext serializationContext) {
            PollutionNumberProvider numberProvider = new PollutionNumberProvider(LevelPollution.PollutionType.valueOf(GsonHelper.m_13906_((JsonObject)json, (String)"pollution_type")));
            numberProvider.scale = GsonHelper.m_13820_((JsonObject)json, (String)"scale", (float)1.0f);
            numberProvider.invert = GsonHelper.m_13855_((JsonObject)json, (String)"invert", (boolean)false);
            return numberProvider;
        }
    }
}

