/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import committee.nova.mods.avaritia.api.client.model.ItemQuadBakery;
import committee.nova.mods.avaritia.api.client.model.PerspectiveModelState;
import committee.nova.mods.avaritia.api.client.model.bakedmodels.WrappedItemModel;
import committee.nova.mods.avaritia.api.client.render.item.IItemRenderer;
import committee.nova.mods.avaritia.client.shader.AvaritiaShaders;
import committee.nova.mods.avaritia.common.item.MatterClusterItem;
import committee.nova.mods.avaritia.init.registry.ModItems;
import committee.nova.mods.avaritia.util.client.TransformUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CosmicBakeModel
extends WrappedItemModel
implements IItemRenderer {
    private final List<BakedQuad> maskQuads;
    private final ItemOverrides overrideList = new ItemOverrides(){

        public BakedModel m_173464_(@NotNull BakedModel originalModel, @NotNull ItemStack stack, @javax.annotation.Nullable ClientLevel world, @javax.annotation.Nullable LivingEntity entity, int seed) {
            CosmicBakeModel.this.entity = entity;
            CosmicBakeModel.this.world = world == null ? (entity == null ? null : (ClientLevel)entity.m_9236_()) : null;
            return CosmicBakeModel.this.wrapped.m_7343_().m_173464_(originalModel, stack, world, entity, seed);
        }
    };

    public CosmicBakeModel(BakedModel wrapped, TextureAtlasSprite maskSprite) {
        super(wrapped);
        this.maskQuads = ItemQuadBakery.bakeItem(maskSprite);
    }

    @Override
    public void renderItem(ItemStack stack, ItemDisplayContext transformType, PoseStack pStack, MultiBufferSource source, int light, int overlay) {
        if (stack.m_41720_() == ModItems.infinity_sword.get()) {
            this.parentState = TransformUtils.DEFAULT_TOOL;
        }
        if (stack.m_41720_() == ModItems.infinity_bow.get()) {
            this.parentState = TransformUtils.DEFAULT_BOW;
        }
        if (stack.m_41720_() != ModItems.infinity_bow.get() && stack.m_41720_() != ModItems.infinity_sword.get()) {
            this.parentState = TransformUtils.DEFAULT_ITEM;
        }
        this.renderWrapped(stack, pStack, source, light, overlay, true);
        if (source instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource bs = (MultiBufferSource.BufferSource)source;
            bs.m_109911_();
        }
        Minecraft mc = Minecraft.m_91087_();
        float yaw = 0.0f;
        float pitch = 0.0f;
        float scale = 25.0f;
        if (!AvaritiaShaders.inventoryRender) {
            yaw = (float)((double)(mc.f_91074_.m_146908_() * 2.0f) * Math.PI / 360.0);
            pitch = -((float)((double)(mc.f_91074_.m_146909_() * 2.0f) * Math.PI / 360.0));
            scale = 1.0f;
        }
        if (stack.m_41720_() == ModItems.matter_cluster.get()) {
            AvaritiaShaders.cosmicOpacity.m_5985_((float)MatterClusterItem.getClusterSize(stack) / (float)MatterClusterItem.CAPACITY);
        } else {
            AvaritiaShaders.cosmicOpacity.m_5985_(1.0f);
        }
        AvaritiaShaders.cosmicYaw.m_5985_(yaw);
        AvaritiaShaders.cosmicPitch.m_5985_(pitch);
        AvaritiaShaders.cosmicExternalScale.m_5985_(scale);
        VertexConsumer cons = source.m_6299_(AvaritiaShaders.COSMIC_RENDER_TYPE);
        mc.m_91291_().m_115162_(pStack, cons, this.maskQuads, stack, light, overlay);
    }

    @Override
    @Nullable
    public PerspectiveModelState getModelState() {
        return (PerspectiveModelState)this.parentState;
    }

    @Override
    @NotNull
    public ItemOverrides m_7343_() {
        return this.overrideList;
    }
}

