/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import committee.nova.mods.avaritia.client.model.CosmicBakeModel;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;

public class CosmicModelLoader
implements IGeometryLoader<CosmicGeometry> {
    public static final CosmicModelLoader INSTANCE = new CosmicModelLoader();

    public CosmicGeometry read(JsonObject modelContents, JsonDeserializationContext deserializationContext) throws JsonParseException {
        JsonObject cosmicObj = modelContents.getAsJsonObject("cosmic");
        if (cosmicObj == null) {
            throw new IllegalStateException("Missing 'cosmic' object.");
        }
        String maskTexture = GsonHelper.m_13906_((JsonObject)cosmicObj, (String)"mask");
        JsonObject clean = modelContents.deepCopy();
        clean.remove("cosmic");
        clean.remove("loader");
        BlockModel baseModel = (BlockModel)deserializationContext.deserialize((JsonElement)clean, BlockModel.class);
        return new CosmicGeometry(baseModel, maskTexture);
    }

    public static class CosmicGeometry
    implements IUnbakedGeometry<CosmicGeometry> {
        private final BlockModel baseModel;
        private final String maskTexture;
        Material maskMaterial;

        public CosmicGeometry(BlockModel baseModel, String maskTexture) {
            this.baseModel = baseModel;
            this.maskTexture = maskTexture;
        }

        public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
            BakedModel baseBakedModel = this.baseModel.m_111449_(baker, this.baseModel, spriteGetter, modelState, modelLocation, true);
            this.maskMaterial = context.getMaterial(this.maskTexture);
            return new CosmicBakeModel(baseBakedModel, spriteGetter.apply(this.maskMaterial));
        }

        public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context) {
            this.baseModel.m_5500_(modelGetter);
        }
    }
}

