/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import committee.nova.mods.avaritia.Static;
import committee.nova.mods.avaritia.client.shader.AvaritiaShaders;
import committee.nova.mods.avaritia.init.registry.ModItems;
import committee.nova.mods.avaritia.util.AbilityUtils;
import committee.nova.mods.avaritia.util.client.ColorUtils;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class InfinityArmorModel
extends HumanoidModel<Player> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("avaritia", "infinity_armor"), "main");
    private final ResourceLocation eyeTex = Static.rl("textures/models/infinity_armor_eyes.png");
    private final ResourceLocation wingTex = Static.rl("textures/models/infinity_armor_wing.png");
    private final ResourceLocation wingGlowTex = Static.rl("textures/models/infinity_armor_wingglow.png");
    private static boolean modelRender;
    private static boolean playerFlying;
    private static boolean player;
    private static boolean legs;
    private final Minecraft mc = Minecraft.m_91087_();
    private final MultiBufferSource bufferSource = this.mc.m_91269_().m_110104_();
    private final Random random = new Random();
    private final HumanoidModel<Player> humanoidModel = new HumanoidModel(InfinityArmorModel.m_170681_((CubeDeformation)new CubeDeformation(0.0f), (float)0.0f).m_171576_().m_171583_(64, 64));
    public static TextureAtlasSprite MASK;
    public static TextureAtlasSprite MASK_INV;
    public static TextureAtlasSprite WING;

    public InfinityArmorModel(ModelPart pRoot, int x) {
        super(InfinityArmorModel.m_170681_((CubeDeformation)new CubeDeformation(1.0f), (float)0.0f).m_171576_().m_171583_(64, 64));
    }

    public InfinityArmorModel(ModelPart pRoot) {
        super(pRoot);
    }

    private RenderType glow(ResourceLocation tex) {
        return RenderType.m_173209_((String)"", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)0, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderType.f_173103_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(tex, false, false)).m_110685_(RenderType.f_110136_).m_110661_(RenderType.f_110110_).m_110669_(RenderType.f_110119_).m_110691_(true));
    }

    private RenderType mask(ResourceLocation tex) {
        return RenderType.m_173209_((String)"", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)0, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(() -> AvaritiaShaders.cosmicShader)).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(tex, false, false)).m_110685_(RenderType.f_110139_).m_110671_(RenderType.f_110152_).m_110687_(RenderStateShard.f_110115_).m_110661_(RenderType.f_110110_).m_110669_(RenderType.f_110119_).m_110691_(true));
    }

    private static RenderType mask2(ResourceLocation tex) {
        return RenderType.m_173209_((String)"", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)0, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(() -> AvaritiaShaders.cosmicShader2)).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(tex, false, false)).m_110685_(RenderType.f_110139_).m_110671_(RenderType.f_110152_).m_110687_(RenderStateShard.f_110115_).m_110661_(RenderType.f_110110_).m_110691_(true));
    }

    public static MeshDefinition createMesh(CubeDeformation deformation, float f, boolean islegs) {
        legs = islegs;
        boolean heightoffset = false;
        int legoffset = islegs ? 32 : 0;
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition p = meshDefinition.m_171576_();
        p.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, deformation), PartPose.m_171419_((float)0.0f, (float)(0.0f + f), (float)0.0f));
        p.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        p.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, deformation), PartPose.m_171419_((float)0.0f, (float)(0.0f + f), (float)0.0f));
        p.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, deformation), PartPose.m_171419_((float)-5.0f, (float)(2.0f + f), (float)0.0f));
        p.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171480_().m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, deformation), PartPose.m_171419_((float)5.0f, (float)(2.0f + f), (float)0.0f));
        p.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, deformation), PartPose.m_171419_((float)-1.9f, (float)(12.0f + f), (float)0.0f));
        p.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, deformation), PartPose.m_171419_((float)1.9f, (float)(12.0f + f), (float)0.0f));
        if (islegs) {
            p.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 16 + legoffset).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
            p.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 16 + legoffset).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
            p.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 16 + legoffset).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
        }
        return meshDefinition;
    }

    private LayerDefinition rebuildWings() {
        MeshDefinition m = new MeshDefinition();
        PartDefinition p = m.m_171576_();
        p.m_171599_("bipedRightWing", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171488_(0.0f, -11.6f, 0.0f, 0.0f, 32.0f, 32.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.5f, (float)0.0f, (float)2.0f, (float)0.0f, (float)1.2566371f, (float)0.0f));
        p.m_171599_("bipedLeftWing", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(0.0f, -11.6f, 0.0f, 0.0f, 32.0f, 32.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.5f, (float)0.0f, (float)2.0f, (float)0.0f, (float)-1.2566371f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)m, (int)64, (int)64);
    }

    private void renderToBufferWing(@NotNull PoseStack pPoseStack, @NotNull VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, float pRed, float pGreen, float pBlue, float pAlpha) {
        ModelPart h = this.rebuildWings().m_171564_();
        ModelPart bipedRightWing = h.m_171324_("bipedRightWing");
        ModelPart bipedLeftWing = h.m_171324_("bipedLeftWing");
        bipedRightWing.m_104306_(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha);
        bipedLeftWing.m_104306_(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha);
    }

    public void m_7695_(@NotNull PoseStack pPoseStack, @NotNull VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, float pRed, float pGreen, float pBlue, float pAlpha) {
        float f3;
        float f2;
        float f;
        InfinityArmorModel model = new InfinityArmorModel(this.rebuildWings().m_171564_(), 0);
        this.copyBipedAngles(this, this.humanoidModel);
        super.m_7695_(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha);
        long time = this.mc.f_91074_.m_9236_().m_46467_();
        double pulse = Math.sin((double)time / 10.0) * 0.5 + 0.5;
        double pulse_mag_sqr = pulse * pulse * pulse * pulse * pulse * pulse;
        if (this.f_102610_) {
            f = 1.5f / this.f_102010_;
            f2 = 1.0f / this.f_102011_;
            f3 = 1.0f;
        } else {
            f = 1.0f;
            f2 = 1.0f;
            f3 = 0.0f;
        }
        AvaritiaShaders.cosmicOpacity.m_5985_(1.0f);
        AvaritiaShaders.cosmicOpacity2.m_5985_(0.2f);
        if (AvaritiaShaders.inventoryRender) {
            AvaritiaShaders.cosmicExternalScale.m_5985_(25.0f);
        } else {
            AvaritiaShaders.cosmicExternalScale.m_5985_(1.0f);
            AvaritiaShaders.cosmicYaw.m_5985_((float)((double)(this.mc.f_91074_.m_146908_() * 2.0f) * Math.PI / 360.0));
            AvaritiaShaders.cosmicPitch.m_5985_(-((float)((double)(this.mc.f_91074_.m_146909_() * 2.0f) * Math.PI / 360.0)));
        }
        pPoseStack.m_85836_();
        pPoseStack.m_85841_(f, f, f);
        pPoseStack.m_85837_(0.0, (double)(this.f_170338_ / 16.0f * f3), 0.0);
        this.f_102808_.m_104306_(pPoseStack, InfinityArmorModel.material(MASK).m_119194_(this.bufferSource, this::mask), pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha);
        if (modelRender && !player) {
            this.hatsOver().forEach(t -> t.m_104306_(pPoseStack, InfinityArmorModel.material(MASK_INV).m_119194_(this.bufferSource, InfinityArmorModel::mask2), pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha));
        }
        pPoseStack.m_85849_();
        pPoseStack.m_85836_();
        pPoseStack.m_85841_(f2, f2, f2);
        pPoseStack.m_85837_(0.0, (double)(this.f_102012_ / 16.0f * f3), 0.0);
        if (modelRender && !player) {
            this.bodyPartsOver().forEach(t -> t.m_104306_(pPoseStack, InfinityArmorModel.material(MASK_INV).m_119194_(this.bufferSource, InfinityArmorModel::mask2), pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha));
        }
        this.m_5608_().forEach(t -> t.m_104306_(pPoseStack, this.vertex(this.glow(this.eyeTex)), pPackedLight, pPackedOverlay, 0.84f, 1.0f, 0.95f, (float)(pulse_mag_sqr * 0.5)));
        pPoseStack.m_85849_();
        pPoseStack.m_85836_();
        this.random.setSeed(time / 3L * 1723609L);
        float[] col = ColorUtils.HSVtoRGB(this.random.nextFloat() * 6.0f, 1.0f, 1.0f);
        pPoseStack.m_85841_(f, f, f);
        pPoseStack.m_85837_(0.0, (double)(this.f_170338_ / 16.0f * f3), (double)-0.03f);
        this.f_102809_.m_104306_(pPoseStack, InfinityArmorModel.material(MASK).m_119194_(this.bufferSource, this::mask), pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha);
        if (modelRender) {
            this.f_102809_.m_104306_(pPoseStack, this.vertex((RenderType)RenderType.m_173209_((String)"", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)0, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderType.f_173101_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(this.eyeTex, false, false)).m_110661_(RenderType.f_110110_).m_110691_(true))), pPackedLight, pPackedOverlay, col[0], col[1], col[2], 1.0f);
        }
        pPoseStack.m_85849_();
        if (playerFlying && !AvaritiaShaders.inventoryRender) {
            pPoseStack.m_85836_();
            this.rebuildWings();
            pPoseStack.m_85841_(f2, f2, f2);
            pPoseStack.m_85837_(0.0, (double)(this.f_102012_ / 16.0f * f3), 0.0);
            model.renderToBufferWing(pPoseStack, this.mc.m_91269_().m_110104_().m_6299_(RenderType.m_110431_((ResourceLocation)this.wingTex)), pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha);
            model.renderToBufferWing(pPoseStack, this.mc.m_91269_().m_110104_().m_6299_(this.glow(this.wingGlowTex)), pPackedLight, pPackedOverlay, 0.84f, 1.0f, 0.95f, (float)(pulse_mag_sqr * 0.5));
            pPoseStack.m_85849_();
        }
    }

    public void update(LivingEntity e, ItemStack itemStack, EquipmentSlot equipmentSlot) {
        boolean hasFoot;
        modelRender = false;
        playerFlying = false;
        player = false;
        ItemStack hats = e.m_6844_(EquipmentSlot.HEAD);
        ItemStack chest = e.m_6844_(EquipmentSlot.CHEST);
        ItemStack leg = e.m_6844_(EquipmentSlot.LEGS);
        ItemStack foot = e.m_6844_(EquipmentSlot.FEET);
        boolean hasHat = hats.m_41720_() == ModItems.infinity_helmet.get();
        boolean hasChest = chest.m_41720_() == ModItems.infinity_chestplate.get();
        boolean hasLeg = leg.m_41720_() == ModItems.infinity_pants.get();
        boolean bl = hasFoot = foot.m_41720_() == ModItems.infinity_boots.get();
        if (hasHat && hasChest && hasLeg && hasFoot) {
            modelRender = true;
        }
        if (e instanceof Player) {
            player = true;
            if (hasChest && ((Player)e).m_150110_().f_35935_) {
                playerFlying = true;
            }
        }
        this.f_102817_ = e.m_6047_();
        this.f_102610_ = e.m_6162_();
        this.f_102609_ = e.m_20159_();
    }

    public VertexConsumer vertex(RenderType t) {
        return this.bufferSource.m_6299_(t);
    }

    public static Material material(TextureAtlasSprite t) {
        return new Material(InventoryMenu.f_39692_, t.m_247685_());
    }

    @NotNull
    public Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.f_102810_, (Object)this.f_102811_, (Object)this.f_102812_, (Object)this.f_102813_, (Object)this.f_102814_);
    }

    public Iterable<ModelPart> hatsOver() {
        return ImmutableList.of((Object)this.humanoidModel.f_102809_, (Object)this.humanoidModel.f_102808_);
    }

    public Iterable<ModelPart> bodyPartsOver() {
        return ImmutableList.of((Object)this.humanoidModel.f_102810_, (Object)this.humanoidModel.f_102811_, (Object)this.humanoidModel.f_102812_, (Object)this.humanoidModel.f_102813_, (Object)this.humanoidModel.f_102814_);
    }

    private void copyPartAngles(ModelPart from, ModelPart to) {
        to.f_104203_ = from.f_104203_;
        to.f_104204_ = from.f_104204_;
        to.f_104205_ = from.f_104205_;
        to.f_104200_ = from.f_104200_;
        to.f_104201_ = from.f_104201_;
        to.f_104202_ = from.f_104202_;
    }

    private void copyBipedAngles(HumanoidModel<Player> from, HumanoidModel<Player> to) {
        this.copyPartAngles(from.f_102808_, to.f_102808_);
        this.copyPartAngles(from.f_102809_, to.f_102809_);
        this.copyPartAngles(from.f_102810_, to.f_102810_);
        this.copyPartAngles(from.f_102812_, to.f_102812_);
        this.copyPartAngles(from.f_102814_, to.f_102814_);
        this.copyPartAngles(from.f_102811_, to.f_102811_);
        this.copyPartAngles(from.f_102813_, to.f_102813_);
    }

    static {
        legs = true;
        MASK = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("avaritia", "models/infinity_armor_mask"));
        MASK_INV = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("avaritia", "models/infinity_armor_mask_inv"));
        WING = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("avaritia", "models/infinity_armor_mask_wings"));
    }

    public static class PlayerRender
    extends RenderLayer<Player, PlayerModel<Player>> {
        public Iterable<ModelPart> playerParts() {
            return ImmutableList.of((Object)((PlayerModel)this.m_117386_()).f_102808_, (Object)((PlayerModel)this.m_117386_()).f_102809_, (Object)((PlayerModel)this.m_117386_()).f_102810_, (Object)((PlayerModel)this.m_117386_()).f_102812_, (Object)((PlayerModel)this.m_117386_()).f_102811_, (Object)((PlayerModel)this.m_117386_()).f_102814_, (Object)((PlayerModel)this.m_117386_()).f_102813_);
        }

        public PlayerRender(RenderLayerParent<Player, PlayerModel<Player>> t) {
            super(t);
        }

        public void render(@NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBuffer, int pPackedLight, @NotNull Player l, float pLimbSwing, float pLimbSwingAmount, float pPartialTick, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
            if (AbilityUtils.isInfinite((LivingEntity)l)) {
                AvaritiaShaders.cosmicOpacity2.m_5985_(0.8f);
                this.playerParts().forEach(t -> t.m_104306_(pPoseStack, InfinityArmorModel.material(MASK_INV).m_119194_(pBuffer, InfinityArmorModel::mask2), pPackedLight, 1, 1.0f, 1.0f, 1.0f, 1.0f));
            }
        }
    }
}

