/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.block;

import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CompressChestBlock
extends AbstractChestBlock<ChestBlockEntity>
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<ChestType> TYPE = BlockStateProperties.f_61392_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final int EVENT_SET_OPEN_COUNT = 1;
    protected static final int AABB_OFFSET = 1;
    protected static final int AABB_HEIGHT = 14;
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)14.0, (double)15.0);
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)14.0, (double)15.0);
    protected static final VoxelShape AABB = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    private static final DoubleBlockCombiner.Combiner<ChestBlockEntity, Optional<Container>> CHEST_COMBINER = new DoubleBlockCombiner.Combiner<ChestBlockEntity, Optional<Container>>(){

        public Optional<Container> acceptDouble(ChestBlockEntity p_51591_, ChestBlockEntity p_51592_) {
            return Optional.of(new CompoundContainer((Container)p_51591_, (Container)p_51592_));
        }

        public Optional<Container> acceptSingle(ChestBlockEntity p_51589_) {
            return Optional.of(p_51589_);
        }

        public Optional<Container> acceptNone() {
            return Optional.empty();
        }
    };
    private static final DoubleBlockCombiner.Combiner<ChestBlockEntity, Optional<MenuProvider>> MENU_PROVIDER_COMBINER = new DoubleBlockCombiner.Combiner<ChestBlockEntity, Optional<MenuProvider>>(){

        public Optional<MenuProvider> acceptDouble(final ChestBlockEntity p_51604_, final ChestBlockEntity p_51605_) {
            CompoundContainer container = new CompoundContainer((Container)p_51604_, (Container)p_51605_);
            return Optional.of(new MenuProvider(){
                final /* synthetic */ Container val$container;
                {
                    this.val$container = container;
                }

                @Nullable
                public AbstractContainerMenu m_7208_(int p_51622_, Inventory p_51623_, Player p_51624_) {
                    if (p_51604_.m_7525_(p_51624_) && p_51605_.m_7525_(p_51624_)) {
                        p_51604_.m_59640_(p_51623_.f_35978_);
                        p_51605_.m_59640_(p_51623_.f_35978_);
                        return ChestMenu.m_39246_((int)p_51622_, (Inventory)p_51623_, (Container)this.val$container);
                    }
                    return null;
                }

                public Component m_5446_() {
                    if (p_51604_.m_8077_()) {
                        return p_51604_.m_5446_();
                    }
                    return p_51605_.m_8077_() ? p_51605_.m_5446_() : Component.m_237115_((String)"container.chestDouble");
                }
            });
        }

        public Optional<MenuProvider> acceptSingle(ChestBlockEntity p_51602_) {
            return Optional.of(p_51602_);
        }

        public Optional<MenuProvider> acceptNone() {
            return Optional.empty();
        }
    };

    public CompressChestBlock(BlockBehaviour.Properties p_51490_, Supplier<BlockEntityType<? extends ChestBlockEntity>> p_51491_) {
        super(p_51490_, p_51491_);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(TYPE, (Comparable)ChestType.SINGLE)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public static DoubleBlockCombiner.BlockType getBlockType(BlockState p_51583_) {
        ChestType chesttype = (ChestType)p_51583_.m_61143_(TYPE);
        if (chesttype == ChestType.SINGLE) {
            return DoubleBlockCombiner.BlockType.SINGLE;
        }
        return chesttype == ChestType.RIGHT ? DoubleBlockCombiner.BlockType.FIRST : DoubleBlockCombiner.BlockType.SECOND;
    }

    public RenderShape m_7514_(BlockState p_51567_) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public BlockState m_7417_(BlockState p_51555_, Direction p_51556_, BlockState p_51557_, LevelAccessor p_51558_, BlockPos p_51559_, BlockPos p_51560_) {
        if (((Boolean)p_51555_.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            p_51558_.m_186469_(p_51559_, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)p_51558_));
        }
        if (p_51557_.m_60713_((Block)this) && p_51556_.m_122434_().m_122479_()) {
            ChestType chesttype = (ChestType)p_51557_.m_61143_(TYPE);
            if (p_51555_.m_61143_(TYPE) == ChestType.SINGLE && chesttype != ChestType.SINGLE && p_51555_.m_61143_((Property)FACING) == p_51557_.m_61143_((Property)FACING) && CompressChestBlock.getConnectedDirection(p_51557_) == p_51556_.m_122424_()) {
                return (BlockState)p_51555_.m_61124_(TYPE, (Comparable)chesttype.m_61486_());
            }
        } else if (CompressChestBlock.getConnectedDirection(p_51555_) == p_51556_) {
            return (BlockState)p_51555_.m_61124_(TYPE, (Comparable)ChestType.SINGLE);
        }
        return super.m_7417_(p_51555_, p_51556_, p_51557_, p_51558_, p_51559_, p_51560_);
    }

    public VoxelShape m_5940_(BlockState p_51569_, BlockGetter p_51570_, BlockPos p_51571_, CollisionContext p_51572_) {
        if (p_51569_.m_61143_(TYPE) == ChestType.SINGLE) {
            return AABB;
        }
        switch (CompressChestBlock.getConnectedDirection(p_51569_)) {
            default: {
                return NORTH_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case EAST: 
        }
        return EAST_AABB;
    }

    public static Direction getConnectedDirection(BlockState p_51585_) {
        Direction direction = (Direction)p_51585_.m_61143_((Property)FACING);
        return p_51585_.m_61143_(TYPE) == ChestType.LEFT ? direction.m_122427_() : direction.m_122428_();
    }

    public BlockState m_5573_(BlockPlaceContext p_51493_) {
        Direction direction2;
        ChestType chesttype = ChestType.SINGLE;
        Direction direction = p_51493_.m_8125_().m_122424_();
        FluidState fluidstate = p_51493_.m_43725_().m_6425_(p_51493_.m_8083_());
        boolean flag = p_51493_.m_7078_();
        Direction direction1 = p_51493_.m_43719_();
        if (direction1.m_122434_().m_122479_() && flag && (direction2 = this.candidatePartnerFacing(p_51493_, direction1.m_122424_())) != null && direction2.m_122434_() != direction1.m_122434_()) {
            direction = direction2;
            ChestType chestType = chesttype = direction2.m_122428_() == direction1.m_122424_() ? ChestType.RIGHT : ChestType.LEFT;
        }
        if (chesttype == ChestType.SINGLE && !flag) {
            if (direction == this.candidatePartnerFacing(p_51493_, direction.m_122427_())) {
                chesttype = ChestType.LEFT;
            } else if (direction == this.candidatePartnerFacing(p_51493_, direction.m_122428_())) {
                chesttype = ChestType.RIGHT;
            }
        }
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction)).m_61124_(TYPE, (Comparable)chesttype)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState p_51581_) {
        return (Boolean)p_51581_.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_51581_);
    }

    @Nullable
    private Direction candidatePartnerFacing(BlockPlaceContext p_51495_, Direction p_51496_) {
        BlockState blockstate = p_51495_.m_43725_().m_8055_(p_51495_.m_8083_().m_121945_(p_51496_));
        return blockstate.m_60713_((Block)this) && blockstate.m_61143_(TYPE) == ChestType.SINGLE ? (Direction)blockstate.m_61143_((Property)FACING) : null;
    }

    public void m_6402_(Level p_51503_, BlockPos p_51504_, BlockState p_51505_, LivingEntity p_51506_, ItemStack p_51507_) {
        BlockEntity blockentity;
        if (p_51507_.m_41788_() && (blockentity = p_51503_.m_7702_(p_51504_)) instanceof ChestBlockEntity) {
            ((ChestBlockEntity)blockentity).m_58638_(p_51507_.m_41786_());
        }
    }

    public void m_6810_(BlockState p_51538_, Level p_51539_, BlockPos p_51540_, BlockState p_51541_, boolean p_51542_) {
        if (!p_51538_.m_60713_(p_51541_.m_60734_())) {
            BlockEntity blockentity = p_51539_.m_7702_(p_51540_);
            if (blockentity instanceof Container) {
                Containers.m_19002_((Level)p_51539_, (BlockPos)p_51540_, (Container)((Container)blockentity));
                p_51539_.m_46717_(p_51540_, (Block)this);
            }
            super.m_6810_(p_51538_, p_51539_, p_51540_, p_51541_, p_51542_);
        }
    }

    public InteractionResult m_6227_(BlockState p_51531_, Level p_51532_, BlockPos p_51533_, Player p_51534_, InteractionHand p_51535_, BlockHitResult p_51536_) {
        if (p_51532_.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        MenuProvider menuprovider = this.m_7246_(p_51531_, p_51532_, p_51533_);
        if (menuprovider != null) {
            p_51534_.m_5893_(menuprovider);
            p_51534_.m_36246_(this.getOpenChestStat());
            PiglinAi.m_34873_((Player)p_51534_, (boolean)true);
        }
        return InteractionResult.CONSUME;
    }

    protected Stat<ResourceLocation> getOpenChestStat() {
        return Stats.f_12988_.m_12902_((Object)Stats.f_12968_);
    }

    public BlockEntityType<? extends ChestBlockEntity> blockEntityType() {
        return (BlockEntityType)this.f_48675_.get();
    }

    @Nullable
    public static Container getContainer(CompressChestBlock p_51512_, BlockState p_51513_, Level p_51514_, BlockPos p_51515_, boolean p_51516_) {
        return ((Optional)p_51512_.m_5641_(p_51513_, p_51514_, p_51515_, p_51516_).m_5649_(CHEST_COMBINER)).orElse(null);
    }

    public DoubleBlockCombiner.NeighborCombineResult<? extends ChestBlockEntity> m_5641_(BlockState p_51544_, Level p_51545_, BlockPos p_51546_, boolean p_51547_) {
        BiPredicate<LevelAccessor, BlockPos> bipredicate = p_51547_ ? (p_51578_, p_51579_) -> false : ChestBlock::m_51508_;
        return DoubleBlockCombiner.m_52822_((BlockEntityType)((BlockEntityType)this.f_48675_.get()), ChestBlock::m_51582_, ChestBlock::m_51584_, (DirectionProperty)FACING, (BlockState)p_51544_, (LevelAccessor)p_51545_, (BlockPos)p_51546_, bipredicate);
    }

    @Nullable
    public MenuProvider m_7246_(BlockState p_51574_, Level p_51575_, BlockPos p_51576_) {
        return ((Optional)this.m_5641_(p_51574_, p_51575_, p_51576_, false).m_5649_(MENU_PROVIDER_COMBINER)).orElse(null);
    }

    public static DoubleBlockCombiner.Combiner<ChestBlockEntity, Float2FloatFunction> opennessCombiner(final LidBlockEntity p_51518_) {
        return new DoubleBlockCombiner.Combiner<ChestBlockEntity, Float2FloatFunction>(){

            public Float2FloatFunction acceptDouble(ChestBlockEntity p_51633_, ChestBlockEntity p_51634_) {
                return p_51638_ -> Math.max(p_51633_.m_6683_(p_51638_), p_51634_.m_6683_(p_51638_));
            }

            public Float2FloatFunction acceptSingle(ChestBlockEntity p_51631_) {
                return arg_0 -> ((ChestBlockEntity)p_51631_).m_6683_(arg_0);
            }

            public Float2FloatFunction acceptNone() {
                return arg_0 -> ((LidBlockEntity)p_51518_).m_6683_(arg_0);
            }
        };
    }

    public BlockEntity m_142194_(BlockPos p_153064_, BlockState p_153065_) {
        return new ChestBlockEntity(p_153064_, p_153065_);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level p_153055_, BlockState p_153056_, BlockEntityType<T> p_153057_) {
        return p_153055_.f_46443_ ? CompressChestBlock.m_152132_(p_153057_, this.blockEntityType(), ChestBlockEntity::m_155343_) : null;
    }

    public static boolean isChestBlockedAt(LevelAccessor p_51509_, BlockPos p_51510_) {
        return CompressChestBlock.isBlockedChestByBlock((BlockGetter)p_51509_, p_51510_) || CompressChestBlock.isCatSittingOnChest(p_51509_, p_51510_);
    }

    private static boolean isBlockedChestByBlock(BlockGetter p_51500_, BlockPos p_51501_) {
        BlockPos blockpos = p_51501_.m_7494_();
        return p_51500_.m_8055_(blockpos).m_60796_(p_51500_, blockpos);
    }

    private static boolean isCatSittingOnChest(LevelAccessor p_51564_, BlockPos p_51565_) {
        List list = p_51564_.m_45976_(Cat.class, new AABB((double)p_51565_.m_123341_(), (double)(p_51565_.m_123342_() + 1), (double)p_51565_.m_123343_(), (double)(p_51565_.m_123341_() + 1), (double)(p_51565_.m_123342_() + 2), (double)(p_51565_.m_123343_() + 1)));
        if (!list.isEmpty()) {
            for (Cat cat : list) {
                if (!cat.m_21825_()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean m_7278_(BlockState p_51520_) {
        return true;
    }

    public int m_6782_(BlockState p_51527_, Level p_51528_, BlockPos p_51529_) {
        return AbstractContainerMenu.m_38938_((Container)CompressChestBlock.getContainer(this, p_51527_, p_51528_, p_51529_, false));
    }

    public BlockState m_6843_(BlockState p_51552_, Rotation p_51553_) {
        return (BlockState)p_51552_.m_61124_((Property)FACING, (Comparable)p_51553_.m_55954_((Direction)p_51552_.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState p_51549_, Mirror p_51550_) {
        BlockState rotated = p_51549_.m_60717_(p_51550_.m_54846_((Direction)p_51549_.m_61143_((Property)FACING)));
        return p_51550_ == Mirror.NONE ? rotated : (BlockState)rotated.m_61124_(TYPE, (Comparable)((ChestType)rotated.m_61143_(TYPE)).m_61486_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_51562_) {
        p_51562_.m_61104_(new Property[]{FACING, TYPE, WATERLOGGED});
    }

    public boolean m_7357_(BlockState p_51522_, BlockGetter p_51523_, BlockPos p_51524_, PathComputationType p_51525_) {
        return false;
    }

    public void m_213897_(BlockState p_220958_, ServerLevel p_220959_, BlockPos p_220960_, RandomSource p_220961_) {
        BlockEntity blockentity = p_220959_.m_7702_(p_220960_);
        if (blockentity instanceof ChestBlockEntity) {
            ((ChestBlockEntity)blockentity).m_155350_();
        }
    }
}

