/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.block.cake;

import com.google.common.collect.ImmutableList;
import committee.nova.mods.avaritia.common.block.cake.EndlessCakeBlock;
import committee.nova.mods.avaritia.init.registry.ModBlocks;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EndlessCandleCakeBlock
extends CandleCakeBlock {
    private final EndlessCakeBlock cake = (EndlessCakeBlock)((Object)ModBlocks.endless_cake.get());
    private static final Map<EndlessCakeBlock, Map<CandleBlock, EndlessCandleCakeBlock>> COMBINER = new HashMap<EndlessCakeBlock, Map<CandleBlock, EndlessCandleCakeBlock>>();

    public EndlessCandleCakeBlock(Block candle, BlockBehaviour.Properties settings) {
        super(candle, settings);
        if (COMBINER.containsKey((Object)this.cake)) {
            COMBINER.get((Object)this.cake).put((CandleBlock)candle, this);
        } else {
            HashMap<CandleBlock, EndlessCandleCakeBlock> candleCakeBlockMap = new HashMap<CandleBlock, EndlessCandleCakeBlock>();
            candleCakeBlockMap.put((CandleBlock)candle, this);
            COMBINER.put(this.cake, candleCakeBlockMap);
        }
    }

    public static BlockState getCandleCakeFromCandle(EndlessCakeBlock cake, CandleBlock candle) {
        return COMBINER.get((Object)cake).get(candle).m_49966_();
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        ItemStack itemStack = player.m_21120_(hand);
        if ((itemStack.m_150930_(Items.f_42409_) || itemStack.m_150930_(Items.f_42613_)) && EndlessCandleCakeBlock.isHittingCandle(hit) && !((Boolean)state.m_61143_((Property)f_152850_)).booleanValue()) {
            EndlessCandleCakeBlock.setLit((LevelAccessor)world, state, pos);
            Block block = state.m_60734_();
            if (block instanceof AbstractCandleBlock) {
                AbstractCandleBlock abstractCandleBlock = (AbstractCandleBlock)block;
                ImmutableList PARTICLE_OFFSETS = ImmutableList.of((Object)new Vec3(0.5, 1.0, 0.5));
                PARTICLE_OFFSETS.forEach(vec3 -> world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + vec3.m_7096_(), (double)pos.m_123342_() + vec3.m_7098_(), (double)pos.m_123343_() + vec3.m_7094_(), 0.0, (double)0.1f, 0.0));
            }
            world.m_5594_(null, pos, SoundEvents.f_144098_, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.m_142346_((Entity)player, GameEvent.f_157792_, pos);
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        if (itemStack.m_41619_()) {
            if (!((Boolean)state.m_61143_((Property)f_152850_)).booleanValue()) {
                EndlessCandleCakeBlock.m_49950_((BlockState)state, (Level)world, (BlockPos)pos);
                world.m_46597_(pos, ((Block)ModBlocks.endless_cake.get()).m_49966_());
            }
        } else {
            return EndlessCakeBlock.tryEat((LevelAccessor)world, pos, player);
        }
        return InteractionResult.PASS;
    }

    private static void setLit(LevelAccessor pLevel, BlockState pState, BlockPos pPos) {
        pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)f_152850_, (Comparable)Boolean.valueOf(true)), 11);
    }

    @NotNull
    public ItemStack m_7397_(@NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState) {
        return new ItemStack((ItemLike)this.cake);
    }

    protected static boolean isHittingCandle(BlockHitResult hitResult) {
        return hitResult.m_82450_().f_82480_ - (double)hitResult.m_82425_().m_123342_() > 0.5;
    }
}

