/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.crafting.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import committee.nova.mods.avaritia.api.common.crafting.ISpecialRecipe;
import committee.nova.mods.avaritia.init.registry.ModRecipeSerializers;
import committee.nova.mods.avaritia.init.registry.ModRecipeTypes;
import committee.nova.mods.avaritia.util.java.TriFunction;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class ShapedExtremeCraftingRecipe
implements ISpecialRecipe {
    private final ResourceLocation recipeId;
    private final NonNullList<Ingredient> inputs;
    private final ItemStack output;
    private final int width;
    private final int height;
    private TriFunction<Integer, Integer, ItemStack, ItemStack> transformers;

    public ShapedExtremeCraftingRecipe(ResourceLocation recipeId, int width, int height, NonNullList<Ingredient> inputs, ItemStack output) {
        this.recipeId = recipeId;
        this.inputs = inputs;
        this.output = output;
        this.width = width;
        this.height = height;
    }

    private static String[] patternFromJson(JsonArray jsonArr) {
        String[] astring = new String[jsonArr.size()];
        for (int i = 0; i < astring.length; ++i) {
            String s = GsonHelper.m_13805_((JsonElement)jsonArr.get(i), (String)("pattern[" + i + "]"));
            if (i > 0 && astring[0].length() != s.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            astring[i] = s;
        }
        return astring;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess p_267052_) {
        return this.output;
    }

    @Override
    public ItemStack assemble(IItemHandler inventory) {
        return this.output.m_41777_();
    }

    @Override
    @NotNull
    public ItemStack m_5874_(@NotNull Container inv, @NotNull RegistryAccess p_267052_) {
        return this.output.m_41777_();
    }

    @Override
    public boolean matches(IItemHandler inventory) {
        for (int i = 0; i <= 9 - this.width; ++i) {
            for (int j = 0; j <= 9 - this.height; ++j) {
                if (this.checkMatch(inventory, i, j, true)) {
                    return true;
                }
                if (!this.checkMatch(inventory, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean m_5818_(@NotNull Container inv, @NotNull Level level) {
        return this.matches((IItemHandler)new InvWrapper(inv));
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        return this.inputs;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.SHAPED_EXTREME_CRAFT_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.EXTREME_CRAFT_RECIPE.get();
    }

    public boolean m_8004_(int width, int height) {
        return width >= this.width && height >= this.height;
    }

    @Override
    @NotNull
    public NonNullList<ItemStack> getRemainingItems(@NotNull IItemHandler inventory) {
        if (this.transformers != null) {
            NonNullList remaining = NonNullList.m_122780_((int)inventory.getSlots(), (Object)ItemStack.f_41583_);
            int size = (int)Math.sqrt(inventory.getSlots());
            block0: for (int i = 0; i <= size - this.width; ++i) {
                for (int j = 0; j <= size - this.height; ++j) {
                    ItemStack stack;
                    int index;
                    int l;
                    int k;
                    if (this.checkMatch(inventory, i, j, true)) {
                        for (k = 0; k < this.height; ++k) {
                            for (l = 0; l < this.width; ++l) {
                                index = this.width - 1 - l + i + (k + j) * size;
                                stack = inventory.getStackInSlot(index);
                                remaining.set(index, (Object)this.transformers.apply(l, k, stack));
                            }
                        }
                        continue block0;
                    }
                    if (!this.checkMatch(inventory, i, j, false)) continue;
                    for (k = 0; k < this.height; ++k) {
                        for (l = 0; l < this.width; ++l) {
                            index = l + i + (k + j) * size;
                            stack = inventory.getStackInSlot(index);
                            remaining.set(index, (Object)this.transformers.apply(l, k, stack));
                        }
                    }
                    continue block0;
                }
            }
            return remaining;
        }
        return ISpecialRecipe.super.getRemainingItems(inventory);
    }

    private boolean checkMatch(IItemHandler inventory, int x, int y, boolean mirror) {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                int k = i - x;
                int l = j - y;
                Ingredient ingredient = Ingredient.f_43901_;
                if (k >= 0 && l >= 0 && k < this.width && l < this.height) {
                    ingredient = mirror ? (Ingredient)this.inputs.get(this.width - k - 1 + l * this.width) : (Ingredient)this.inputs.get(k + l * this.width);
                }
                if (ingredient.test(inventory.getStackInSlot(i + j * 9))) continue;
                return false;
            }
        }
        return true;
    }

    public void setTransformers(TriFunction<Integer, Integer, ItemStack, ItemStack> transformers) {
        this.transformers = transformers;
    }

    public static class Serializer
    implements RecipeSerializer<ShapedExtremeCraftingRecipe> {
        @NotNull
        public ShapedExtremeCraftingRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            Map map = ShapedRecipe.m_44210_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"key"));
            String[] pattern = ShapedRecipe.m_44186_((String[])ShapedExtremeCraftingRecipe.patternFromJson(GsonHelper.m_13933_((JsonObject)json, (String)"pattern")));
            int width = pattern[0].length();
            int height = pattern.length;
            NonNullList inputs = ShapedRecipe.m_44202_((String[])pattern, (Map)map, (int)width, (int)height);
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new ShapedExtremeCraftingRecipe(recipeId, width, height, (NonNullList<Ingredient>)inputs, output);
        }

        public ShapedExtremeCraftingRecipe fromNetwork(@NotNull ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int width = buffer.m_130242_();
            int height = buffer.m_130242_();
            NonNullList inputs = NonNullList.m_122780_((int)(width * height), (Object)Ingredient.f_43901_);
            inputs.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)buffer));
            ItemStack output = buffer.m_130267_();
            return new ShapedExtremeCraftingRecipe(recipeId, width, height, (NonNullList<Ingredient>)inputs, output);
        }

        public void toNetwork(FriendlyByteBuf buffer, ShapedExtremeCraftingRecipe recipe) {
            buffer.m_130130_(recipe.width);
            buffer.m_130130_(recipe.height);
            for (Ingredient ingredient : recipe.inputs) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.output);
        }
    }
}

