/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.crafting.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import committee.nova.mods.avaritia.api.common.crafting.ISpecialRecipe;
import committee.nova.mods.avaritia.init.registry.ModRecipeSerializers;
import committee.nova.mods.avaritia.init.registry.ModRecipeTypes;
import java.util.ArrayList;
import java.util.function.BiFunction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class ShapelessExtremeCraftingRecipe
implements ISpecialRecipe {
    private final ResourceLocation recipeId;
    public final NonNullList<Ingredient> inputs;
    private final ItemStack output;
    private BiFunction<Integer, ItemStack, ItemStack> transformers;

    public ShapelessExtremeCraftingRecipe(ResourceLocation recipeId, NonNullList<Ingredient> inputs, ItemStack output) {
        this.recipeId = recipeId;
        this.inputs = inputs;
        this.output = output;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess p_267052_) {
        return this.output;
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        return this.inputs;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.SHAPELESS_EXTREME_CRAFT_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.EXTREME_CRAFT_RECIPE.get();
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= this.inputs.size();
    }

    @Override
    public ItemStack assemble(IItemHandler inventory) {
        return this.output.m_41777_();
    }

    @Override
    @NotNull
    public ItemStack m_5874_(@NotNull Container inv, @NotNull RegistryAccess p_267052_) {
        return this.output.m_41777_();
    }

    @Override
    public boolean matches(IItemHandler inventory) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int matched = 0;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            inputs.add(stack);
            ++matched;
        }
        return matched == this.inputs.size() && RecipeMatcher.findMatches(inputs, this.inputs) != null;
    }

    @Override
    public boolean m_5818_(@NotNull Container inv, @NotNull Level level) {
        return this.matches((IItemHandler)new InvWrapper(inv));
    }

    @Override
    @NotNull
    public NonNullList<ItemStack> getRemainingItems(@NotNull IItemHandler inv) {
        NonNullList<ItemStack> remaining = ISpecialRecipe.super.getRemainingItems(inv);
        if (this.transformers != null) {
            boolean[] used = new boolean[remaining.size()];
            block0: for (int i = 0; i < remaining.size(); ++i) {
                ItemStack stack = inv.getStackInSlot(i);
                for (int j = 0; j < this.inputs.size(); ++j) {
                    Ingredient input = (Ingredient)this.inputs.get(j);
                    if (used[j] || !input.test(stack)) continue;
                    ItemStack ingredient = this.transformers.apply(j, stack);
                    used[j] = true;
                    remaining.set(i, (Object)ingredient);
                    continue block0;
                }
            }
        }
        return remaining;
    }

    public void setTransformers(BiFunction<Integer, ItemStack, ItemStack> transformers) {
        this.transformers = transformers;
    }

    public static class Serializer
    implements RecipeSerializer<ShapelessExtremeCraftingRecipe> {
        @NotNull
        public ShapelessExtremeCraftingRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            NonNullList inputs = NonNullList.m_122779_();
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            for (int i = 0; i < ingredients.size(); ++i) {
                inputs.add((Object)Ingredient.m_43917_((JsonElement)ingredients.get(i)));
            }
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new ShapelessExtremeCraftingRecipe(recipeId, (NonNullList<Ingredient>)inputs, output);
        }

        public ShapelessExtremeCraftingRecipe fromNetwork(@NotNull ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int size = buffer.m_130242_();
            NonNullList inputs = NonNullList.m_122780_((int)size, (Object)Ingredient.f_43901_);
            for (int i = 0; i < size; ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack output = buffer.m_130267_();
            return new ShapelessExtremeCraftingRecipe(recipeId, (NonNullList<Ingredient>)inputs, output);
        }

        public void toNetwork(FriendlyByteBuf buffer, ShapelessExtremeCraftingRecipe recipe) {
            buffer.m_130130_(recipe.inputs.size());
            for (Ingredient ingredient : recipe.inputs) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.output);
        }
    }
}

