/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.entity.arrow;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import committee.nova.mods.avaritia.init.registry.ModDamageTypes;
import committee.nova.mods.avaritia.init.registry.ModEntities;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class TraceArrowEntity
extends AbstractArrow {
    private static final EntityDataAccessor<Integer> ID_EFFECT_COLOR = SynchedEntityData.m_135353_(TraceArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SPECTRAL_TIME = SynchedEntityData.m_135353_(TraceArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> JUMP_COUNT = SynchedEntityData.m_135353_(TraceArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private Potion potion;
    private final Set<MobEffectInstance> effects;
    private boolean fixedColor;
    private LivingEntity homingTarget = null;
    private Vec3 seekOrigin = null;
    private int homingTime = 0;
    private static final List<String> projectileAntiImmuneEntities = Lists.newArrayList((Object[])new String[]{"minecraft:enderman", "minecraft:wither", "minecraft:ender_dragon", "draconicevolution:guardian_wither"});
    private final Entity owner = this.m_19749_() == null ? this : this.m_19749_();

    public TraceArrowEntity(EntityType<? extends AbstractArrow> entityType, Level world) {
        super(entityType, world);
        this.potion = Potions.f_43598_;
        this.effects = Sets.newHashSet();
    }

    public TraceArrowEntity(Level world, double xPos, double yPos, double zPos) {
        super((EntityType)ModEntities.TRACE_ARROW.get(), xPos, yPos, zPos, world);
        this.potion = Potions.f_43598_;
        this.effects = Sets.newHashSet();
    }

    public TraceArrowEntity(Level world, LivingEntity shooter) {
        super((EntityType)ModEntities.TRACE_ARROW.get(), shooter, world);
        this.potion = Potions.f_43598_;
        this.effects = Sets.newHashSet();
    }

    public void setSpectral(int spectralTime) {
        this.f_19804_.m_135381_(SPECTRAL_TIME, (Object)spectralTime);
    }

    public int getSpectralTime() {
        return (Integer)this.f_19804_.m_135370_(SPECTRAL_TIME);
    }

    public void setJumpCount(int jumpCount) {
        this.f_19804_.m_135381_(JUMP_COUNT, (Object)jumpCount);
    }

    public int getJumpCount() {
        return (Integer)this.f_19804_.m_135370_(JUMP_COUNT);
    }

    public void m_8119_() {
        this.updateHoming();
        this.superTick();
        if (this.m_9236_().f_46443_) {
            if (this.f_36703_) {
                if (this.f_36704_ % 5 == 0) {
                    this.makeParticle(1);
                }
            } else {
                this.makeParticle(2);
            }
        } else if (this.f_36703_ && this.f_36704_ != 0 && !this.effects.isEmpty() && this.f_36704_ >= 600) {
            this.m_9236_().m_7605_((Entity)this, (byte)0);
            this.potion = Potions.f_43598_;
            this.effects.clear();
            this.f_19804_.m_135381_(ID_EFFECT_COLOR, (Object)-1);
        }
    }

    private void superTick() {
        Vec3 vector3d3;
        VoxelShape voxelshape;
        if (!this.f_37246_) {
            this.f_37246_ = this.m_37276_();
        }
        if (!this.m_9236_().f_46443_) {
            this.m_20115_(6, this.m_142038_());
        }
        this.m_6075_();
        boolean flag = this.m_36797_();
        Vec3 vector3d = this.m_20184_();
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            double f = vector3d.m_165924_();
            this.m_146922_((float)(Mth.m_14136_((double)vector3d.f_82479_, (double)vector3d.f_82481_) * 57.2957763671875));
            this.m_146926_((float)(Mth.m_14136_((double)vector3d.f_82480_, (double)f) * 57.2957763671875));
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
        BlockPos blockpos = this.m_20183_();
        BlockState blockstate = this.m_9236_().m_8055_(blockpos);
        if (!(blockstate.m_60795_() || flag || (voxelshape = blockstate.m_60812_((BlockGetter)this.m_9236_(), blockpos)).m_83281_())) {
            vector3d3 = this.m_20182_();
            for (AABB axisalignedbb : voxelshape.m_83299_()) {
                if (!axisalignedbb.m_82338_(blockpos).m_82390_(vector3d3)) continue;
                this.f_36703_ = true;
                break;
            }
        }
        if (this.f_36706_ > 0) {
            --this.f_36706_;
        }
        if (this.m_20070_()) {
            this.m_20095_();
        }
        if (this.f_36703_ && !flag) {
            if (this.f_36696_ != blockstate && this.m_36798_()) {
                this.m_36799_();
            } else if (!this.m_9236_().f_46443_) {
                this.m_6901_();
            }
            ++this.f_36704_;
        } else {
            this.f_36704_ = 0;
            Vec3 vector3d2 = this.m_20182_();
            vector3d3 = vector3d2.m_82549_(vector3d);
            BlockHitResult raytraceresult = this.m_9236_().m_45547_(new ClipContext(vector3d2, vector3d3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (raytraceresult.m_6662_() != HitResult.Type.MISS) {
                vector3d3 = raytraceresult.m_82450_();
            }
            while (!this.m_213877_()) {
                EntityHitResult entityraytraceresult = this.m_6351_(vector3d2, vector3d3);
                if (entityraytraceresult != null) {
                    raytraceresult = entityraytraceresult;
                }
                if (raytraceresult != null && raytraceresult.m_6662_() == HitResult.Type.ENTITY) {
                    Entity entity = ((EntityHitResult)raytraceresult).m_82443_();
                    Entity entity1 = this.m_19749_();
                    if (entity instanceof Player && entity1 instanceof Player && !((Player)entity1).m_7099_((Player)entity)) {
                        raytraceresult = null;
                        entityraytraceresult = null;
                    }
                }
                if (raytraceresult != null && raytraceresult.m_6662_() != HitResult.Type.MISS && !flag && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)raytraceresult)) {
                    this.m_6532_((HitResult)raytraceresult);
                    this.f_19812_ = true;
                }
                if (entityraytraceresult == null || this.m_36796_() <= 0) break;
                raytraceresult = null;
            }
            vector3d = this.m_20184_();
            double d3 = vector3d.f_82479_;
            double d4 = vector3d.f_82480_;
            double d0 = vector3d.f_82481_;
            if (this.m_36792_()) {
                for (int i = 0; i < 4; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123797_, this.m_20185_() + d3 * (double)i / 4.0, this.m_20186_() + d4 * (double)i / 4.0, this.m_20189_() + d0 * (double)i / 4.0, -d3, -d4 + 0.2, -d0);
                }
            }
            double d5 = this.m_20185_() + d3;
            double d1 = this.m_20186_() + d4;
            double d2 = this.m_20189_() + d0;
            double f1 = vector3d.m_165924_();
            if (flag) {
                this.m_146922_((float)(Mth.m_14136_((double)(-d3), (double)(-d0)) * 57.2957763671875));
            } else {
                this.m_146922_((float)(Mth.m_14136_((double)d3, (double)d0) * 57.2957763671875));
            }
            this.m_146926_((float)(Mth.m_14136_((double)d4, (double)f1) * 57.2957763671875));
            this.m_146926_(TraceArrowEntity.m_37273_((float)this.f_19860_, (float)this.m_146909_()));
            this.m_146922_(TraceArrowEntity.m_37273_((float)this.f_19859_, (float)this.m_146908_()));
            float f2 = 0.99f;
            float f3 = 0.05f;
            if (this.m_20069_()) {
                for (int j = 0; j < 4; ++j) {
                    float f4 = 0.25f;
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, d5 - d3 * 0.25, d1 - d4 * 0.25, d2 - d0 * 0.25, d3, d4, d0);
                }
                f2 = this.m_6882_();
            }
            this.m_20256_(vector3d.m_82490_((double)f2));
            if (!this.m_20068_() && !flag) {
                Vec3 vector3d4 = this.m_20184_();
                this.m_20334_(vector3d4.f_82479_, vector3d4.f_82480_ - (double)0.05f, vector3d4.f_82481_);
            }
            this.m_6034_(d5, d1, d2);
            this.m_20101_();
        }
    }

    protected void m_5790_(EntityHitResult p_213868_1_) {
        Player player;
        Entity entity = p_213868_1_.m_82443_();
        float f = (float)this.m_20184_().m_82553_();
        int i = Mth.m_14165_((double)Mth.m_14008_((double)((double)f * this.m_36789_()), (double)0.0, (double)2.147483647E9));
        if (this.m_36796_() > 0) {
            if (this.f_36701_ == null) {
                this.f_36701_ = new IntOpenHashSet(5);
            }
            if (this.f_36702_ == null) {
                this.f_36702_ = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.f_36701_.size() >= this.m_36796_() + 1) {
                this.m_146870_();
                return;
            }
            this.f_36701_.add(entity.m_19879_());
        }
        if (this.m_36792_()) {
            long j = this.f_19796_.m_188503_(i / 2 + 2);
            i = (int)Math.min(j + (long)i, Integer.MAX_VALUE);
        }
        TraceArrowEntity owner = this.m_19749_() == null ? this : this.m_19749_();
        DamageSource damagesource = this.getDamageSource(entity);
        boolean isEnderman = entity.m_6095_() == EntityType.f_20566_;
        int k = entity.m_20094_();
        if (this.m_6060_() && !isEnderman) {
            entity.m_20254_(5);
        }
        if (entity instanceof Player && (player = (Player)entity).m_6117_() && player.m_21211_().m_41720_() instanceof ShieldItem) {
            player.m_36335_().m_41524_(player.m_21211_().m_41720_(), 100);
            this.m_9236_().m_7605_((Entity)player, (byte)30);
            player.m_5810_();
        }
        if (entity.m_6469_(damagesource, (float)i)) {
            if (entity instanceof LivingEntity) {
                Vec3 vector3d;
                LivingEntity livingentity = (LivingEntity)entity;
                if (!this.m_9236_().f_46443_ && this.m_36796_() <= 0) {
                    livingentity.m_21317_(livingentity.m_21234_() + 1);
                }
                if (this.f_36699_ > 0 && (vector3d = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)this.f_36699_ * 0.6)).m_82556_() > 0.0) {
                    livingentity.m_5997_(vector3d.f_82479_, 0.1, vector3d.f_82481_);
                }
                if (!this.m_9236_().f_46443_ && owner instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingentity, (Entity)owner);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)owner), (Entity)livingentity);
                }
                this.m_7761_(livingentity);
                if (livingentity != owner && livingentity instanceof Player && owner instanceof ServerPlayer && !this.m_20067_()) {
                    ((ServerPlayer)owner).f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132159_, 0.0f));
                }
                if (!entity.m_6084_() && this.f_36702_ != null) {
                    this.f_36702_.add(livingentity);
                }
                if (!this.m_9236_().f_46443_ && owner instanceof ServerPlayer) {
                    ServerPlayer serverplayerentity = (ServerPlayer)owner;
                    if (this.f_36702_ != null && this.m_36795_()) {
                        CriteriaTriggers.f_10556_.m_46871_(serverplayerentity, (Collection)this.f_36702_);
                    } else if (!entity.m_6084_() && this.m_36795_()) {
                        CriteriaTriggers.f_10556_.m_46871_(serverplayerentity, Arrays.asList(entity));
                    }
                }
            }
            this.m_5496_(this.m_36784_(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
            if (this.m_36796_() <= 0) {
                this.m_20256_(this.m_20184_().m_82490_(0.0));
                this.m_146884_(entity.m_20182_());
                this.seekNextTarget();
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11685_, SoundSource.PLAYERS, 4.0f, 1.0f);
            }
        } else {
            entity.m_7311_(k);
            this.m_20256_(this.m_20184_().m_82490_(0.0));
            this.m_146922_(this.m_146908_() + 180.0f);
            this.m_146884_(entity.m_20182_());
            this.f_19859_ += 180.0f;
            if (!this.m_9236_().f_46443_ && this.m_20184_().m_82556_() < 1.0E-7) {
                if (this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                    this.m_5552_(this.m_7941_(), 0.1f);
                }
                this.seekNextTarget();
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11685_, SoundSource.PLAYERS, 4.0f, 1.0f);
            }
        }
    }

    protected void m_8060_(BlockHitResult hitResult) {
        this.f_36696_ = this.m_9236_().m_8055_(hitResult.m_82425_());
        BlockState blockstate = this.m_9236_().m_8055_(hitResult.m_82425_());
        blockstate.m_60669_(this.m_9236_(), blockstate, hitResult, (Projectile)this);
        Vec3 vec3 = hitResult.m_82450_().m_82492_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.m_20256_(vec3);
        Vec3 vec31 = vec3.m_82541_().m_82490_((double)0.05f);
        this.m_20343_(this.m_20185_() - vec31.f_82479_, this.m_20186_() - vec31.f_82480_, this.m_20189_() - vec31.f_82481_);
        this.m_5496_(this.m_36784_(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
        this.seekNextTarget();
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11685_, SoundSource.PLAYERS, 4.0f, 1.0f);
    }

    private DamageSource getDamageSource(Entity target) {
        DamageSource damagesource;
        Entity owner = this.m_19749_();
        if (owner == null) {
            damagesource = target.m_269291_().m_269418_((AbstractArrow)this, (Entity)this);
        } else {
            damagesource = target.m_269291_().m_269418_((AbstractArrow)this, owner);
            if (owner instanceof LivingEntity) {
                ((LivingEntity)owner).m_21335_(target);
            }
        }
        if (projectileAntiImmuneEntities.contains(Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey((Object)target.m_6095_())).toString())) {
            damagesource = ModDamageTypes.causeRandomDamage(owner);
        }
        return damagesource;
    }

    public void setEffectsFromItem(ItemStack p_184555_1_) {
        if (p_184555_1_.m_41720_() == Items.f_42738_) {
            int i;
            this.potion = PotionUtils.m_43579_((ItemStack)p_184555_1_);
            List collection = PotionUtils.m_43571_((ItemStack)p_184555_1_);
            if (!collection.isEmpty()) {
                for (MobEffectInstance effectinstance : collection) {
                    this.effects.add(new MobEffectInstance(effectinstance));
                }
            }
            if ((i = TraceArrowEntity.getCustomColor(p_184555_1_)) == -1) {
                this.updateColor();
            } else {
                this.setFixedColor(i);
            }
        } else if (p_184555_1_.m_41720_() == Items.f_42412_) {
            this.potion = Potions.f_43598_;
            this.effects.clear();
            this.f_19804_.m_135381_(ID_EFFECT_COLOR, (Object)-1);
        }
    }

    public static int getCustomColor(ItemStack p_191508_0_) {
        CompoundTag compoundnbt = p_191508_0_.m_41783_();
        return compoundnbt != null && compoundnbt.m_128425_("CustomPotionColor", 99) ? compoundnbt.m_128451_("CustomPotionColor") : -1;
    }

    private void updateColor() {
        this.fixedColor = false;
        if (this.potion == Potions.f_43598_ && this.effects.isEmpty()) {
            this.f_19804_.m_135381_(ID_EFFECT_COLOR, (Object)-1);
        } else {
            this.f_19804_.m_135381_(ID_EFFECT_COLOR, (Object)PotionUtils.m_43564_((Collection)PotionUtils.m_43561_((Potion)this.potion, this.effects)));
        }
    }

    public void addEffect(MobEffectInstance p_184558_1_) {
        this.effects.add(p_184558_1_);
        this.m_20088_().m_135381_(ID_EFFECT_COLOR, (Object)PotionUtils.m_43564_((Collection)PotionUtils.m_43561_((Potion)this.potion, this.effects)));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_EFFECT_COLOR, (Object)-1);
        this.f_19804_.m_135372_(SPECTRAL_TIME, (Object)0);
        this.f_19804_.m_135372_(JUMP_COUNT, (Object)0);
    }

    private void makeParticle(int p_184556_1_) {
        int i = this.getColor();
        if (i != -1 && p_184556_1_ > 0) {
            double d0 = (double)(i >> 16 & 0xFF) / 255.0;
            double d1 = (double)(i >> 8 & 0xFF) / 255.0;
            double d2 = (double)(i & 0xFF) / 255.0;
            for (int j = 0; j < p_184556_1_; ++j) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), d0, d1, d2);
            }
        }
    }

    public int getColor() {
        return (Integer)this.f_19804_.m_135370_(ID_EFFECT_COLOR);
    }

    private void setFixedColor(int p_191507_1_) {
        this.fixedColor = true;
        this.f_19804_.m_135381_(ID_EFFECT_COLOR, (Object)p_191507_1_);
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        if (this.potion != Potions.f_43598_ && this.potion != null) {
            compound.m_128359_("Potion", BuiltInRegistries.f_256980_.m_7981_((Object)this.potion).toString());
        }
        if (this.fixedColor) {
            compound.m_128405_("Color", this.getColor());
        }
        if (!this.effects.isEmpty()) {
            ListTag listnbt = new ListTag();
            for (MobEffectInstance effectinstance : this.effects) {
                listnbt.add((Object)effectinstance.m_19555_(new CompoundTag()));
            }
            compound.m_128365_("CustomPotionEffects", (Tag)listnbt);
        }
        if (this.getSpectralTime() > 0) {
            compound.m_128405_("spectral_time", ((Integer)this.f_19804_.m_135370_(SPECTRAL_TIME)).intValue());
        }
        if (this.getJumpCount() > 0) {
            compound.m_128405_("jump_count", ((Integer)this.f_19804_.m_135370_(JUMP_COUNT)).intValue());
        }
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("Potion", 8)) {
            this.potion = PotionUtils.m_43577_((CompoundTag)compound);
        }
        for (MobEffectInstance effectinstance : PotionUtils.m_43573_((CompoundTag)compound)) {
            this.addEffect(effectinstance);
        }
        if (compound.m_128425_("Color", 99)) {
            this.setFixedColor(compound.m_128451_("Color"));
        } else {
            this.updateColor();
        }
        if (compound.m_128441_("spectral_time")) {
            this.setSpectral(compound.m_128451_("spectral_time"));
        }
        if (compound.m_128441_("jump_count")) {
            this.setJumpCount(compound.m_128451_("jump_count"));
        }
    }

    protected void m_7761_(@NotNull LivingEntity livingEntity) {
        int spectralTime;
        super.m_7761_(livingEntity);
        for (MobEffectInstance effectinstance : this.potion.m_43488_()) {
            livingEntity.m_7292_(new MobEffectInstance(effectinstance.m_19544_(), Math.max(effectinstance.m_19557_() / 8, 1), effectinstance.m_19564_(), effectinstance.m_19571_(), effectinstance.m_19572_()));
        }
        if (!this.effects.isEmpty()) {
            for (MobEffectInstance effectinstance : this.effects) {
                livingEntity.m_7292_(effectinstance);
            }
        }
        if ((spectralTime = ((Integer)this.f_19804_.m_135370_(SPECTRAL_TIME)).intValue()) > 0) {
            MobEffectInstance effectinstance;
            effectinstance = new MobEffectInstance(MobEffects.f_19619_, spectralTime, 0);
            livingEntity.m_7292_(effectinstance);
        }
    }

    @NotNull
    protected ItemStack m_7941_() {
        if (this.effects.isEmpty() && this.potion == Potions.f_43598_) {
            return new ItemStack((ItemLike)Items.f_42412_);
        }
        ItemStack itemstack = new ItemStack((ItemLike)Items.f_42738_);
        PotionUtils.m_43549_((ItemStack)itemstack, (Potion)this.potion);
        PotionUtils.m_43552_((ItemStack)itemstack, this.effects);
        if (this.fixedColor) {
            itemstack.m_41784_().m_128405_("CustomPotionColor", this.getColor());
        }
        return itemstack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte p_70103_1_) {
        if (p_70103_1_ == 0) {
            int i = this.getColor();
            if (i != -1) {
                double d0 = (double)(i >> 16 & 0xFF) / 255.0;
                double d1 = (double)(i >> 8 & 0xFF) / 255.0;
                double d2 = (double)(i & 0xFF) / 255.0;
                for (int j = 0; j < 20; ++j) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), d0, d1, d2);
                }
            }
        } else {
            super.m_7822_(p_70103_1_);
        }
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_6673_(DamageSource source) {
        return source.m_276093_(DamageTypes.f_268468_) || super.m_6673_(source);
    }

    public void seekNextTarget() {
        if (this.getJumpCount() <= 16 && this.m_36792_()) {
            if (this.seekOrigin == null) {
                this.seekOrigin = this.m_20182_();
            }
            if (!this.m_9236_().f_46443_) {
                TargetingConditions conditions = TargetingConditions.m_148352_().m_26888_(living -> living.m_142582_((Entity)this));
                this.homingTarget = this.m_9236_().m_45963_(LivingEntity.class, conditions, this.owner instanceof LivingEntity ? (LivingEntity)this.owner : null, this.seekOrigin.f_82479_, this.seekOrigin.f_82480_, this.seekOrigin.f_82481_, this.m_20191_().m_82400_(64.0));
                if (this.homingTarget != null) {
                    Vec3 targetPos = this.homingTarget.m_146892_();
                    double x = targetPos.f_82479_ - this.m_20185_();
                    double y = targetPos.f_82480_ - this.m_20186_();
                    double z = targetPos.f_82481_ - this.m_20189_();
                    this.m_6686_(x, y, z, 3.0f, 0.0f);
                    this.setJumpCount(this.getJumpCount() + 1);
                    this.homingTime = 0;
                } else {
                    this.destroyArrow();
                }
            }
        } else {
            this.destroyArrow();
        }
    }

    private void updateHoming() {
        if (this.homingTarget != null) {
            if (this.homingTime++ > 60) {
                this.destroyArrow();
            } else if (!this.homingTarget.m_21224_() && !this.homingTarget.m_213877_()) {
                Vec3 targetPos = this.homingTarget.m_146892_();
                if (targetPos.m_82557_(this.m_20182_()) >= 4.0) {
                    double x = targetPos.f_82479_ - this.m_20185_();
                    double y = targetPos.f_82480_ - this.m_20186_();
                    double z = targetPos.f_82481_ - this.m_20189_();
                    this.m_6686_(x, y, z, 3.0f, 0.0f);
                    this.f_19812_ = true;
                }
            } else {
                this.homingTarget = null;
                this.seekNextTarget();
            }
        }
    }

    private void destroyArrow() {
        Level level1 = this.m_9236_();
        if (!level1.f_46443_) {
            if (level1 instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)level1;
                ClientboundLevelParticlesPacket packet = new ClientboundLevelParticlesPacket((ParticleOptions)ParticleTypes.f_123762_, true, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f, 0.0f, 4.0f, 10);
                Entity entity = this.owner;
                if (entity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity;
                    player.f_8906_.m_9829_((Packet)packet);
                }
                level.m_254849_((Entity)(this.m_19749_() == null ? this : this.m_19749_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 4.0f, Level.ExplosionInteraction.NONE);
            }
            this.m_146870_();
        } else {
            level1.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }
}

