/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item;

import committee.nova.mods.avaritia.client.model.InfinityArmorModel;
import committee.nova.mods.avaritia.common.entity.ImmortalItemEntity;
import committee.nova.mods.avaritia.init.registry.ModArmorMaterial;
import committee.nova.mods.avaritia.init.registry.ModEntities;
import committee.nova.mods.avaritia.init.registry.ModItems;
import committee.nova.mods.avaritia.util.lang.TextUtils;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfinityArmorItem
extends ArmorItem {
    public InfinityArmorItem(ArmorItem.Type pSlot) {
        super(ModArmorMaterial.infinite_armor, pSlot, new Item.Properties().m_41486_().m_41487_(1));
    }

    public boolean m_5812_(@NotNull ItemStack pStack) {
        return false;
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    public boolean isEnderMask(ItemStack stack, Player player, EnderMan endermanEntity) {
        return true;
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return true;
    }

    @NotNull
    public Rarity m_41460_(@NotNull ItemStack stack) {
        return ModItems.COSMIC_RARITY;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> tooltip, @NotNull TooltipFlag pIsAdvanced) {
        if (this.f_265916_.m_266308_() == EquipmentSlot.HEAD) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.BLUE + "+" + ChatFormatting.ITALIC + TextUtils.makeSANIC(I18n.m_118938_((String)"tooltip.infinity", (Object[])new Object[0])) + ChatFormatting.RESET + ChatFormatting.BLUE + "% ")).m_130946_(I18n.m_118938_((String)"effect.minecraft.night_vision", (Object[])new Object[0])));
        }
        if (this.f_265916_.m_266308_() == EquipmentSlot.CHEST) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.BLUE + "+" + ChatFormatting.ITALIC + TextUtils.makeSANIC(I18n.m_118938_((String)"tooltip.infinity", (Object[])new Object[0])) + ChatFormatting.RESET + ChatFormatting.BLUE + "% ")).m_130946_(I18n.m_118938_((String)"attribute.name.generic.flying_speed", (Object[])new Object[0])));
        }
        if (this.f_265916_.m_266308_() == EquipmentSlot.LEGS) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.BLUE + "+" + ChatFormatting.ITALIC + TextUtils.makeSANIC(I18n.m_118938_((String)"tooltip.infinity", (Object[])new Object[0])) + ChatFormatting.RESET + ChatFormatting.BLUE + "% ")).m_130946_(I18n.m_118938_((String)"attribute.name.generic.walking_speed", (Object[])new Object[0])));
        }
        if (this.f_265916_.m_266308_() == EquipmentSlot.FEET) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.BLUE + "+" + ChatFormatting.ITALIC + TextUtils.makeSANIC(I18n.m_118938_((String)"tooltip.infinity", (Object[])new Object[0])) + ChatFormatting.RESET + ChatFormatting.BLUE + "% ")).m_130946_(I18n.m_118938_((String)"attribute.name.generic.movement_speed", (Object[])new Object[0])));
        }
        super.m_7373_(pStack, pLevel, tooltip, pIsAdvanced);
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    @Nullable
    public Entity createEntity(Level level, Entity location, ItemStack stack) {
        return ImmortalItemEntity.create((EntityType<ImmortalItemEntity>)((EntityType)ModEntities.IMMORTAL.get()), level, location.m_20185_(), location.m_20186_(), location.m_20189_(), stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            @NotNull
            public HumanoidModel<Player> getHumanoidArmorModel(LivingEntity entityLiving, ItemStack itemstack, EquipmentSlot armorSlot, HumanoidModel _deafult) {
                InfinityArmorModel model = armorSlot == EquipmentSlot.LEGS ? new InfinityArmorModel(InfinityArmorModel.createMesh(new CubeDeformation(1.0f), 0.0f, true).m_171576_().m_171583_(64, 64)) : new InfinityArmorModel(InfinityArmorModel.createMesh(new CubeDeformation(1.0f), 0.0f, false).m_171576_().m_171583_(64, 64));
                model.update(entityLiving, itemstack, armorSlot);
                return model;
            }
        });
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return "avaritia:textures/models/infinity_armor.png";
    }
}

