/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.tools;

import committee.nova.mods.avaritia.common.entity.ImmortalItemEntity;
import committee.nova.mods.avaritia.common.item.tools.Tier;
import committee.nova.mods.avaritia.init.handler.ItemCaptureHandler;
import committee.nova.mods.avaritia.init.registry.ModEntities;
import committee.nova.mods.avaritia.init.registry.ModItems;
import committee.nova.mods.avaritia.util.ItemUtils;
import committee.nova.mods.avaritia.util.ToolUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BeetrootBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.StemGrownBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfinityHoeItem
extends HoeItem {
    public InfinityHoeItem() {
        super((net.minecraft.world.item.Tier)Tier.INFINITY_HOE, -5, 0.0f, new Item.Properties().m_41487_(1).m_41486_());
    }

    public boolean m_5812_(@NotNull ItemStack pStack) {
        return false;
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    @NotNull
    public Rarity m_41460_(@NotNull ItemStack pStack) {
        return ModItems.COSMIC_RARITY;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 0;
    }

    public float m_8102_(@NotNull ItemStack stack, @NotNull BlockState state) {
        return Math.max(super.m_8102_(stack, state), 6.0f);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level pLevel, @NotNull Player pPlayer, @NotNull InteractionHand pUsedHand) {
        ItemStack heldItem = pPlayer.m_21120_(pUsedHand);
        if (!pLevel.f_46443_) {
            pPlayer.m_6674_(InteractionHand.MAIN_HAND);
            BlockPos blockPos = pPlayer.m_20097_();
            int rang = 7;
            int height = 2;
            BlockPos minPos = blockPos.m_7918_(-rang, -height, -rang);
            BlockPos maxPos = blockPos.m_7918_(rang, height, rang);
            HashMap<ItemStack, Integer> map = new HashMap<ItemStack, Integer>();
            ItemCaptureHandler.enableItemCapture(true);
            for (BlockPos pos : BlockPos.m_121940_((BlockPos)minPos, (BlockPos)maxPos)) {
                BlockState state = pLevel.m_8055_(pos);
                Block block = state.m_60734_();
                if (block instanceof CropBlock && (block instanceof BeetrootBlock ? (Integer)state.m_61143_((Property)BeetrootBlock.f_49657_) >= 3 : (Integer)state.m_61143_((Property)CropBlock.f_52244_) >= 7)) {
                    ToolUtils.putMapDrops(pLevel, pos, pPlayer, new ItemStack((ItemLike)this), map);
                    pLevel.m_7731_(pos, (BlockState)state.m_61124_((Property)(block instanceof BeetrootBlock ? BeetrootBlock.f_49657_ : CropBlock.f_52244_), (Comparable)Integer.valueOf(0)), 11);
                }
                if (block instanceof CocoaBlock && (Integer)state.m_61143_((Property)CocoaBlock.f_51736_) >= 2) {
                    ToolUtils.putMapDrops(pLevel, pos, pPlayer, new ItemStack((ItemLike)this), map);
                    pLevel.m_7731_(pos, (BlockState)state.m_61124_((Property)CocoaBlock.f_51736_, (Comparable)Integer.valueOf(0)), 11);
                }
                if (block instanceof StemGrownBlock) {
                    ToolUtils.putMapDrops(pLevel, pos, pPlayer, new ItemStack((ItemLike)this), map);
                    pLevel.m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
                }
                if (block instanceof SweetBerryBushBlock && (Integer)state.m_61143_((Property)SweetBerryBushBlock.f_57244_) >= 3) {
                    ToolUtils.putMapDrops(pLevel, pos, pPlayer, new ItemStack((ItemLike)this), map);
                    pLevel.m_7731_(pos, (BlockState)state.m_61124_((Property)SweetBerryBushBlock.f_57244_, (Comparable)Integer.valueOf(0)), 11);
                }
                if (!(block instanceof BonemealableBlock)) continue;
                BonemealableBlock bonemealableBlock = (BonemealableBlock)block;
                if (block instanceof GrassBlock || !bonemealableBlock.m_7370_((LevelReader)pLevel, pos, state, true)) continue;
                for (int i = 0; i < 3; ++i) {
                    bonemealableBlock.m_214167_(pLevel, pLevel.f_46441_, pos, state);
                }
            }
            ItemCaptureHandler.enableItemCapture(false);
            Set<ItemStack> drops = ItemCaptureHandler.getCapturedDrops();
            ToolUtils.spawnClusters(pLevel, pPlayer, map.keySet());
            pPlayer.m_36335_().m_41524_(heldItem.m_41720_(), 20);
        }
        pLevel.m_5594_(pPlayer, pPlayer.m_20097_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 5.0f);
        return InteractionResultHolder.m_19098_((Object)heldItem);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        Block block1 = world.m_8055_(blockpos).m_60734_();
        if (context.m_43719_() != Direction.DOWN && world.m_46859_(blockpos.m_7494_()) && (block1 instanceof GrassBlock || block1.equals(Blocks.f_50493_) || block1.equals(Blocks.f_50546_))) {
            BlockState blockstate = (BlockState)Blocks.f_50093_.m_49966_().m_61124_((Property)FarmBlock.f_53243_, (Comparable)Integer.valueOf(7));
            Player playerentity = context.m_43723_();
            world.m_5594_(playerentity, blockpos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!world.f_46443_ && playerentity != null) {
                int rang = 5;
                BlockPos minPos = blockpos.m_7918_(-rang, 0, -rang);
                BlockPos maxPos = blockpos.m_7918_(rang, 0, rang);
                if (playerentity.m_6047_()) {
                    ItemCaptureHandler.enableItemCapture(true);
                    HashMap<ItemStack, Integer> map = new HashMap<ItemStack, Integer>();
                    Iterable boxMutable = BlockPos.m_121940_((BlockPos)minPos, (BlockPos)maxPos);
                    for (BlockPos pos : boxMutable) {
                        BlockState state = world.m_8055_(pos);
                        Block block = state.m_60734_();
                        if (!world.m_46859_(pos.m_7494_())) {
                            for (int i = 1; i <= 3; ++i) {
                                this.harvest(world, pos.m_6630_(i), playerentity, map);
                            }
                        }
                        if (world.m_46859_(pos.m_7494_()) && (block instanceof GrassBlock || block.equals(Blocks.f_50493_) || block.equals(Blocks.f_50546_) || block instanceof FarmBlock)) {
                            world.m_7731_(pos, blockstate, 11);
                        }
                        if (world.m_46859_(pos) && !world.m_46859_(pos.m_7495_())) {
                            world.m_7731_(pos, blockstate, 11);
                        }
                        if (state.m_284242_((BlockGetter)world, pos) != MapColor.f_283864_ && !(state.m_60734_() instanceof LiquidBlockContainer)) continue;
                        world.m_7731_(pos, blockstate, 11);
                    }
                    ItemCaptureHandler.enableItemCapture(false);
                    Set<ItemStack> drops = ItemCaptureHandler.getCapturedDrops();
                    ToolUtils.spawnClusters(world, playerentity, map.keySet());
                    Iterable inBoxMutable = BlockPos.m_121940_((BlockPos)minPos, (BlockPos)maxPos.m_7918_(0, 3, 0));
                    Iterable allInBoxMutable = BlockPos.m_121940_((BlockPos)minPos.m_7918_(-1, 0, -1), (BlockPos)maxPos.m_7918_(1, 4, 1));
                    for (BlockPos pos : allInBoxMutable) {
                        BlockState state;
                        if (this.hasBox(pos, inBoxMutable) || (state = world.m_8055_(pos)).m_284242_((BlockGetter)world, pos) != MapColor.f_283864_ && !(state.m_60734_() instanceof LiquidBlockContainer)) continue;
                        world.m_46597_(pos, Blocks.f_50069_.m_49966_());
                    }
                } else {
                    world.m_7731_(blockpos, blockstate, 11);
                }
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return InteractionResult.PASS;
    }

    private boolean hasBox(BlockPos pos, Iterable<BlockPos> box) {
        for (BlockPos pos1 : box) {
            if (pos1.m_123341_() != pos.m_123341_() || pos1.m_123342_() != pos.m_123342_() || pos1.m_123343_() != pos.m_123343_()) continue;
            return true;
        }
        return false;
    }

    private void harvest(Level world, BlockPos pos, Player player, Map<ItemStack, Integer> map) {
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (world.m_46859_(pos) || block instanceof CropBlock || block instanceof StemBlock || block instanceof CocoaBlock || block instanceof SweetBerryBushBlock) {
            return;
        }
        if (block.equals(Blocks.f_50752_)) {
            ItemStack stack1 = new ItemStack((ItemLike)Blocks.f_50752_);
            ItemStack itemStack = ItemUtils.mapEquals(stack1, map);
            if (!itemStack.m_41619_()) {
                map.put(itemStack, map.get(itemStack) + stack1.m_41613_());
            } else {
                map.put(stack1, stack1.m_41613_());
            }
        } else {
            ToolUtils.putMapDrops(world, pos, player, new ItemStack((ItemLike)this), map);
        }
        world.m_46597_(pos, Blocks.f_50016_.m_49966_());
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    @Nullable
    public Entity createEntity(Level level, Entity location, ItemStack stack) {
        return ImmortalItemEntity.create((EntityType<ImmortalItemEntity>)((EntityType)ModEntities.IMMORTAL.get()), level, location.m_20185_(), location.m_20186_(), location.m_20189_(), stack);
    }
}

