/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.compat.crafttweaker;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.action.recipe.ActionRemoveRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.item.MCItemStack;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import committee.nova.mods.avaritia.api.common.crafting.ISpecialRecipe;
import committee.nova.mods.avaritia.common.crafting.recipe.InfinityCatalystCraftRecipe;
import committee.nova.mods.avaritia.common.crafting.recipe.ShapedExtremeCraftingRecipe;
import committee.nova.mods.avaritia.common.crafting.recipe.ShapelessExtremeCraftingRecipe;
import committee.nova.mods.avaritia.init.registry.ModRecipeTypes;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="mods.avaritia.ExtremeTableCrafting")
@ZenRegister
public class ExtremeTableCrafting
implements IRecipeManager<ISpecialRecipe> {
    private static final ExtremeTableCrafting INSTANCE = new ExtremeTableCrafting();

    public RecipeType<ISpecialRecipe> getRecipeType() {
        return (RecipeType)ModRecipeTypes.EXTREME_CRAFT_RECIPE.get();
    }

    @ZenCodeType.Method
    public static void addShaped(String name, IItemStack output, IIngredient[][] inputs) {
        ResourceLocation id = CraftTweakerConstants.rl((String)INSTANCE.fixRecipeName(name));
        int height = inputs.length;
        int width = 0;
        for (IIngredient[] row : inputs) {
            if (width >= row.length) continue;
            width = row.length;
        }
        NonNullList ingredients = NonNullList.m_122780_((int)(height * width), (Object)Ingredient.f_43901_);
        for (int a = 0; a < height; ++a) {
            for (int b = 0; b < inputs[a].length; ++b) {
                IIngredient iing = inputs[a][b];
                Ingredient ing = iing.asVanillaIngredient();
                int i = a * width + b;
                ingredients.set(i, (Object)ing);
            }
        }
        ShapedExtremeCraftingRecipe recipe = new ShapedExtremeCraftingRecipe(id, width, height, (NonNullList<Ingredient>)ingredients, output.getInternal());
        recipe.setTransformers((x, y, stack) -> inputs[y][x].getRemainingItem((IItemStack)new MCItemStack(stack)).getInternal());
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)INSTANCE, (Recipe)recipe));
    }

    @ZenCodeType.Method
    public static void addShapeless(String name, IItemStack output, IIngredient[] inputs) {
        ResourceLocation id = CraftTweakerConstants.rl((String)INSTANCE.fixRecipeName(name));
        ShapelessExtremeCraftingRecipe recipe = new ShapelessExtremeCraftingRecipe(id, ExtremeTableCrafting.toIngredientsList(inputs), output.getInternal());
        recipe.setTransformers((slot, stack) -> inputs[slot].getRemainingItem((IItemStack)new MCItemStack(stack)).getInternal());
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)INSTANCE, (Recipe)recipe));
    }

    @ZenCodeType.Method
    public static void addCatalyst(String name, IIngredient[] inputs) {
        ResourceLocation id = CraftTweakerConstants.rl((String)INSTANCE.fixRecipeName(name));
        InfinityCatalystCraftRecipe recipe = new InfinityCatalystCraftRecipe(id, "default", ExtremeTableCrafting.toIngredientsList(inputs));
        recipe.setTransformers((slot, stack) -> inputs[slot].getRemainingItem((IItemStack)new MCItemStack(stack)).getInternal());
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)INSTANCE, (Recipe)recipe));
    }

    @ZenCodeType.Method
    public static void remove(IItemStack stack) {
        CraftTweakerAPI.apply((IAction)new ActionRemoveRecipe((IRecipeManager)INSTANCE, recipe -> recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_150930_(stack.getInternal().m_41720_())));
    }

    private static NonNullList<Ingredient> toIngredientsList(IIngredient ... ingredients) {
        return Arrays.stream(ingredients).map(IIngredient::asVanillaIngredient).collect(Collectors.toCollection(NonNullList::m_122779_));
    }
}

