/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.handler;

import committee.nova.mods.avaritia.Static;
import committee.nova.mods.avaritia.common.entity.ImmortalItemEntity;
import committee.nova.mods.avaritia.common.item.InfinityArmorItem;
import committee.nova.mods.avaritia.common.item.MatterClusterItem;
import committee.nova.mods.avaritia.common.item.tools.InfinityAxeItem;
import committee.nova.mods.avaritia.common.item.tools.InfinityBowItem;
import committee.nova.mods.avaritia.common.item.tools.InfinityHoeItem;
import committee.nova.mods.avaritia.common.item.tools.InfinityPickaxeItem;
import committee.nova.mods.avaritia.common.item.tools.InfinityShovelItem;
import committee.nova.mods.avaritia.common.item.tools.InfinitySwordItem;
import committee.nova.mods.avaritia.common.net.TotemPacket;
import committee.nova.mods.avaritia.init.handler.NetworkHandler;
import committee.nova.mods.avaritia.init.registry.ModDamageTypes;
import committee.nova.mods.avaritia.init.registry.ModItems;
import committee.nova.mods.avaritia.util.AbilityUtils;
import committee.nova.mods.avaritia.util.lang.TextUtils;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.entity.item.ItemEvent;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class InfinityHandler {
    private static boolean isGarbageBlock(BlockState state) {
        return state.m_204336_(Tags.Blocks.COBBLESTONE) || state.m_204336_(Tags.Blocks.STONE) || state.m_204336_(Tags.Blocks.NETHERRACK);
    }

    @SubscribeEvent
    public static void opTool(PlayerEvent.ItemCraftedEvent event) {
        ItemStack stack = event.getCrafting();
        if (stack.m_150930_((Item)ModItems.infinity_sword.get()) && EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44982_, (ItemStack)stack) < 10) {
            stack.m_41663_(Enchantments.f_44982_, 10);
        }
        if (stack.m_150930_((Item)ModItems.infinity_pickaxe.get()) && EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44987_, (ItemStack)stack) < 10) {
            stack.m_41663_(Enchantments.f_44987_, 10);
        }
        if (stack.m_150930_((Item)ModItems.infinity_bow.get()) && EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44952_, (ItemStack)stack) < 10) {
            stack.m_41663_(Enchantments.f_44952_, 10);
        }
        if (stack.m_150930_((Item)ModItems.infinity_horse_armor.get())) {
            if (EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44974_, (ItemStack)stack) < 10) {
                stack.m_41663_(Enchantments.f_44974_, 10);
            }
            if (EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44965_, (ItemStack)stack) < 10) {
                stack.m_41663_(Enchantments.f_44965_, 10);
            }
            if (EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44967_, (ItemStack)stack) < 10) {
                stack.m_41663_(Enchantments.f_44967_, 10);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerMine(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getFace() == null || event.getLevel().f_46443_ || event.getItemStack().m_41619_() || event.getEntity().m_7500_()) {
            return;
        }
        Level world = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = world.m_8055_(pos);
        if (event.getItemStack().m_41720_() == ModItems.infinity_pickaxe.get() && (state.m_60800_((BlockGetter)world, event.getPos()) <= -1.0f || state.m_284242_((BlockGetter)world, pos) == MapColor.f_283947_ || state.m_284242_((BlockGetter)world, pos) == MapColor.f_283906_) && event.getItemStack().m_41784_().m_128471_("hammer")) {
            ((Item)ModItems.infinity_pickaxe.get()).onBlockStartBreak(event.getEntity().m_21205_(), event.getPos(), event.getEntity());
        }
    }

    @SubscribeEvent
    public static void digging(PlayerEvent.BreakSpeed event) {
        ItemStack held;
        if (!event.getEntity().m_21205_().m_41619_() && ((held = event.getEntity().m_21205_()).m_150930_((Item)ModItems.infinity_pickaxe.get()) || held.m_150930_((Item)ModItems.infinity_shovel.get()))) {
            if (!event.getEntity().m_20096_()) {
                event.setNewSpeed(event.getNewSpeed() * 5.0f);
            }
            if (!event.getEntity().m_20069_() && !EnchantmentHelper.m_44934_((LivingEntity)event.getEntity())) {
                event.setNewSpeed(event.getNewSpeed() * 5.0f);
            }
            if (held.m_41784_().m_128471_("hammer") || held.m_41784_().m_128471_("destroyer")) {
                event.setNewSpeed(event.getNewSpeed() * 0.5f);
            }
        }
    }

    @SubscribeEvent
    public static void canHarvest(PlayerEvent.HarvestCheck event) {
        if (!event.getEntity().m_21205_().m_41619_()) {
            Level level = event.getEntity().m_9236_();
            ItemStack held = event.getEntity().m_21205_();
            if (held.m_150930_((Item)ModItems.infinity_pickaxe.get()) && event.getTargetBlock().m_284242_((BlockGetter)level, BlockPos.f_121853_) == MapColor.f_283947_ && held.m_41784_().m_128471_("destroyer") && InfinityHandler.isGarbageBlock(event.getTargetBlock().m_60734_().m_49966_())) {
                event.setResult(Event.Result.ALLOW);
            }
        }
    }

    @SubscribeEvent
    public static void clusterCluster(EntityItemPickupEvent event) {
        if (event.getEntity() != null && event.getItem().m_32055_().m_150930_((Item)ModItems.matter_cluster.get())) {
            ItemStack stack = event.getItem().m_32055_();
            boolean mergedAny = false;
            Player player = event.getEntity();
            for (ItemStack slot : player.m_150109_().f_35974_) {
                if (stack.m_41619_()) break;
                if (!slot.m_150930_((Item)ModItems.matter_cluster.get())) continue;
                mergedAny |= MatterClusterItem.mergeClusters(stack, slot);
            }
            if (mergedAny) {
                player.m_9236_().m_6269_(null, (Entity)player, SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, (player.m_9236_().f_46441_.m_188501_() - player.m_9236_().f_46441_.m_188501_()) * 1.4f + 2.0f);
            }
        }
    }

    @SubscribeEvent
    public static void expCancel(ItemExpireEvent event) {
        if (event.getEntity() instanceof ImmortalItemEntity) {
            event.setCanceled(true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        block4: {
            block3: {
                if (!(event.getItemStack().m_41720_() instanceof InfinitySwordItem)) break block3;
                for (int x = 0; x < event.getToolTip().size(); ++x) {
                    if (!((Component)event.getToolTip().get(x)).getString().contains(I18n.m_118938_((String)"tooltip.infinity.desc", (Object[])new Object[0])) && !((Component)event.getToolTip().get(x)).getString().equals(I18n.m_118938_((String)"attribute.name.generic.attack_damage", (Object[])new Object[0]))) continue;
                    event.getToolTip().set(x, Component.m_237113_((String)"+").m_130940_(ChatFormatting.BLUE).m_7220_((Component)Component.m_237113_((String)TextUtils.makeFabulous(I18n.m_118938_((String)"tooltip.infinity", (Object[])new Object[0])))).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"tooltip.infinity.desc").m_130940_(ChatFormatting.BLUE)));
                    return;
                }
                break block4;
            }
            if (!(event.getItemStack().m_41720_() instanceof InfinityArmorItem)) break block4;
            for (int x = 0; x < event.getToolTip().size(); ++x) {
                if (((Component)event.getToolTip().get(x)).getString().contains(I18n.m_118938_((String)"tooltip.armor.desc", (Object[])new Object[0]))) {
                    event.getToolTip().set(x, Component.m_237113_((String)"+").m_130940_(ChatFormatting.BLUE).m_7220_((Component)Component.m_237113_((String)TextUtils.makeFabulous(I18n.m_118938_((String)"tooltip.infinity", (Object[])new Object[0])))).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"tooltip.armor.desc").m_130940_(ChatFormatting.BLUE)));
                    return;
                }
                if (!((Component)event.getToolTip().get(x)).getString().contains(I18n.m_118938_((String)"tooltip.armor_toughness.desc", (Object[])new Object[0]))) continue;
                event.getToolTip().set(x, Component.m_237113_((String)"+").m_130940_(ChatFormatting.BLUE).m_7220_((Component)Component.m_237113_((String)TextUtils.makeFabulous(I18n.m_118938_((String)"tooltip.infinity", (Object[])new Object[0])))).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"tooltip.armor_toughness.desc").m_130940_(ChatFormatting.BLUE)));
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ItemStack totem;
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (AbilityUtils.isInfinite((LivingEntity)player) && !(event.getSource() instanceof ModDamageTypes.DamageSourceRandomMessages)) {
                event.setCanceled(true);
                player.m_21153_(player.m_21233_());
            }
            if (!(totem = InfinityHandler.getPlayerTotemItem((Player)player)).m_41619_()) {
                NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new TotemPacket(totem, player.m_19879_()));
                player.m_21219_();
                int damage = totem.m_41779_();
                if (damage == 9) {
                    player.m_21153_(player.m_21233_());
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19603_, 800, 1));
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 800, 1));
                    AbilityUtils.attackAOE((Player)player, 8.0f, 1000.0f, false);
                    player.m_5661_((Component)Component.m_237115_((String)"tooltip.avaritia.totem_break"), false);
                } else {
                    player.m_21153_(10.0f);
                }
                player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 2600, 4));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 400, 1));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 700, 2));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 1100, 0));
                totem.m_41622_(1, (LivingEntity)player, e -> e.m_6674_(InteractionHand.MAIN_HAND));
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onGetHurt(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!player.m_21205_().m_41619_() && player.m_21205_().m_150930_((Item)ModItems.infinity_sword.get()) && player.m_21205_().m_41781_()) {
            event.setCanceled(true);
        }
        if (AbilityUtils.isInfinite((LivingEntity)player) && !event.getSource().m_276093_(ModDamageTypes.INFINITY)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onAttacked(LivingAttackEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (AbilityUtils.isInfinite((LivingEntity)player) && !event.getSource().m_276093_(ModDamageTypes.INFINITY)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        LivingEntity livingEntity;
        if (event.isRecentlyHit() && (livingEntity = event.getEntity()) instanceof WitherSkeleton) {
            Player player;
            WitherSkeleton witherSkeleton = (WitherSkeleton)livingEntity;
            livingEntity = event.getSource().m_7639_();
            if (livingEntity instanceof Player && ((player = (Player)livingEntity).m_21205_().m_150930_((Item)ModItems.skull_sword.get()) || player.m_21206_().m_150930_((Item)ModItems.skull_sword.get()))) {
                if (event.getDrops().isEmpty()) {
                    InfinityHandler.addDrop(event, new ItemStack((ItemLike)Items.f_42679_, 1));
                } else {
                    int skulls = 0;
                    for (ItemEntity drop : event.getDrops()) {
                        ItemStack stack = drop.m_32055_();
                        if (!stack.m_150930_(Items.f_42679_)) continue;
                        if (stack.m_41773_() == 1) {
                            ++skulls;
                            continue;
                        }
                        if (stack.m_41773_() != 0) continue;
                        ++skulls;
                        stack.m_41721_(1);
                    }
                    if (skulls == 0) {
                        InfinityHandler.addDrop(event, new ItemStack((ItemLike)Items.f_42679_, 1));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void entityItemUnDeath(ItemEvent event) {
        ItemEntity entityItem = event.getEntity();
        Item item = entityItem.m_32055_().m_41720_();
        if (item instanceof InfinityArmorItem || item instanceof InfinityAxeItem || item instanceof InfinityBowItem || item instanceof InfinityHoeItem || item instanceof InfinityShovelItem || item instanceof InfinityPickaxeItem || item instanceof InfinitySwordItem) {
            entityItem.m_20331_(true);
        }
    }

    private static void addDrop(LivingDropsEvent event, ItemStack drop) {
        ItemEntity entity = new ItemEntity(event.getEntity().m_9236_(), event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), drop);
        entity.m_32060_();
        event.getDrops().add(entity);
    }

    private static ItemStack getPlayerTotemItem(Player player) {
        ItemStack offhand;
        AtomicReference<ItemStack> totemItem = new AtomicReference<ItemStack>(ItemStack.f_41583_);
        ItemStack mainHandItem = player.m_21205_();
        if (mainHandItem.m_150930_((Item)ModItems.infinity_totem.get())) {
            totemItem.set(mainHandItem);
        }
        if ((offhand = player.m_21206_()).m_150930_((Item)ModItems.infinity_totem.get())) {
            totemItem.set(offhand);
        }
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (!stack.m_150930_((Item)ModItems.infinity_totem.get())) continue;
            totemItem.set(stack);
        }
        if (Static.isLoad("curios") && Static.isLoad("charmofundying")) {
            CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(curiosInventory -> curiosInventory.getStacksHandler("charm").ifPresent(slotInventory -> {
                if (slotInventory.getStacks().getStackInSlot(0).m_150930_((Item)ModItems.infinity_totem.get())) {
                    totemItem.set(slotInventory.getStacks().getStackInSlot(0));
                }
            }));
        }
        return totemItem.get();
    }
}

