/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.handler;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import committee.nova.mods.avaritia.Static;
import committee.nova.mods.avaritia.common.crafting.recipe.EternalSingularityCraftRecipe;
import committee.nova.mods.avaritia.common.item.singularity.Singularity;
import committee.nova.mods.avaritia.common.net.SyncSingularitiesPacket;
import committee.nova.mods.avaritia.init.handler.NetworkHandler;
import committee.nova.mods.avaritia.init.registry.ModSingularities;
import committee.nova.mods.avaritia.util.SingularityUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;

@Mod.EventBusSubscriber
public class SingularityRegistryHandler {
    private static final SingularityRegistryHandler INSTANCE = new SingularityRegistryHandler();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Map<ResourceLocation, Singularity> singularities = new LinkedHashMap<ResourceLocation, Singularity>();

    public static SingularityRegistryHandler getInstance() {
        return INSTANCE;
    }

    @SubscribeEvent
    public static void onDataPackSync(OnDatapackSyncEvent event) {
        SyncSingularitiesPacket message = new SyncSingularitiesPacket(SingularityRegistryHandler.getInstance().getSingularities());
        ServerPlayer player = event.getPlayer();
        if (player != null) {
            NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)message);
        } else {
            NetworkHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)message);
        }
    }

    public void onResourceManagerReload(ICondition.IContext context) {
        this.loadSingularities(context);
    }

    public void loadSingularities(ICondition.IContext context) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        File dir = FMLPaths.CONFIGDIR.get().resolve("avaritia/singularities/").toFile();
        this.writeDefaultSingularityFiles();
        this.singularities.clear();
        if (!dir.mkdirs() && dir.isDirectory()) {
            this.loadFiles(dir, context);
        }
        stopwatch.stop();
        Static.LOGGER.info("Loaded {} singularity type(s) in {} ms", (Object)this.singularities.size(), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDefaultSingularityFiles() {
        File dir = FMLPaths.CONFIGDIR.get().resolve("avaritia" + File.separator + "singularities").toFile();
        if (!dir.exists() && dir.mkdirs()) {
            Static.LOGGER.warn("Could not find default singularities,try to generate!");
            for (Singularity singularity : ModSingularities.getDefaults()) {
                JsonObject json = SingularityUtils.writeToJson(singularity);
                FileWriter writer = null;
                try {
                    File file = new File(dir, singularity.getId().m_135815_() + ".json");
                    writer = new FileWriter(file, StandardCharsets.UTF_8);
                    GSON.toJson((JsonElement)json, (Appendable)writer);
                    writer.close();
                    IOUtils.closeQuietly((Writer)writer);
                }
                catch (Exception e) {
                    Static.LOGGER.error("An error occurred while generating default singularities", (Throwable)e);
                }
                finally {
                    IOUtils.closeQuietly(writer);
                }
            }
        }
    }

    public List<Singularity> getSingularities() {
        return Lists.newArrayList(this.singularities.values());
    }

    public Singularity getSingularityById(ResourceLocation id) {
        return this.singularities.get(id);
    }

    public void writeToBuffer(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.singularities.size());
        this.singularities.forEach((id, singularity) -> singularity.write(buffer));
    }

    public List<Singularity> readFromBuffer(FriendlyByteBuf buffer) {
        ArrayList<Singularity> singularities = new ArrayList<Singularity>();
        int size = buffer.m_130242_();
        for (int i = 0; i < size; ++i) {
            Singularity singularity = Singularity.read(buffer);
            singularities.add(singularity);
        }
        return singularities;
    }

    public void loadSingularities(SyncSingularitiesPacket message) {
        Map<ResourceLocation, Singularity> singularities = message.getSingularities().stream().collect(Collectors.toMap(Singularity::getId, s -> s));
        this.singularities.clear();
        this.singularities.putAll(singularities);
        EternalSingularityCraftRecipe.invalidate();
        Static.LOGGER.info("Loaded {} singularities from the server", (Object)singularities.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFiles(File dir, ICondition.IContext context) {
        File[] files = dir.listFiles((FileFilter)FileFilterUtils.suffixFileFilter((String)".json"));
        if (files == null) {
            return;
        }
        for (File file : files) {
            InputStreamReader reader = null;
            Singularity singularity = null;
            try {
                reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
                String name = file.getName().replace(".json", "");
                JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                singularity = SingularityUtils.loadFromJson(new ResourceLocation("avaritia", name), json, context);
                reader.close();
            }
            catch (Exception e) {
                try {
                    Static.LOGGER.error("An error occurred while loading singularities", (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)reader);
            }
            IOUtils.closeQuietly((Reader)reader);
            if (singularity == null || !singularity.isEnabled()) continue;
            ResourceLocation id = singularity.getId();
            this.singularities.put(id, singularity);
        }
    }
}

