/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.util;

import committee.nova.mods.avaritia.common.item.InfinityArmorItem;
import committee.nova.mods.avaritia.init.registry.ModDamageTypes;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class AbilityUtils {
    public static void sweepAttack(Level level, LivingEntity livingEntity, LivingEntity victim) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            for (LivingEntity livingentity : level.m_45976_(LivingEntity.class, player.m_21120_(InteractionHand.MAIN_HAND).getSweepHitBox(player, (Entity)victim))) {
                double entityReachSq = Mth.m_144952_((double)player.getEntityReach());
                if (player.m_7307_((Entity)livingentity) || livingentity instanceof ArmorStand && ((ArmorStand)livingentity).m_31677_() || !(player.m_20280_((Entity)livingentity) < entityReachSq)) continue;
                livingentity.m_147240_((double)0.6f, (double)Mth.m_14031_((float)(player.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(player.m_146908_() * ((float)Math.PI / 180)))));
                victim.m_21153_(0.0f);
                victim.m_6667_(player.m_269291_().m_268998_(ModDamageTypes.INFINITY, (Entity)player, (Entity)victim));
            }
            level.m_6263_(null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), SoundEvents.f_12317_, livingEntity.m_5720_(), 1.0f, 1.0f);
            double d0 = -Mth.m_14031_((float)(player.m_146908_() * ((float)Math.PI / 180)));
            double d1 = Mth.m_14089_((float)(player.m_146908_() * ((float)Math.PI / 180)));
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123766_, player.m_20185_() + d0, player.m_20227_(0.5), player.m_20189_() + d1, 0, d0, 0.0, d1, 0.0);
            }
        }
    }

    public static void attackAOE(Player player, float range, float damage, boolean hurtAnimal) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        AABB aabb = player.m_20191_().m_82406_((double)range);
        List toAttack = player.m_9236_().m_45933_((Entity)player, aabb);
        DamageSource src = player.m_269291_().m_268998_(ModDamageTypes.INFINITY, (Entity)player, (Entity)player);
        for (Entity entity : toAttack) {
            if (hurtAnimal) {
                if (!(entity instanceof Animal)) continue;
                Animal animal = (Animal)entity;
                animal.m_6469_(src, damage);
                continue;
            }
            if (!(entity instanceof Mob)) continue;
            if (entity instanceof EnderDragon) {
                EnderDragon drageon = (EnderDragon)entity;
                drageon.m_31120_(drageon.f_31080_, src, Float.POSITIVE_INFINITY);
                continue;
            }
            if (entity instanceof WitherBoss) {
                WitherBoss wither = (WitherBoss)entity;
                wither.m_31510_(0);
                wither.m_6469_(src, damage);
                continue;
            }
            entity.m_6469_(src, damage);
        }
    }

    public static boolean isPlayerWearing(LivingEntity entity, EquipmentSlot slot, Predicate<Item> predicate) {
        ItemStack stack = entity.m_6844_(slot);
        return !stack.m_41619_() && predicate.test(stack.m_41720_());
    }

    public static boolean isInfinite(LivingEntity player) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack;
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || !(stack = player.m_6844_(slot)).m_41619_() && stack.m_41720_() instanceof InfinityArmorItem) continue;
            return false;
        }
        return true;
    }
}

