/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.util;

import com.google.common.base.Objects;
import committee.nova.mods.avaritia.api.common.container.ContainerRange;
import committee.nova.mods.avaritia.util.ItemUtils;
import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class ContainerUtils {
    @Nonnull
    public static ItemStack decrStackSize(Container inv, int slot, int size) {
        ItemStack item = inv.m_8020_(slot);
        if (!item.m_41619_()) {
            if (item.m_41613_() <= size) {
                inv.m_6836_(slot, ItemStack.f_41583_);
                inv.m_6596_();
                return item;
            }
            ItemStack itemstack1 = item.m_41620_(size);
            if (item.m_41613_() == 0) {
                inv.m_6836_(slot, ItemStack.f_41583_);
            } else {
                inv.m_6836_(slot, item);
            }
            inv.m_6596_();
            return itemstack1;
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack removeStackFromSlot(Container inv, int slot) {
        ItemStack stack = inv.m_8020_(slot);
        inv.m_6836_(slot, ItemStack.f_41583_);
        return stack;
    }

    public static int incrStackSize(@Nonnull ItemStack base, @Nonnull ItemStack addition) {
        if (ContainerUtils.canStack(base, addition)) {
            return ContainerUtils.incrStackSize(base, addition.m_41613_());
        }
        return 0;
    }

    public static int incrStackSize(@Nonnull ItemStack base, int addition) {
        int totalSize = base.m_41613_() + addition;
        if (totalSize <= base.m_41741_()) {
            return addition;
        }
        if (base.m_41613_() < base.m_41741_()) {
            return base.m_41741_() - base.m_41613_();
        }
        return 0;
    }

    public static boolean areStacksIdentical(@Nonnull ItemStack stack1, @Nonnull ItemStack stack2) {
        if (stack1.m_41619_() || stack2.m_41619_()) {
            return stack1 == stack2;
        }
        return stack1.m_41720_() == stack2.m_41720_() && stack1.m_41773_() == stack2.m_41773_() && stack1.m_41613_() == stack2.m_41613_() && Objects.equal((Object)stack1.m_41783_(), (Object)stack2.m_41783_());
    }

    public static boolean canStack(@Nonnull ItemStack stack1, @Nonnull ItemStack stack2) {
        return stack1.m_41619_() || stack2.m_41619_() || stack1.m_41720_() == stack2.m_41720_() && stack2.m_41773_() == stack1.m_41773_() && ItemStack.m_150942_((ItemStack)stack2, (ItemStack)stack1) && stack1.m_41753_();
    }

    public static void consumeItem(Container inv, int slot) {
        ItemStack stack = inv.m_8020_(slot);
        Item item = stack.m_41720_();
        if (item.hasCraftingRemainingItem(stack)) {
            ItemStack container = item.getCraftingRemainingItem(stack);
            inv.m_6836_(slot, container);
        } else {
            inv.m_7407_(slot, 1);
        }
    }

    public static int stackSize(Container inv, int slot) {
        ItemStack stack = inv.m_8020_(slot);
        return stack.m_41619_() ? 0 : stack.m_41613_();
    }

    public static void dropOnClose(Player player, Container inv) {
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8016_(i);
            if (stack.m_41619_()) continue;
            player.m_36176_(stack, false);
        }
    }

    public static boolean canInsertStack(IItemHandler handler, int slot, ItemStack stack) {
        return handler.insertItem(slot, stack, true) != stack;
    }

    public static boolean canExtractStack(IItemHandler handler, int slot) {
        ItemStack stack = handler.getStackInSlot(slot);
        if (!stack.m_41619_()) {
            return !handler.extractItem(slot, stack.m_41741_(), true).m_41619_();
        }
        return false;
    }

    public static ItemStack insertItem(IItemHandler handler, ItemStack insert, boolean simulate) {
        insert = insert.m_41777_();
        for (int pass = 0; pass < 2; ++pass) {
            for (int slot = 0; slot < handler.getSlots(); ++slot) {
                ItemStack stack = handler.getStackInSlot(slot);
                if (pass == 0 && stack.m_41619_()) continue;
                if (insert.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                insert = handler.insertItem(slot, insert, simulate);
            }
        }
        return insert;
    }

    public static int fitStackInSlot(ContainerRange inv, int slot, ItemStack stack) {
        ItemStack base = inv.inv.m_8020_(slot);
        if (!ContainerUtils.canStack(base, stack) || !inv.canInsertItem(slot, stack)) {
            return 0;
        }
        int fit = !base.m_41619_() ? ContainerUtils.incrStackSize(base, inv.inv.m_6893_() - base.m_41613_()) : inv.inv.m_6893_();
        return Math.min(fit, stack.m_41613_());
    }

    public static int fitStackInSlot(Container inv, int slot, @Nonnull ItemStack stack) {
        return ContainerUtils.fitStackInSlot(new ContainerRange(inv), slot, stack);
    }

    public static int insertItem(ContainerRange inv, @Nonnull ItemStack stack, boolean simulate) {
        stack = stack.m_41777_();
        for (int pass = 0; pass < 2; ++pass) {
            int[] nArray = inv.slots;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int fit;
                int slot;
                ItemStack base;
                if (pass == 0 == (base = inv.inv.m_8020_(slot = nArray[i])).m_41619_() || (fit = ContainerUtils.fitStackInSlot(inv, slot, stack)) == 0) continue;
                if (!base.m_41619_()) {
                    stack.m_41774_(fit);
                    if (!simulate) {
                        base.m_41769_(fit);
                        inv.inv.m_6836_(slot, base);
                    }
                } else {
                    if (!simulate) {
                        inv.inv.m_6836_(slot, ItemUtils.copyStack(stack, fit));
                    }
                    stack.m_41774_(fit);
                }
                if (stack.m_41613_() != 0) continue;
                return 0;
            }
        }
        return stack.m_41613_();
    }

    public static int insertItem(Container inv, @Nonnull ItemStack stack, boolean simulate) {
        return ContainerUtils.insertItem(new ContainerRange(inv), stack, simulate);
    }

    public static int countMatchingStacks(IItemHandler handler, ItemStack filter, boolean insert) {
        int c = 0;
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            ItemStack stack = handler.getStackInSlot(slot);
            if (stack.m_41619_() || !ItemUtils.areStacksSameType(filter, stack) || !(insert ? ContainerUtils.canInsertStack(handler, slot, stack) : ContainerUtils.canExtractStack(handler, slot))) continue;
            c += stack.m_41613_();
        }
        return c;
    }

    public static int getInsertableQuantity(IItemHandler handler, ItemStack stack) {
        ItemStack copy = ItemUtils.copyStack(stack, Integer.MAX_VALUE);
        int quantity = 0;
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            if (!ContainerUtils.canInsertStack(handler, slot, copy)) continue;
            ItemStack left = handler.insertItem(slot, copy, true);
            if (left.m_41619_()) {
                quantity += copy.m_41613_();
                continue;
            }
            quantity += copy.m_41613_() - left.m_41613_();
        }
        return quantity;
    }
}

