/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.util;

import committee.nova.mods.avaritia.util.NBTUtils;
import committee.nova.mods.avaritia.util.vec.Vector3;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ItemUtils {
    public static ItemStack mapEquals(ItemStack stack, Map<ItemStack, Integer> map) {
        for (ItemStack itemStack : map.keySet()) {
            if (itemStack.m_41720_() != stack.m_41720_()) continue;
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack withSize(ItemStack stack, int size, boolean container) {
        if (size <= 0) {
            return container && stack.hasCraftingRemainingItem() ? stack.getCraftingRemainingItem() : ItemStack.f_41583_;
        }
        stack = stack.m_41777_();
        stack.m_41764_(size);
        return stack;
    }

    public static ItemStack grow(ItemStack stack, int amount) {
        return ItemUtils.withSize(stack, stack.m_41613_() + amount, false);
    }

    public static ItemStack shrink(ItemStack stack, int amount, boolean container) {
        return stack.m_41619_() ? ItemStack.f_41583_ : ItemUtils.withSize(stack, stack.m_41613_() - amount, container);
    }

    public static ItemStack copyStack(@Nonnull ItemStack stack, int quantity) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        stack = stack.m_41777_();
        stack.m_41764_(quantity);
        return stack;
    }

    public static boolean areStacksSameType(@Nonnull ItemStack stack1, @Nonnull ItemStack stack2) {
        return !stack1.m_41619_() && !stack2.m_41619_() && stack1.m_41720_() == stack2.m_41720_() && stack2.m_41773_() == stack1.m_41773_() && ItemStack.m_150942_((ItemStack)stack2, (ItemStack)stack1);
    }

    public static boolean canCombineStacks(ItemStack stack1, ItemStack stack2) {
        if (!stack1.m_41619_() && stack2.m_41619_()) {
            return true;
        }
        return ItemUtils.areStacksSameType(stack1, stack2) && stack1.m_41613_() + stack2.m_41613_() <= stack1.m_41741_();
    }

    public static ItemStack combineStacks(ItemStack stack1, ItemStack stack2) {
        return stack1.m_41619_() ? stack2.m_41777_() : ItemUtils.grow(stack1, stack2.m_41613_());
    }

    public static boolean compareTags(ItemStack stack1, ItemStack stack2) {
        String key;
        if (!stack1.m_41782_()) {
            return true;
        }
        if (stack1.m_41782_() && !stack2.m_41782_()) {
            return false;
        }
        Set stack1Keys = NBTUtils.getTagCompound(stack1).m_128431_();
        Set stack2Keys = NBTUtils.getTagCompound(stack2).m_128431_();
        Iterator iterator = stack1Keys.iterator();
        do {
            if (!iterator.hasNext()) {
                return true;
            }
            key = (String)iterator.next();
            if (stack2Keys.contains(key)) continue;
            return false;
        } while (NbtUtils.m_129235_((Tag)NBTUtils.getTag(stack1, key), (Tag)NBTUtils.getTag(stack2, key), (boolean)true));
        return false;
    }

    public static void dropItem(ItemStack stack, Level level, Vector3 dropLocation) {
        ItemEntity item = new ItemEntity(level, dropLocation.x, dropLocation.y, dropLocation.z, stack);
        item.m_20334_(level.f_46441_.m_188583_() * 0.05, level.f_46441_.m_188583_() * 0.05 + (double)0.2f, level.f_46441_.m_188583_() * 0.05);
        level.m_7967_((Entity)item);
    }

    public static void dropItem(Level world, BlockPos pos, @Nonnull ItemStack stack, double velocity) {
        double xVelocity = (double)world.f_46441_.m_188501_() * velocity + (1.0 - velocity) * 0.5;
        double yVelocity = (double)world.f_46441_.m_188501_() * velocity + (1.0 - velocity) * 0.5;
        double zVelocity = (double)world.f_46441_.m_188501_() * velocity + (1.0 - velocity) * 0.5;
        ItemEntity entityItem = new ItemEntity(world, (double)pos.m_123341_() + xVelocity, (double)pos.m_123342_() + yVelocity, (double)pos.m_123343_() + zVelocity, stack);
        entityItem.m_32010_(10);
        world.m_7967_((Entity)entityItem);
    }

    public static void dropItem(Level world, BlockPos pos, @Nonnull ItemStack stack) {
        ItemUtils.dropItem(world, pos, stack, 0.7);
    }

    public static void dropInventory(Level world, BlockPos pos, Container inventory) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_() || stack.m_41613_() <= 0) continue;
            ItemUtils.dropItem(world, pos, stack);
        }
    }
}

