/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.util;

import com.google.common.collect.ImmutableMap;
import committee.nova.mods.avaritia.common.crafting.recipe.ShapelessExtremeCraftingRecipe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.ApiStatus;

@Mod.EventBusSubscriber
public class RecipeUtil {
    private static RecipeManager recipeManager;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onAddReloadListeners(AddReloadListenerEvent event) {
        recipeManager = event.getServerResources().m_206887_();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRecipesUpdated(RecipesUpdatedEvent event) {
        recipeManager = event.getRecipeManager();
    }

    public static RecipeManager getRecipeManager() {
        if (RecipeUtil.recipeManager.f_44007_ instanceof ImmutableMap) {
            RecipeUtil.recipeManager.f_44007_ = new HashMap(RecipeUtil.recipeManager.f_44007_);
            RecipeUtil.recipeManager.f_44007_.replaceAll((t, v) -> new HashMap((Map)RecipeUtil.recipeManager.f_44007_.get(t)));
        }
        if (RecipeUtil.recipeManager.f_199900_ instanceof ImmutableMap) {
            RecipeUtil.recipeManager.f_199900_ = new HashMap(RecipeUtil.recipeManager.f_199900_);
        }
        return recipeManager;
    }

    public static Map<RecipeType<?>, Map<ResourceLocation, Recipe<?>>> getRecipes() {
        return RecipeUtil.getRecipeManager().f_44007_;
    }

    public static <C extends Container, T extends Recipe<C>> Map<ResourceLocation, T> getRecipes(RecipeType<T> type) {
        return RecipeUtil.getRecipeManager().m_44054_(type);
    }

    public static void addRecipe(Recipe<?> recipe) {
        RecipeUtil.getRecipeManager().f_44007_.computeIfAbsent(recipe.m_6671_(), t -> new HashMap()).put(recipe.m_6423_(), recipe);
        RecipeUtil.getRecipeManager().f_199900_.put(recipe.m_6423_(), recipe);
    }

    public static Recipe<?> getRecipe(ResourceLocation name) {
        return (Recipe)RecipeUtil.getRecipeManager().f_199900_.get(name);
    }

    @ApiStatus.Experimental
    public static ShapelessExtremeCraftingRecipe addExtremeShapelessRecipe(ItemStack result, List<ItemStack> ingredients) {
        ArrayList<ItemStack> arraylist = new ArrayList<ItemStack>();
        for (ItemStack stack : ingredients) {
            if (stack != null) {
                arraylist.add(stack.m_41777_());
                continue;
            }
            throw new RuntimeException("Invalid shapeless recipes!");
        }
        return new ShapelessExtremeCraftingRecipe(ForgeRegistries.ITEMS.getKey((Object)result.m_41720_()), RecipeUtil.getList(arraylist), result);
    }

    private static NonNullList<Ingredient> getList(List<ItemStack> arrayList) {
        NonNullList ingredients = NonNullList.m_122779_();
        for (ItemStack stack : arrayList) {
            ingredients.add((Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack}));
        }
        return ingredients;
    }
}

