/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.util;

import com.google.common.collect.Sets;
import committee.nova.mods.avaritia.api.common.item.ItemStackWrapper;
import committee.nova.mods.avaritia.common.entity.arrow.HeavenSubArrowEntity;
import committee.nova.mods.avaritia.common.item.MatterClusterItem;
import committee.nova.mods.avaritia.init.config.ModConfig;
import committee.nova.mods.avaritia.init.handler.ItemCaptureHandler;
import committee.nova.mods.avaritia.init.registry.ModItems;
import committee.nova.mods.avaritia.util.ItemUtils;
import committee.nova.mods.avaritia.util.math.RayTracer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;

public class ToolUtils {
    public static final Set<TagKey<Block>> materialsPick = Sets.newHashSet((Object[])new TagKey[]{BlockTags.f_144282_, Tags.Blocks.STONE, Tags.Blocks.STORAGE_BLOCKS, Tags.Blocks.GLASS, Tags.Blocks.ORES, BlockTags.f_215824_, Tags.Blocks.ORE_BEARING_GROUND_DEEPSLATE, Tags.Blocks.COBBLESTONE_DEEPSLATE});
    public static final Set<TagKey<Block>> materialsAxe = Sets.newHashSet((Object[])new TagKey[]{BlockTags.f_144280_, BlockTags.f_201924_, BlockTags.f_13035_});
    public static final Set<TagKey<Block>> materialsShovel = Sets.newHashSet((Object[])new TagKey[]{BlockTags.f_144283_});
    public static Set<String> defaultTrashOres = new HashSet<String>();

    public static boolean canUseTool(BlockState state, Set<TagKey<Block>> keySets) {
        return state.m_204343_().collect(Collectors.toSet()).retainAll(keySets);
    }

    public static void breakRangeBlocks(Player player, ItemStack stack, BlockPos pos, int range, Set<TagKey<Block>> keySets) {
        BlockHitResult traceResult = RayTracer.retrace(player, range);
        Level world = player.m_9236_();
        BlockState state = world.m_8055_(pos);
        if (!ToolUtils.canUseTool(state, keySets)) {
            return;
        }
        if (state.m_60795_()) {
            return;
        }
        boolean doY = traceResult.m_82434_().m_122434_() != Direction.Axis.Y;
        BlockPos minOffset = new BlockPos(-range, doY ? -1 : -range, -range);
        BlockPos maxOffset = new BlockPos(range, doY ? range * 2 - 2 : range, range);
        ToolUtils.breakBlocks(world, player, stack, pos, minOffset, maxOffset, keySets, false);
    }

    private static void breakBlocks(Level world, Player player, ItemStack stack, BlockPos origin, BlockPos min, BlockPos max, Set<TagKey<Block>> validMaterials, boolean filterTrash) {
        ItemCaptureHandler.enableItemCapture(true);
        for (int lx = min.m_123341_(); lx < max.m_123341_(); ++lx) {
            for (int ly = min.m_123342_(); ly < max.m_123342_(); ++ly) {
                for (int lz = min.m_123343_(); lz < max.m_123343_(); ++lz) {
                    BlockPos pos = origin.m_7918_(lx, ly, lz);
                    ToolUtils.removeBlockWithDrops(world, player, pos, stack, validMaterials);
                }
            }
        }
        ItemCaptureHandler.enableItemCapture(false);
        Set<ItemStack> drops = ItemCaptureHandler.getCapturedDrops();
        if (filterTrash) {
            ToolUtils.removeTrash(drops);
        }
        ToolUtils.spawnClusters(world, player, drops);
    }

    public static void spawnClusters(Level world, Player player, Set<ItemStack> drops) {
        if (!world.f_46443_) {
            List<ItemStack> clusters = MatterClusterItem.makeClusters(drops);
            for (ItemStack cluster : clusters) {
                Containers.m_18992_((Level)world, (double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_(), (ItemStack)cluster);
            }
        }
    }

    public static void putMapItem(ItemStack drop, Map<ItemStack, Integer> map) {
        ItemStack itemStack = ItemUtils.mapEquals(drop, map);
        if (!itemStack.m_41619_()) {
            map.put(itemStack, map.get(itemStack) + drop.m_41613_());
        } else {
            map.put(drop, drop.m_41613_());
        }
    }

    public static void putMapDrops(Level world, BlockPos pos, Player player, ItemStack stack, Map<ItemStack, Integer> map) {
        for (ItemStack drop : Block.m_49874_((BlockState)world.m_8055_(pos), (ServerLevel)((ServerLevel)world), (BlockPos)pos, (BlockEntity)world.m_7702_(pos), (Entity)player, (ItemStack)stack)) {
            ToolUtils.putMapItem(drop, map);
        }
    }

    public static void removeTrash(Set<ItemStack> drops) {
        HashSet<ItemStack> trashItems = new HashSet<ItemStack>();
        for (ItemStack drop : drops) {
            if (!ToolUtils.isTrash(drop)) continue;
            trashItems.add(drop);
        }
        drops.removeAll(trashItems);
    }

    private static boolean isTrash(ItemStack suspect) {
        boolean isTrash = false;
        for (String ore : defaultTrashOres) {
            if (!suspect.m_150930_((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(ore)))) continue;
            return true;
        }
        return isTrash;
    }

    public static void removeBlockWithDrops(Level world, Player player, BlockPos pos, ItemStack stack, Set<TagKey<Block>> validMaterials) {
        if (!world.m_46749_(pos)) {
            return;
        }
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (world.f_46443_) {
            return;
        }
        if (state.m_60713_(Blocks.f_50034_) && stack.m_150930_((Item)ModItems.infinity_pickaxe.get())) {
            world.m_46597_(pos, Blocks.f_50493_.m_49966_());
        }
        if (!block.canHarvestBlock(state, (BlockGetter)world, pos, player) || !ToolUtils.canUseTool(state, validMaterials)) {
            return;
        }
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!event.isCanceled()) {
            if (!player.m_7500_()) {
                BlockEntity tile = world.m_7702_(pos);
                block.m_5707_(world, pos, state, player);
                if (block.onDestroyedByPlayer(state, world, pos, player, true, world.m_6425_(pos))) {
                    block.m_6240_(world, player, pos, state, tile, stack);
                }
            } else {
                world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            }
        }
    }

    public static List<ItemStack> collateDropList(Set<ItemStack> input) {
        return ToolUtils.collateMatterClusterContents(ToolUtils.collateMatterCluster(input));
    }

    public static List<ItemStack> collateMatterClusterContents(Map<ItemStackWrapper, Integer> input) {
        ArrayList<ItemStack> collated = new ArrayList<ItemStack>();
        for (Map.Entry<ItemStackWrapper, Integer> e : input.entrySet()) {
            int count = e.getValue();
            ItemStackWrapper wrap = e.getKey();
            int size = wrap.stack.m_41741_();
            int fullstacks = Mth.m_14143_((float)((float)count / (float)size));
            for (int i = 0; i < fullstacks; ++i) {
                count -= size;
                ItemStack stack = wrap.stack.m_41777_();
                stack.m_41764_(size);
                collated.add(stack);
            }
            if (count <= 0) continue;
            ItemStack stack = wrap.stack.m_41777_();
            stack.m_41764_(count);
            collated.add(stack);
        }
        return collated;
    }

    public static Map<ItemStackWrapper, Integer> collateMatterCluster(Set<ItemStack> input) {
        HashMap<ItemStackWrapper, Integer> counts = new HashMap<ItemStackWrapper, Integer>();
        if (input != null) {
            for (ItemStack entity : input) {
                ItemStackWrapper wrap = new ItemStackWrapper(entity);
                if (!counts.containsKey(wrap)) {
                    counts.put(wrap, 0);
                }
                counts.put(wrap, (Integer)counts.get(wrap) + entity.m_41613_());
            }
        }
        return counts;
    }

    public static void arrowBarrage(Entity shooter, Level level, List<Entity> piercedAndKilledEntities, AbstractArrow.Pickup pickup, RandomSource randy, BlockPos pos) {
        for (int i = 0; i < 30; ++i) {
            double angle = randy.m_188500_() * 2.0 * Math.PI;
            double dist = randy.m_188583_() * 0.5;
            double x = Math.sin(angle) * dist + (double)pos.m_123341_();
            double z = Math.cos(angle) * dist + (double)pos.m_123343_();
            double y = (double)pos.m_123342_() + 25.0;
            double dangle = randy.m_188500_() * 2.0 * Math.PI;
            double ddist = randy.m_188500_() * 0.35;
            double dx = Math.sin(dangle) * ddist;
            double dz = Math.cos(dangle) * ddist;
            HeavenSubArrowEntity subArrow = HeavenSubArrowEntity.create(level, x, y, z);
            if (shooter != null) {
                subArrow.m_5602_(shooter);
            }
            subArrow.f_36702_ = piercedAndKilledEntities;
            subArrow.m_5997_(dx, -(randy.m_188500_() * 1.85 + 0.15), dz);
            subArrow.m_36762_(true);
            subArrow.m_36781_(((Integer)ModConfig.subArrowDamage.get()).intValue());
            subArrow.f_36705_ = pickup;
            level.m_7967_((Entity)subArrow);
        }
    }
}

