/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.info.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import xaero.common.XaeroMinimapSession;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.info.InfoDisplay;
import xaero.common.minimap.info.render.compile.InfoDisplayCompiler;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.misc.Misc;
import xaero.common.settings.ModSettings;
import xaero.hud.minimap.Minimap;

public final class InfoDisplayRenderer {
    private final InfoDisplayCompiler compiler = new InfoDisplayCompiler();

    public void render(GuiGraphics guiGraphics, XaeroMinimapSession session, MinimapProcessor processor, Minimap minimap, MinimapRendererHelper helper, int x, int y, int width, int height, double scale, int size, int playerBlockX, int playerBlockY, int playerBlockZ, BlockPos playerPos, int scaledX, int scaledY, float mapScale, ModSettings settings, MultiBufferSource.BufferSource renderTypeBuffer) {
        PoseStack matrixStack = guiGraphics.m_280168_();
        Iterator iterator = minimap.getInfoDisplayManager().getStream().iterator();
        int interfaceSize = size;
        int scaledHeight = (int)((float)height * mapScale);
        int align = settings.minimapTextAlign;
        boolean under = scaledY + interfaceSize / 2 < scaledHeight / 2;
        int stringY = scaledY + (under ? interfaceSize : -9);
        int bgOpacityMask = settings.infoDisplayBackgroundOpacity * 255 / 100 << 24;
        matrixStack.m_252880_(0.0f, 0.0f, -2.0f);
        while (iterator.hasNext()) {
            InfoDisplay infoDisplay = (InfoDisplay)iterator.next();
            List<Component> compiledLines = this.compiler.compile(infoDisplay, session, processor, x, y, width, height, scale, size, playerBlockX, playerBlockY, playerBlockZ, playerPos);
            int textColorIndex = infoDisplay.getTextColor();
            int backgroundColorIndex = infoDisplay.getBackgroundColor();
            int textColor = ModSettings.COLORS[textColorIndex < 0 ? 15 : textColorIndex % ModSettings.COLORS.length];
            int backgroundColor = backgroundColorIndex < 0 ? 0 : bgOpacityMask | ModSettings.COLORS[backgroundColorIndex % ModSettings.COLORS.length] & 0xFFFFFF;
            VertexConsumer backgroundVertexBuffer = renderTypeBuffer.m_6299_(CustomRenderTypes.COLORED_WAYPOINTS_BGS);
            for (int i = 0; i < compiledLines.size(); ++i) {
                Component s = compiledLines.get(i);
                int stringWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)s);
                int stringX = scaledX + (align == 0 ? interfaceSize / 2 - stringWidth / 2 : (align == 1 ? 6 : interfaceSize - 6 - stringWidth));
                if (backgroundColor != 0) {
                    matrixStack.m_252880_(0.0f, 0.0f, -1.0f);
                    helper.addColoredRectToExistingBuffer(matrixStack.m_85850_().m_252922_(), backgroundVertexBuffer, stringX - 1, stringY - 1, stringWidth + 2, 10, backgroundColor);
                    matrixStack.m_252880_(0.0f, 0.0f, 1.0f);
                }
                Misc.drawNormalText(matrixStack, s, (float)stringX, (float)stringY, textColor, true, renderTypeBuffer);
                stringY += 10 * (under ? 1 : -1);
            }
            compiledLines.clear();
        }
        matrixStack.m_252880_(0.0f, 0.0f, 2.0f);
        renderTypeBuffer.m_109911_();
    }
}

