/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.candlelight.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cristelknight.doapi.config.jankson.config.CommentedConfig;
import java.util.HashMap;

public record CandlelightConfig(boolean enableChefSetBonus, boolean enableCandlelightTomatoes, boolean enableCandlelightLettuce) implements CommentedConfig<CandlelightConfig>
{
    private static CandlelightConfig INSTANCE;
    public static final Codec<CandlelightConfig> CODEC;

    public static CandlelightConfig getActiveInstance() {
        if (INSTANCE == null) {
            INSTANCE = CandlelightConfig.loadConfig();
        }
        return INSTANCE;
    }

    private static CandlelightConfig loadConfig() {
        return new CandlelightConfig(true, true, true);
    }

    public HashMap<String, String> getComments() {
        HashMap<String, String> comments = new HashMap<String, String>();
        comments.put("enable_chef_armor_set_bonus", "Whether the chef armor should give a set bonus");
        comments.put("enable_candlelight_tomatoes", "Whether candlelight tomatoes should be enabled");
        comments.put("enable_candlelight_lettuce", "Whether candlelight tomatoes should be enabled");
        return comments;
    }

    public String getHeader() {
        return "Candlelight Config\n\n===========\nDiscord: https://discord.gg/Vqu6wYZwdZ\nModrinth: https://modrinth.com/mod/lets-do-candlelight\nCurseForge: https://www.curseforge.com/minecraft/mc-mods/lets-do-candlelight\n";
    }

    public String getSubPath() {
        return "candlelight/config";
    }

    public CandlelightConfig getInstance() {
        return CandlelightConfig.getActiveInstance();
    }

    public CandlelightConfig getDefault() {
        return new CandlelightConfig(true, true, true);
    }

    public Codec<CandlelightConfig> getCodec() {
        return CODEC;
    }

    public boolean isSorted() {
        return false;
    }

    public void setInstance(CandlelightConfig instance) {
        INSTANCE = instance;
    }

    static {
        CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("enable_chef_armor_set_bonus").orElse((Object)true).forGetter(CandlelightConfig::enableChefSetBonus), (App)Codec.BOOL.fieldOf("enable_candlelight_tomatoes").orElse((Object)true).forGetter(CandlelightConfig::enableCandlelightTomatoes), (App)Codec.BOOL.fieldOf("enable_candlelight_lettuce").orElse((Object)true).forGetter(CandlelightConfig::enableCandlelightLettuce)).apply((Applicative)instance, CandlelightConfig::new));
    }
}

