/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.candlelight.registry;

import de.cristelknight.doapi.client.render.feature.CustomArmorManager;
import de.cristelknight.doapi.client.render.feature.CustomArmorSet;
import dev.architectury.registry.client.level.entity.EntityModelLayerRegistry;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.satisfy.candlelight.client.CandlelightClient;
import net.satisfy.candlelight.client.model.CookInner;
import net.satisfy.candlelight.client.model.CookOuter;
import net.satisfy.candlelight.client.model.CookingHatModel;
import net.satisfy.candlelight.config.CandlelightConfig;
import net.satisfy.candlelight.item.armor.CookBootsItem;
import net.satisfy.candlelight.item.armor.CookChestplateItem;
import net.satisfy.candlelight.item.armor.CookLeggingsItem;
import net.satisfy.candlelight.item.armor.CookingHatItem;
import net.satisfy.candlelight.registry.ObjectRegistry;
import net.satisfy.candlelight.util.CandlelightIdentifier;

public class ArmorRegistry {
    public static void registerArmorModelLayers() {
        EntityModelLayerRegistry.register((ModelLayerLocation)CookingHatModel.LAYER_LOCATION, CookingHatModel::getTexturedModelData);
        EntityModelLayerRegistry.register((ModelLayerLocation)CookInner.LAYER_LOCATION, CookInner::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)CookOuter.LAYER_LOCATION, CookOuter::createBodyLayer);
    }

    public static <T extends LivingEntity> void registerArmorModels(CustomArmorManager<T> armors, EntityModelSet modelLoader) {
        armors.addArmor(new CustomArmorSet(new Item[]{(Item)ObjectRegistry.COOKING_HAT.get(), (Item)ObjectRegistry.CHEFS_JACKET.get(), (Item)ObjectRegistry.CHEFS_PANTS.get(), (Item)ObjectRegistry.CHEFS_BOOTS.get()}).setTexture((ResourceLocation)new CandlelightIdentifier("cook")).setOuterModel(new CookOuter(modelLoader.m_171103_(CookOuter.LAYER_LOCATION))).setInnerModel(new CookInner(modelLoader.m_171103_(CookInner.LAYER_LOCATION))).setHatModel(new CookingHatModel(modelLoader.m_171103_(CookingHatModel.LAYER_LOCATION))));
    }

    public static <T extends LivingEntity> void registerHatModels(Map<Item, EntityModel<T>> models, EntityModelSet modelLoader) {
        models.put((Item)ObjectRegistry.COOKING_HAT.get(), new CookingHatModel(modelLoader.m_171103_(CookingHatModel.LAYER_LOCATION)));
    }

    public static void appendTooltip(List<Component> tooltip) {
        CandlelightConfig config = CandlelightConfig.getActiveInstance();
        if (!config.enableChefSetBonus()) {
            return;
        }
        Player player = CandlelightClient.getClientPlayer();
        if (player == null) {
            return;
        }
        ItemStack helmet = player.m_6844_(EquipmentSlot.HEAD);
        ItemStack chestplate = player.m_6844_(EquipmentSlot.CHEST);
        ItemStack leggings = player.m_6844_(EquipmentSlot.LEGS);
        ItemStack boots = player.m_6844_(EquipmentSlot.FEET);
        boolean hasCompleteSet = helmet != null && helmet.m_41720_() instanceof CookingHatItem && chestplate != null && chestplate.m_41720_() instanceof CookChestplateItem && leggings != null && leggings.m_41720_() instanceof CookLeggingsItem && boots != null && boots.m_41720_() instanceof CookBootsItem;
        tooltip.add(Component.m_130674_((String)""));
        tooltip.add(Component.m_130674_((String)(ChatFormatting.AQUA + I18n.m_118938_((String)"tooltip.candlelight.cook_armor.", (Object[])new Object[0]))));
        tooltip.add(Component.m_130674_((String)((helmet != null && helmet.m_41720_() instanceof CookingHatItem ? ChatFormatting.GREEN.toString() : ChatFormatting.GRAY.toString()) + "- [" + ((Item)ObjectRegistry.COOKING_HAT.get()).m_41466_().getString() + "]")));
        tooltip.add(Component.m_130674_((String)((chestplate != null && chestplate.m_41720_() instanceof CookChestplateItem ? ChatFormatting.GREEN.toString() : ChatFormatting.GRAY.toString()) + "- [" + ((Item)ObjectRegistry.CHEFS_JACKET.get()).m_41466_().getString() + "]")));
        tooltip.add(Component.m_130674_((String)((leggings != null && leggings.m_41720_() instanceof CookLeggingsItem ? ChatFormatting.GREEN.toString() : ChatFormatting.GRAY.toString()) + "- [" + ((Item)ObjectRegistry.CHEFS_PANTS.get()).m_41466_().getString() + "]")));
        tooltip.add(Component.m_130674_((String)((boots != null && boots.m_41720_() instanceof CookBootsItem ? ChatFormatting.GREEN.toString() : ChatFormatting.GRAY.toString()) + "- [" + ((Item)ObjectRegistry.CHEFS_BOOTS.get()).m_41466_().getString() + "]")));
        tooltip.add(Component.m_130674_((String)""));
        tooltip.add(Component.m_130674_((String)(ChatFormatting.GRAY + I18n.m_118938_((String)"tooltip.candlelight.cook_armor.2", (Object[])new Object[0]))));
        tooltip.add(Component.m_130674_((String)((hasCompleteSet ? ChatFormatting.DARK_GREEN.toString() : ChatFormatting.GRAY.toString()) + I18n.m_118938_((String)"tooltip.candlelight.cook_armor.3", (Object[])new Object[0]))));
        if (hasCompleteSet) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19621_, 200, 1));
        }
    }
}

