/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.block.entity;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import vectorwing.farmersdelight.common.block.SkilletBlock;
import vectorwing.farmersdelight.common.block.entity.HeatableBlockEntity;
import vectorwing.farmersdelight.common.block.entity.SyncedBlockEntity;
import vectorwing.farmersdelight.common.mixin.accessor.RecipeManagerAccessor;
import vectorwing.farmersdelight.common.registry.ModBlockEntityTypes;
import vectorwing.farmersdelight.common.registry.ModParticleTypes;
import vectorwing.farmersdelight.common.registry.ModSounds;
import vectorwing.farmersdelight.common.utility.ItemUtils;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class SkilletBlockEntity
extends SyncedBlockEntity
implements HeatableBlockEntity {
    private final ItemStackHandler inventory = this.createHandler();
    private int cookingTime;
    private int cookingTimeTotal;
    private ResourceLocation lastRecipeID;
    private ItemStack skilletStack = ItemStack.f_41583_;
    private int fireAspectLevel;

    public SkilletBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.SKILLET.get(), pos, state);
    }

    public static void cookingTick(Level level, BlockPos pos, BlockState state, SkilletBlockEntity skillet) {
        boolean isHeated = skillet.isHeated(level, pos);
        if (isHeated) {
            ItemStack cookingStack = skillet.getStoredStack();
            if (cookingStack.m_41619_()) {
                skillet.cookingTime = 0;
            } else {
                skillet.cookAndOutputItems(cookingStack, level);
            }
        } else if (skillet.cookingTime > 0) {
            skillet.cookingTime = Mth.m_14045_((int)(skillet.cookingTime - 2), (int)0, (int)skillet.cookingTimeTotal);
        }
    }

    public static void animationTick(Level level, BlockPos pos, BlockState state, SkilletBlockEntity skillet) {
        if (skillet.isHeated(level, pos) && skillet.hasStoredStack()) {
            double z;
            double y;
            double x;
            RandomSource random = level.f_46441_;
            if (random.m_188501_() < 0.2f) {
                x = (double)pos.m_123341_() + 0.5 + (random.m_188500_() * 0.4 - 0.2);
                y = (double)pos.m_123342_() + 0.1;
                z = (double)pos.m_123343_() + 0.5 + (random.m_188500_() * 0.4 - 0.2);
                double motionY = random.m_188499_() ? 0.015 : 0.005;
                level.m_7106_((ParticleOptions)ModParticleTypes.STEAM.get(), x, y, z, 0.0, motionY, 0.0);
            }
            if (skillet.fireAspectLevel > 0 && random.m_188501_() < (float)skillet.fireAspectLevel * 0.05f) {
                x = (double)pos.m_123341_() + 0.5 + (random.m_188500_() * 0.4 - 0.2);
                y = (double)pos.m_123342_() + 0.1;
                z = (double)pos.m_123343_() + 0.5 + (random.m_188500_() * 0.4 - 0.2);
                double motionX = level.f_46441_.m_188501_() - 0.5f;
                double motionY = level.f_46441_.m_188501_() * 0.5f + 0.2f;
                double motionZ = level.f_46441_.m_188501_() - 0.5f;
                level.m_7106_((ParticleOptions)ParticleTypes.f_123808_, x, y, z, motionX, motionY, motionZ);
            }
        }
    }

    private void cookAndOutputItems(ItemStack cookingStack, Level level) {
        SimpleContainer wrapper;
        Optional<CampfireCookingRecipe> recipe;
        if (level == null) {
            return;
        }
        ++this.cookingTime;
        if (this.cookingTime >= this.cookingTimeTotal && (recipe = this.getMatchingRecipe((Container)(wrapper = new SimpleContainer(new ItemStack[]{cookingStack})))).isPresent()) {
            ItemStack resultStack = recipe.get().m_5874_((Container)wrapper, level.m_9598_());
            Direction direction = ((Direction)this.m_58900_().m_61143_((Property)SkilletBlock.FACING)).m_122427_();
            ItemUtils.spawnItemEntity(level, resultStack.m_41777_(), (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.3, (double)this.f_58858_.m_123343_() + 0.5, (float)direction.m_122429_() * 0.08f, 0.25, (float)direction.m_122431_() * 0.08f);
            this.cookingTime = 0;
            this.inventory.extractItem(0, 1, false);
        }
    }

    public boolean isCooking() {
        return this.isHeated() && this.hasStoredStack();
    }

    public boolean isHeated() {
        if (this.f_58857_ != null) {
            return this.isHeated(this.f_58857_, this.f_58858_);
        }
        return false;
    }

    private Optional<CampfireCookingRecipe> getMatchingRecipe(Container recipeWrapper) {
        Recipe recipe;
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        if (this.lastRecipeID != null && (recipe = ((RecipeManagerAccessor)this.f_58857_.m_7465_()).getRecipeMap(RecipeType.f_44111_).get(this.lastRecipeID)) instanceof CampfireCookingRecipe && recipe.m_5818_(recipeWrapper, this.f_58857_)) {
            return Optional.of((CampfireCookingRecipe)recipe);
        }
        recipe = this.f_58857_.m_7465_().m_44015_(RecipeType.f_44111_, recipeWrapper, this.f_58857_);
        if (recipe.isPresent()) {
            this.lastRecipeID = ((CampfireCookingRecipe)recipe.get()).m_6423_();
            return recipe;
        }
        return Optional.empty();
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        this.cookingTime = compound.m_128451_("CookTime");
        this.cookingTimeTotal = compound.m_128451_("CookTimeTotal");
        this.skilletStack = ItemStack.m_41712_((CompoundTag)compound.m_128469_("Skillet"));
        this.fireAspectLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)this.skilletStack);
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        compound.m_128405_("CookTime", this.cookingTime);
        compound.m_128405_("CookTimeTotal", this.cookingTimeTotal);
        compound.m_128365_("Skillet", (Tag)this.skilletStack.m_41739_(new CompoundTag()));
    }

    public CompoundTag writeSkilletItem(CompoundTag compound) {
        compound.m_128365_("Skillet", (Tag)this.skilletStack.m_41739_(new CompoundTag()));
        return compound;
    }

    public void setSkilletItem(ItemStack stack) {
        this.skilletStack = stack.m_41777_();
        this.fireAspectLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)stack);
        this.inventoryChanged();
    }

    public ItemStack addItemToCook(ItemStack addedStack, @Nullable Player player) {
        Optional<CampfireCookingRecipe> recipe = this.getMatchingRecipe((Container)new SimpleContainer(new ItemStack[]{addedStack}));
        if (recipe.isPresent()) {
            this.cookingTimeTotal = SkilletBlock.getSkilletCookingTime(recipe.get().m_43753_(), this.fireAspectLevel);
            boolean wasEmpty = this.getStoredStack().m_41619_();
            ItemStack remainderStack = this.inventory.insertItem(0, addedStack.m_41777_(), false);
            if (!ItemStack.m_41728_((ItemStack)remainderStack, (ItemStack)addedStack)) {
                this.lastRecipeID = recipe.get().m_6423_();
                this.cookingTime = 0;
                if (wasEmpty && this.f_58857_ != null && this.isHeated(this.f_58857_, this.f_58858_)) {
                    this.f_58857_.m_6263_(null, (double)((float)this.f_58858_.m_123341_() + 0.5f), (double)((float)this.f_58858_.m_123342_() + 0.5f), (double)((float)this.f_58858_.m_123343_() + 0.5f), (SoundEvent)ModSounds.BLOCK_SKILLET_ADD_FOOD.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
                }
                return remainderStack;
            }
        } else if (player != null) {
            player.m_5661_((Component)TextUtils.getTranslation("block.skillet.invalid_item", new Object[0]), true);
        }
        return addedStack;
    }

    public ItemStack removeItem() {
        return this.inventory.extractItem(0, this.getStoredStack().m_41741_(), false);
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }

    public ItemStack getStoredStack() {
        return this.inventory.getStackInSlot(0);
    }

    public boolean hasStoredStack() {
        return !this.getStoredStack().m_41619_();
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(){

            protected void onContentsChanged(int slot) {
                SkilletBlockEntity.this.inventoryChanged();
            }
        };
    }

    public void m_7651_() {
        super.m_7651_();
    }
}

