/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bakery.event;

import de.cristelknight.doapi.common.registry.DoApiSoundEventRegistry;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.LootEvent;
import dev.architectury.event.events.common.PlayerEvent;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.phys.EntityHitResult;
import net.satisfy.bakery.registry.ObjectRegistry;
import net.satisfy.bakery.util.LoottableInjector;
import org.jetbrains.annotations.Nullable;

public class CommonEvents {
    private static final UUID ATTACK_SPEED_MODIFIER_ID = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3");

    public static void init() {
        LootEvent.MODIFY_LOOT_TABLE.register(CommonEvents::onModifyLootTable);
        PlayerEvent.ATTACK_ENTITY.register(CommonEvents::attack);
    }

    public static EventResult attack(Player player, Level level, Entity target, InteractionHand hand, @Nullable EntityHitResult result) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_150930_((Item)ObjectRegistry.SMALL_COOKING_POT_ITEM.get())) {
            level.m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), (SoundEvent)DoApiSoundEventRegistry.COOKING_POT_HIT.get(), SoundSource.PLAYERS, 0.5f, 1.0f);
            target.m_6469_(level.m_269111_().m_269264_(), 1.2f);
            itemStack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            itemStack.m_41643_(Attributes.f_22283_, new AttributeModifier(ATTACK_SPEED_MODIFIER_ID, "Weapon modifier", -2.0, AttributeModifier.Operation.ADDITION), EquipmentSlot.MAINHAND);
            if (target instanceof Mob) {
                Mob mob = (Mob)target;
                mob.m_6710_((LivingEntity)player);
            }
            return EventResult.interruptTrue();
        }
        if (itemStack.m_150930_((Item)ObjectRegistry.ROLLING_PIN.get()) && !level.f_46443_) {
            level.m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_12630_, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (target instanceof LivingEntity) {
                LivingEntity livingTarget = (LivingEntity)target;
                livingTarget.m_6469_(level.m_269111_().m_269264_(), 2.0f);
                livingTarget.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 120, 1));
                if (livingTarget instanceof Mob) {
                    Mob mob = (Mob)livingTarget;
                    mob.m_6710_((LivingEntity)player);
                }
            }
            itemStack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            itemStack.m_41643_(Attributes.f_22283_, new AttributeModifier(ATTACK_SPEED_MODIFIER_ID, "Weapon modifier", -2.0, AttributeModifier.Operation.ADDITION), EquipmentSlot.MAINHAND);
            return EventResult.interruptTrue();
        }
        return EventResult.pass();
    }

    private static void onModifyLootTable(@Nullable LootDataManager lootDataManager, ResourceLocation id, LootEvent.LootTableModificationContext ctx, boolean b) {
        LoottableInjector.InjectLoot(id, ctx);
    }
}

