/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.mechanicalArm;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmBlock;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmBlockEntity;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4fc;

public class ArmRenderer
extends KineticBlockEntityRenderer<ArmBlockEntity> {
    public ArmRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    protected void renderSafe(ArmBlockEntity be, float pt, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        int color;
        float headAngle;
        float upperArmAngle;
        float lowerArmAngle;
        float baseAngle;
        boolean rave;
        super.renderSafe(be, pt, ms, buffer, light, overlay);
        ItemStack item = be.heldItem;
        boolean hasItem = !item.m_41619_();
        boolean usingFlywheel = Backend.canUseInstancing((Level)be.m_58904_());
        if (usingFlywheel && !hasItem) {
            return;
        }
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        boolean isBlockItem = hasItem && item.m_41720_() instanceof BlockItem && itemRenderer.m_174264_(item, be.m_58904_(), null, 0).m_7539_();
        VertexConsumer builder = buffer.m_6299_(be.goggles ? RenderType.m_110463_() : RenderType.m_110451_());
        BlockState blockState = be.m_58900_();
        PoseStack msLocal = new PoseStack();
        TransformStack msr = TransformStack.cast((PoseStack)msLocal);
        boolean inverted = (Boolean)blockState.m_61143_((Property)ArmBlock.CEILING);
        boolean bl = rave = be.phase == ArmBlockEntity.Phase.DANCING && be.getSpeed() != 0.0f;
        if (rave) {
            float renderTick = AnimationTickHolder.getRenderTime((LevelAccessor)be.m_58904_()) + (float)(be.hashCode() % 64);
            baseAngle = renderTick * 10.0f % 360.0f;
            lowerArmAngle = Mth.m_14179_((float)((Mth.m_14031_((float)(renderTick / 4.0f)) + 1.0f) / 2.0f), (float)-45.0f, (float)15.0f);
            upperArmAngle = Mth.m_14179_((float)((Mth.m_14031_((float)(renderTick / 8.0f)) + 1.0f) / 4.0f), (float)-45.0f, (float)95.0f);
            headAngle = -lowerArmAngle;
            color = Color.rainbowColor(AnimationTickHolder.getTicks() * 100).getRGB();
        } else {
            baseAngle = be.baseAngle.getValue(pt);
            lowerArmAngle = be.lowerArmAngle.getValue(pt) - 135.0f;
            upperArmAngle = be.upperArmAngle.getValue(pt) - 90.0f;
            headAngle = be.headAngle.getValue(pt);
            color = 0xFFFFFF;
        }
        msr.centre();
        if (inverted) {
            msr.rotateX(180.0);
        }
        if (usingFlywheel) {
            this.doItemTransforms(msr, baseAngle, lowerArmAngle, upperArmAngle, headAngle);
        } else {
            this.renderArm(builder, ms, msLocal, msr, blockState, color, baseAngle, lowerArmAngle, upperArmAngle, headAngle, be.goggles, inverted && be.goggles, hasItem, isBlockItem, light);
        }
        if (hasItem) {
            ms.m_85836_();
            float itemScale = isBlockItem ? 0.5f : 0.625f;
            msr.rotateX(90.0);
            msLocal.m_252880_(0.0f, isBlockItem ? -0.5625f : -0.625f, 0.0f);
            msLocal.m_85841_(itemScale, itemScale, itemScale);
            ms.m_85850_().m_252922_().mul((Matrix4fc)msLocal.m_85850_().m_252922_());
            itemRenderer.m_269128_(item, ItemDisplayContext.FIXED, light, overlay, ms, buffer, be.m_58904_(), 0);
            ms.m_85849_();
        }
    }

    private void renderArm(VertexConsumer builder, PoseStack ms, PoseStack msLocal, TransformStack msr, BlockState blockState, int color, float baseAngle, float lowerArmAngle, float upperArmAngle, float headAngle, boolean goggles, boolean inverted, boolean hasItem, boolean isBlockItem, int light) {
        SuperByteBuffer base = CachedBufferer.partial(AllPartialModels.ARM_BASE, blockState).light(light);
        SuperByteBuffer lowerBody = CachedBufferer.partial(AllPartialModels.ARM_LOWER_BODY, blockState).light(light);
        SuperByteBuffer upperBody = CachedBufferer.partial(AllPartialModels.ARM_UPPER_BODY, blockState).light(light);
        SuperByteBuffer claw = CachedBufferer.partial(goggles ? AllPartialModels.ARM_CLAW_BASE_GOGGLES : AllPartialModels.ARM_CLAW_BASE, blockState).light(light);
        SuperByteBuffer upperClawGrip = CachedBufferer.partial(AllPartialModels.ARM_CLAW_GRIP_UPPER, blockState).light(light);
        SuperByteBuffer lowerClawGrip = CachedBufferer.partial(AllPartialModels.ARM_CLAW_GRIP_LOWER, blockState).light(light);
        ArmRenderer.transformBase(msr, baseAngle);
        base.transform(msLocal).renderInto(ms, builder);
        ArmRenderer.transformLowerArm(msr, lowerArmAngle);
        lowerBody.color(color).transform(msLocal).renderInto(ms, builder);
        ArmRenderer.transformUpperArm(msr, upperArmAngle);
        upperBody.color(color).transform(msLocal).renderInto(ms, builder);
        ArmRenderer.transformHead(msr, headAngle);
        if (inverted) {
            msr.rotateZ(180.0);
        }
        claw.transform(msLocal).renderInto(ms, builder);
        if (inverted) {
            msr.rotateZ(180.0);
        }
        for (int flip : Iterate.positiveAndNegative) {
            msLocal.m_85836_();
            ArmRenderer.transformClawHalf(msr, hasItem, isBlockItem, flip);
            (flip > 0 ? lowerClawGrip : upperClawGrip).transform(msLocal).renderInto(ms, builder);
            msLocal.m_85849_();
        }
    }

    private void doItemTransforms(TransformStack msr, float baseAngle, float lowerArmAngle, float upperArmAngle, float headAngle) {
        ArmRenderer.transformBase(msr, baseAngle);
        ArmRenderer.transformLowerArm(msr, lowerArmAngle);
        ArmRenderer.transformUpperArm(msr, upperArmAngle);
        ArmRenderer.transformHead(msr, headAngle);
    }

    public static void transformClawHalf(TransformStack msr, boolean hasItem, boolean isBlockItem, int flip) {
        msr.translate(0.0, (double)((float)(-flip) * (hasItem ? (isBlockItem ? 0.1875f : 0.078125f) : 0.0625f)), -0.375);
    }

    public static void transformHead(TransformStack msr, float headAngle) {
        msr.translate(0.0, 0.0, -0.9375);
        msr.rotateX((double)(headAngle - 45.0f));
    }

    public static void transformUpperArm(TransformStack msr, float upperArmAngle) {
        msr.translate(0.0, 0.0, -0.875);
        msr.rotateX((double)(upperArmAngle - 90.0f));
    }

    public static void transformLowerArm(TransformStack msr, float lowerArmAngle) {
        msr.translate(0.0, 0.125, 0.0);
        msr.rotateX((double)(lowerArmAngle + 135.0f));
    }

    public static void transformBase(TransformStack msr, float baseAngle) {
        msr.translate(0.0, 0.25, 0.0);
        msr.rotateY((double)baseAngle);
    }

    public boolean shouldRenderOffScreen(ArmBlockEntity be) {
        return true;
    }

    @Override
    protected SuperByteBuffer getRotatedModel(ArmBlockEntity be, BlockState state) {
        return CachedBufferer.partial(AllPartialModels.ARM_COG, state);
    }
}

