/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.element;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.ponder.PonderWorld;
import com.simibubi.create.foundation.ponder.element.PonderSceneElement;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public abstract class AnimatedSceneElement
extends PonderSceneElement {
    protected Vec3 fadeVec;
    protected LerpedFloat fade = LerpedFloat.linear().startWithValue(0.0);

    public void forceApplyFade(float fade) {
        this.fade.startWithValue(fade);
    }

    public void setFade(float fade) {
        this.fade.setValue(fade);
    }

    public void setFadeVec(Vec3 fadeVec) {
        this.fadeVec = fadeVec;
    }

    @Override
    public final void renderFirst(PonderWorld world, MultiBufferSource buffer, PoseStack ms, float pt) {
        ms.m_85836_();
        float currentFade = this.applyFade(ms, pt);
        this.renderFirst(world, buffer, ms, currentFade, pt);
        ms.m_85849_();
    }

    @Override
    public final void renderLayer(PonderWorld world, MultiBufferSource buffer, RenderType type, PoseStack ms, float pt) {
        ms.m_85836_();
        float currentFade = this.applyFade(ms, pt);
        this.renderLayer(world, buffer, type, ms, currentFade, pt);
        ms.m_85849_();
    }

    @Override
    public final void renderLast(PonderWorld world, MultiBufferSource buffer, PoseStack ms, float pt) {
        ms.m_85836_();
        float currentFade = this.applyFade(ms, pt);
        this.renderLast(world, buffer, ms, currentFade, pt);
        ms.m_85849_();
    }

    protected float applyFade(PoseStack ms, float pt) {
        float currentFade = this.fade.getValue(pt);
        if (this.fadeVec != null) {
            TransformStack.cast((PoseStack)ms).translate(this.fadeVec.m_82490_((double)(-1.0f + currentFade)));
        }
        return currentFade;
    }

    protected void renderLayer(PonderWorld world, MultiBufferSource buffer, RenderType type, PoseStack ms, float fade, float pt) {
    }

    protected void renderFirst(PonderWorld world, MultiBufferSource buffer, PoseStack ms, float fade, float pt) {
    }

    protected void renderLast(PonderWorld world, MultiBufferSource buffer, PoseStack ms, float fade, float pt) {
    }

    protected int lightCoordsFromFade(float fade) {
        int light = 0xF000F0;
        if (fade != 1.0f) {
            light = (int)Mth.m_14179_((float)fade, (float)5.0f, (float)15.0f);
            light = LightTexture.m_109885_((int)light, (int)light);
        }
        return light;
    }
}

