/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.api.nutrients;

import com.github.elenterius.biomancy.api.nutrients.FluidToFuelConversion;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class FluidNutrients {
    private static final Map<ResourceLocation, FluidToFuelConversion> FLUIDS = new HashMap<ResourceLocation, FluidToFuelConversion>();

    private FluidNutrients() {
    }

    public static void registerFuel(FluidType fluidType, FluidToFuelConversion func) {
        ResourceLocation key = ((IForgeRegistry)ForgeRegistries.FLUID_TYPES.get()).getKey((Object)fluidType);
        FLUIDS.put(key, func);
    }

    public static void registerFuel(Fluid fluid, FluidToFuelConversion func) {
        ResourceLocation key = ((IForgeRegistry)ForgeRegistries.FLUID_TYPES.get()).getKey((Object)fluid.getFluidType());
        FLUIDS.put(key, func);
    }

    public static void registerFuel(RegistryObject<FluidType> fluidTypeHolder, FluidToFuelConversion func) {
        ResourceLocation key = fluidTypeHolder.getId();
        FLUIDS.put(key, func);
    }

    public static void registerFuel(ResourceLocation fluidTypeRegistryKey, FluidToFuelConversion func) {
        FLUIDS.put(fluidTypeRegistryKey, func);
    }

    public static boolean isValidFuel(FluidStack fluidStack) {
        ResourceLocation key = ((IForgeRegistry)ForgeRegistries.FLUID_TYPES.get()).getKey((Object)fluidStack.getFluid().getFluidType());
        return FLUIDS.containsKey(key);
    }

    @Nullable
    public static FluidToFuelConversion getFuelConversion(FluidStack fluidStack) {
        ResourceLocation key = ((IForgeRegistry)ForgeRegistries.FLUID_TYPES.get()).getKey((Object)fluidStack.getFluid().getFluidType());
        return FLUIDS.get(key);
    }
}

