/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.api.tribute;

import com.github.elenterius.biomancy.api.tribute.Tribute;
import com.github.elenterius.biomancy.init.tags.ModMobEffectTags;
import com.github.elenterius.biomancy.mixin.SuspiciousStewItemAccessor;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.SuspiciousStewItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public record MobEffectTribute(int lifeEnergy, int successModifier, int diseaseModifier, int hostileModifier, int anomalyModifier) implements Tribute
{
    static Tribute from(ItemStack stack) {
        boolean isFoodItem;
        boolean isPotionItem = stack.m_41720_() instanceof PotionItem;
        boolean isSuspiciousStewItem = stack.m_41720_() instanceof SuspiciousStewItem;
        FoodProperties food = stack.getFoodProperties(null);
        boolean bl = isFoodItem = food != null && !food.m_38749_().isEmpty();
        if (!(isPotionItem || isSuspiciousStewItem || isFoodItem)) {
            return Tribute.EMPTY;
        }
        Builder builder = new Builder();
        if (isPotionItem) {
            List effectInstances = PotionUtils.m_43547_((ItemStack)stack);
            for (MobEffectInstance effectInstance2 : effectInstances) {
                builder.addEffect(effectInstance2);
            }
        }
        if (isSuspiciousStewItem) {
            SuspiciousStewItemAccessor.biomancy$ListPotionEffects(stack, effectInstance -> builder.addEffect((MobEffectInstance)effectInstance, 0.35f));
        }
        if (isFoodItem) {
            for (Pair pair : food.m_38749_()) {
                MobEffectInstance effectInstance2;
                effectInstance2 = (MobEffectInstance)pair.getFirst();
                float chance = ((Float)pair.getSecond()).floatValue();
                builder.addEffect(effectInstance2, chance * 0.25f);
            }
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public int biomass() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return this.lifeEnergy == 0 && this.successModifier == 0 && this.diseaseModifier == 0 && this.hostileModifier == 0 && this.anomalyModifier == 0;
    }

    public static class Builder {
        private float lifeEnergy = 0.0f;
        private int diseaseModifier = 0;
        private int successModifier = 0;
        private int hostileModifier = 0;
        private int anomalyModifier = 0;

        private Builder() {
        }

        public Builder addEffect(MobEffectInstance instance) {
            this.addEffect(instance, 1.0f);
            return this;
        }

        public Builder addEffect(MobEffectInstance instance, float chance) {
            this.addEffect(instance.m_19544_(), instance.m_19564_(), chance);
            return this;
        }

        public Builder addEffect(MobEffect effect) {
            this.addEffect(effect, 1, 1.0f);
            return this;
        }

        public Builder addEffect(MobEffect effect, int amplifier, float chance) {
            int level;
            if (ModMobEffectTags.isCradleLifeEnergySource(effect)) {
                level = amplifier + 1;
                this.lifeEnergy += (float)(level * 60) * chance;
            }
            if (ModMobEffectTags.isCradleDiseaseSource(effect)) {
                level = amplifier + 1;
                this.diseaseModifier += Math.round((float)(level * 15) * chance);
            }
            if (ModMobEffectTags.isCradleSuccessSource(effect)) {
                level = amplifier + 1;
                this.successModifier += Math.round((float)(level * 50) * chance);
            }
            if (ModMobEffectTags.isCradleHostilitySource(effect)) {
                level = amplifier + 1;
                this.hostileModifier += Math.round((float)(level * 15) * chance);
            }
            if (ModMobEffectTags.isCradleAnomalySource(effect)) {
                level = amplifier + 1;
                this.anomalyModifier += Math.round((float)(level * 50) * chance);
            }
            return this;
        }

        public MobEffectTribute build() {
            return new MobEffectTribute(Math.round(this.lifeEnergy), this.successModifier, this.diseaseModifier, this.hostileModifier, this.anomalyModifier);
        }
    }
}

