/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.membrane;

import com.github.elenterius.biomancy.block.PaneBlock;
import com.github.elenterius.biomancy.block.membrane.IgnoreEntityCollisionPredicate;
import com.github.elenterius.biomancy.block.membrane.Membrane;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class MembranePaneBlock
extends PaneBlock
implements Membrane {
    protected final IgnoreEntityCollisionPredicate ignoreEntityCollisionPredicate;

    public MembranePaneBlock(BlockBehaviour.Properties properties, IgnoreEntityCollisionPredicate predicate) {
        super(properties);
        this.ignoreEntityCollisionPredicate = predicate;
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public float m_7749_(BlockState state, BlockGetter level, BlockPos pos) {
        return 1.0f;
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        entity.m_142535_(fallDistance, 0.2f, level.m_269111_().m_268989_());
    }

    @Override
    public boolean shouldIgnoreEntityCollisionAt(BlockState state, BlockGetter level, BlockPos pos, Entity entity) {
        return this.ignoreEntityCollisionPredicate.test(state, level, pos, entity);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        EntityCollisionContext entityContext;
        Entity entity;
        if (context instanceof EntityCollisionContext && (entity = (entityContext = (EntityCollisionContext)context).m_193113_()) != null && this.shouldIgnoreEntityCollisionAt(state, level, pos, entity)) {
            return Shapes.m_83040_();
        }
        return state.m_60808_(level, pos);
    }

    @Nullable
    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob) {
        return BlockPathTypes.STICKY_HONEY;
    }

    @Override
    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case PathComputationType.LAND, PathComputationType.AIR -> true;
            case PathComputationType.WATER -> level.m_6425_(pos).m_205070_(FluidTags.f_13131_);
        };
    }

    public boolean m_6104_(BlockState state, BlockState adjacentBlockState, Direction side) {
        return adjacentBlockState.m_60713_((Block)this) && MembranePaneBlock.getOrientation(state) == MembranePaneBlock.getOrientation(adjacentBlockState) || super.m_6104_(state, adjacentBlockState, side);
    }
}

