/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.modularlarynx;

import com.github.elenterius.biomancy.block.modularlarynx.ModularLarynxBlock;
import com.github.elenterius.biomancy.block.property.MobSoundType;
import com.github.elenterius.biomancy.init.ModBlockEntities;
import com.github.elenterius.biomancy.init.ModCapabilities;
import com.github.elenterius.biomancy.inventory.itemhandler.SingleItemStackHandler;
import com.github.elenterius.biomancy.item.EssenceItem;
import com.github.elenterius.biomancy.util.MobSoundUtil;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ModularLarynxBlockEntity
extends BlockEntity {
    public static final String INVENTORY_TAG = "inventory";
    public static final String SOUND_EVENT_TAG = "sound_event";
    public static final Predicate<ItemStack> VALID_ITEM = stack -> stack.m_41720_() instanceof EssenceItem;
    private final SingleItemStackHandler inventory = new SingleItemStackHandler(){

        @Override
        public int getSlotLimit(int slot) {
            return 1;
        }

        @Override
        public boolean isItemValid(@NotNull ItemStack stack) {
            return VALID_ITEM.test(stack);
        }

        @Override
        protected void onContentsChanged() {
            ModularLarynxBlockEntity.this.updateSounds();
            ModularLarynxBlockEntity.this.m_6596_();
        }
    };
    private LazyOptional<IItemHandler> optionalItemHandler = LazyOptional.of(() -> this.inventory);
    private SoundEvent soundEvent;

    public ModularLarynxBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.MODULAR_LARYNX.get(), pos, state);
        this.soundEvent = MobSoundUtil.getSoundFallbackFor(ModularLarynxBlock.getMobSoundType(state));
    }

    public boolean isInventoryEmpty() {
        return this.inventory.isEmpty();
    }

    public ItemStack insertItemStack(ItemStack stack) {
        return this.inventory.insertItem(stack, false);
    }

    protected void updateSounds() {
        ItemStack stack = this.inventory.getStack();
        MobSoundType mobSoundType = ModularLarynxBlock.getMobSoundType(this.m_58900_());
        Item item = stack.m_41720_();
        if (item instanceof EssenceItem) {
            EssenceItem essenceItem = (EssenceItem)item;
            this.soundEvent = essenceItem.getMobSound(stack, mobSoundType).orElse(MobSoundUtil.getSoundFallbackFor(mobSoundType));
        } else {
            this.soundEvent = MobSoundUtil.getSoundFallbackFor(mobSoundType);
        }
    }

    public boolean playSound(float volume, float pitch) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return false;
        }
        BlockPos pos = this.m_58899_();
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 0.5;
        double z = (double)pos.m_123343_() + 0.5;
        this.f_58857_.m_6263_(null, x, y, z, this.soundEvent, SoundSource.RECORDS, volume, pitch);
        return true;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_(INVENTORY_TAG, (Tag)this.inventory.serializeNBT());
        tag.m_128359_(SOUND_EVENT_TAG, this.soundEvent.m_11660_().toString());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory.deserializeNBT(tag.m_128469_(INVENTORY_TAG));
        this.soundEvent = this.deserializeSoundEvent(tag.m_128461_(SOUND_EVENT_TAG)).orElseGet(() -> MobSoundUtil.getSoundFallbackFor(ModularLarynxBlock.getMobSoundType(this.m_58900_())));
    }

    public Optional<SoundEvent> deserializeSoundEvent(String stringKey) {
        ResourceLocation key = ResourceLocation.m_135820_((String)stringKey);
        if (key != null) {
            return Optional.ofNullable((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(key));
        }
        return Optional.empty();
    }

    public void dropInventoryContents(Level level, BlockPos pos) {
        ItemStack stack = this.inventory.extractItem(this.inventory.getMaxAmount(), false);
        if (!stack.m_41619_()) {
            Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack);
        }
    }

    public void giveInventoryContentsTo(Level level, BlockPos pos, Player player) {
        ItemStack stack = this.inventory.extractItem(this.inventory.getMaxAmount(), false);
        if (!stack.m_41619_() && !player.m_36356_(stack)) {
            player.m_36176_(stack, false);
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.optionalItemHandler.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.optionalItemHandler = LazyOptional.of(() -> this.inventory);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (!this.f_58859_) {
            return ModCapabilities.ITEM_HANDLER.orEmpty(cap, this.optionalItemHandler);
        }
        return super.getCapability(cap, side);
    }
}

