/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.ownable;

import com.github.elenterius.biomancy.block.base.SimpleSyncedBlockEntity;
import com.github.elenterius.biomancy.init.ModBlockEntities;
import com.github.elenterius.biomancy.ownable.Ownable;
import com.github.elenterius.biomancy.permission.IRestrictedInteraction;
import com.github.elenterius.biomancy.permission.UserType;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class OwnableBlockEntity
extends SimpleSyncedBlockEntity
implements Ownable,
IRestrictedInteraction {
    public static final int MAX_USERS = 10;
    private final HashMap<UUID, UserType> users = new HashMap(6);
    @Nullable
    private UUID ownerId;

    public OwnableBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.OWNABLE_BE.get(), pos, state);
    }

    protected OwnableBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public UserType getUserType(UUID userId) {
        if (this.isOwner(userId)) {
            return UserType.OWNER;
        }
        return this.users.getOrDefault(userId, UserType.NONE);
    }

    @Override
    public boolean setUserType(UUID userId, UserType userType) {
        if (this.users.size() >= 10 && !this.users.containsKey(userId)) {
            return false;
        }
        this.users.put(userId, userType);
        this.syncToClient();
        return true;
    }

    @Override
    public void removeUser(UUID userId) {
        if (this.users.containsKey(userId)) {
            this.users.remove(userId);
            this.syncToClient();
        }
    }

    @Override
    public Optional<UUID> getOptionalOwnerUUID() {
        return Optional.ofNullable(this.ownerId);
    }

    @Override
    public void setOwner(UUID userId) {
        this.ownerId = userId;
        this.syncToClient();
        this.m_6596_();
    }

    @Override
    public boolean hasOwner() {
        return this.ownerId != null;
    }

    @Override
    public boolean isOwner(UUID userId) {
        if (this.ownerId == null) {
            return false;
        }
        return userId.equals(this.ownerId);
    }

    @Override
    public void removeOwner() {
        this.ownerId = null;
        this.syncToClient();
        this.m_6596_();
    }

    @Override
    protected void saveForSyncToClient(CompoundTag tag) {
        if (this.ownerId != null) {
            tag.m_128362_("OwnerUUID", this.ownerId);
        }
        if (this.users.size() > 0) {
            ListTag listNBT = new ListTag();
            for (Map.Entry<UUID, UserType> user : this.users.entrySet()) {
                CompoundTag userTag = new CompoundTag();
                userTag.m_128362_("UserUUID", user.getKey());
                user.getValue().serialize(userTag);
                listNBT.add((Object)userTag);
            }
            tag.m_128365_("UserList", (Tag)listNBT);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.ownerId = tag.m_128403_("OwnerUUID") ? tag.m_128342_("OwnerUUID") : null;
        this.users.clear();
        if (tag.m_128441_("UserList")) {
            ListTag nbtList = tag.m_128437_("UserList", 10);
            for (int i = 0; i < nbtList.size(); ++i) {
                CompoundTag userTag = nbtList.m_128728_(i);
                UUID userUUID = userTag.m_128342_("UserUUID");
                UserType authority = UserType.deserialize(userTag);
                this.users.put(userUUID, authority);
            }
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.ownerId != null) {
            tag.m_128362_("OwnerUUID", this.ownerId);
        }
        if (this.users.size() > 0) {
            ListTag listNBT = new ListTag();
            for (Map.Entry<UUID, UserType> user : this.users.entrySet()) {
                CompoundTag userTag = new CompoundTag();
                userTag.m_128362_("UserUUID", user.getKey());
                user.getValue().serialize(userTag);
                listNBT.add((Object)userTag);
            }
            tag.m_128365_("UserList", (Tag)listNBT);
        }
    }
}

