/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.vialholder;

import com.github.elenterius.biomancy.block.vialholder.VialHolderBlockEntity;
import com.github.elenterius.biomancy.init.ModBlockEntities;
import com.github.elenterius.biomancy.init.ModBlockProperties;
import com.github.elenterius.biomancy.util.VoxelShapeUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class VialHolderBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty VIAL_0 = ModBlockProperties.VIAL_0;
    public static final BooleanProperty VIAL_1 = ModBlockProperties.VIAL_1;
    public static final BooleanProperty VIAL_2 = ModBlockProperties.VIAL_2;
    public static final BooleanProperty VIAL_3 = ModBlockProperties.VIAL_3;
    public static final BooleanProperty VIAL_4 = ModBlockProperties.VIAL_4;
    public static final VoxelShape SHAPE_NORTH = VialHolderBlock.createShape(Direction.NORTH);
    public static final VoxelShape SHAPE_SOUTH = VialHolderBlock.createShape(Direction.SOUTH);
    public static final VoxelShape SHAPE_WEST = VialHolderBlock.createShape(Direction.WEST);
    public static final VoxelShape SHAPE_EAST = VialHolderBlock.createShape(Direction.EAST);
    protected static final BooleanProperty[] VIAL_PROPERTIES = new BooleanProperty[]{VIAL_0, VIAL_1, VIAL_2, VIAL_3, VIAL_4};

    public VialHolderBlock(BlockBehaviour.Properties properties) {
        super(properties);
        BlockState defaultState = this.m_49966_();
        for (BooleanProperty vialProperty : VIAL_PROPERTIES) {
            defaultState = (BlockState)defaultState.m_61124_((Property)vialProperty, (Comparable)Boolean.valueOf(false));
        }
        this.m_49959_((BlockState)defaultState.m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public static VoxelShape createShape(Direction direction) {
        return VoxelShapeUtil.createYRotatedTowards(direction, 0.0, 6.0, 12.0, 16.0, 14.0, 16.0);
    }

    public static List<BooleanProperty> getVialProperties() {
        return List.of(VIAL_PROPERTIES);
    }

    public static Direction getFacing(BlockState state) {
        return (Direction)state.m_61143_((Property)FACING);
    }

    private static boolean hasVial(BlockState state, int index) {
        if (index < 0 || index >= VIAL_PROPERTIES.length) {
            return false;
        }
        return (Boolean)state.m_61143_((Property)VIAL_PROPERTIES[index]);
    }

    public static int getTintColor(BlockState state, @Nullable BlockAndTintGetter level, @Nullable BlockPos pos, int tintIndex) {
        if (level == null || pos == null || !VialHolderBlock.hasVial(state, tintIndex)) {
            return -1;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof VialHolderBlockEntity) {
            VialHolderBlockEntity vialHolder = (VialHolderBlockEntity)blockEntity;
            return vialHolder.getVialColor(tintIndex);
        }
        return -1;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING}).m_61104_((Property[])VIAL_PROPERTIES);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction clickedFace = context.m_43719_();
        if (clickedFace.m_122434_().m_122479_()) {
            return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)clickedFace);
        }
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)ModBlockEntities.VIAL_HOLDER.get()).m_155264_(pos, state);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof VialHolderBlockEntity) {
            VialHolderBlockEntity vialHolder = (VialHolderBlockEntity)blockEntity;
            vialHolder.updateBlockState();
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof VialHolderBlockEntity) {
            VialHolderBlockEntity vialHolder = (VialHolderBlockEntity)blockEntity;
            Direction facing = VialHolderBlock.getFacing(state);
            Vec3 hitLocation = hit.m_82450_();
            float v = (float)facing.m_122427_().m_122434_().m_6150_(hitLocation.f_82479_, hitLocation.f_82480_, hitLocation.f_82481_);
            v = Math.abs(v - (float)Mth.m_14143_((float)v));
            int maxIndex = VIAL_PROPERTIES.length - 1;
            int index = 0;
            float min = 0.03125f;
            float max = 0.96875f;
            if (v >= max) {
                index = maxIndex;
            } else if (v > min) {
                v = (v - min) / (max - min);
                index = Mth.m_14143_((float)(v * (float)VIAL_PROPERTIES.length));
            }
            if (facing == Direction.NORTH || facing == Direction.EAST) {
                index = maxIndex - index;
            }
            if (!vialHolder.isValidSlotIndex(index)) {
                return InteractionResult.FAIL;
            }
            boolean isVialSlotEmpty = !vialHolder.hasVial(index);
            ItemStack stackInHand = player.m_21120_(hand);
            boolean isHandEmpty = stackInHand.m_41619_();
            if (isHandEmpty) {
                if (isVialSlotEmpty) {
                    return InteractionResult.FAIL;
                }
                if (!level.f_46443_) {
                    vialHolder.extractVial(player, index);
                }
            } else {
                if (!isVialSlotEmpty) {
                    return InteractionResult.FAIL;
                }
                if (!level.f_46443_) {
                    ItemStack remainder = vialHolder.insertVial(stackInHand, index);
                    player.m_21008_(hand, remainder);
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof VialHolderBlockEntity) {
                VialHolderBlockEntity vialHolder = (VialHolderBlockEntity)blockEntity;
                vialHolder.dropInventoryContents(level, pos, true);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_(VialHolderBlock.getFacing(state)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_(VialHolderBlock.getFacing(state)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch (VialHolderBlock.getFacing(state)) {
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
            default -> Shapes.m_83144_();
        };
    }
}

