/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.vialholder;

import com.github.elenterius.biomancy.api.serum.SerumContainer;
import com.github.elenterius.biomancy.block.base.SimpleSyncedBlockEntity;
import com.github.elenterius.biomancy.block.vialholder.VialHolderBlock;
import com.github.elenterius.biomancy.init.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class VialHolderBlockEntity
extends SimpleSyncedBlockEntity {
    public static final String INVENTORY_TAG = "Inventory";
    private final ItemStackHandler inventory;

    public VialHolderBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.VIAL_HOLDER.get(), pos, blockState);
        this.reRenderBlockOnSync = true;
        this.inventory = new ItemStackHandler(5){

            public int getSlotLimit(int slot) {
                return 1;
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return stack.m_41720_() instanceof SerumContainer;
            }

            protected void onContentsChanged(int slot) {
                VialHolderBlockEntity.this.m_6596_();
                VialHolderBlockEntity.this.syncToClient();
                VialHolderBlockEntity.this.updateBlockStateDelayed();
            }
        };
    }

    protected void updateBlockStateDelayed() {
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        this.f_58857_.m_186460_(this.m_58899_(), this.m_58900_().m_60734_(), 1);
    }

    protected void updateBlockState() {
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        BlockState oldState = this.m_58900_();
        BlockState newState = this.m_58900_();
        for (int i = 0; i < VialHolderBlock.VIAL_PROPERTIES.length; ++i) {
            BooleanProperty vialProperty = VialHolderBlock.VIAL_PROPERTIES[i];
            newState = (BlockState)newState.m_61124_((Property)vialProperty, (Comparable)Boolean.valueOf(this.inventory.getStackInSlot(i).m_41720_() instanceof SerumContainer));
        }
        if (newState != oldState) {
            this.f_58857_.m_7731_(this.m_58899_(), newState, 3);
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_(INVENTORY_TAG, (Tag)this.inventory.serializeNBT());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory.deserializeNBT(tag.m_128469_(INVENTORY_TAG));
        this.updateBlockStateDelayed();
    }

    @Override
    protected void saveForSyncToClient(CompoundTag tag) {
        tag.m_128365_(INVENTORY_TAG, (Tag)this.inventory.serializeNBT());
    }

    public void dropInventoryContents(Level level, BlockPos pos, boolean removeWithoutUpdate) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stack = this.inventory.extractItem(i, this.inventory.getSlotLimit(i), removeWithoutUpdate);
            if (stack.m_41619_()) continue;
            Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack);
        }
    }

    public void extractVial(Player player, int slot) {
        if (slot < 0 || slot >= this.inventory.getSlots()) {
            return;
        }
        ItemStack stack = this.inventory.extractItem(slot, this.inventory.getSlotLimit(slot), false);
        if (!stack.m_41619_() && !player.m_36356_(stack)) {
            player.m_36176_(stack, false);
        }
    }

    public ItemStack insertVial(ItemStack stack, int slot) {
        if (slot < 0 || slot >= this.inventory.getSlots()) {
            return stack;
        }
        return this.inventory.insertItem(slot, stack, false);
    }

    public boolean hasVial(int slot) {
        if (slot < 0 || slot >= this.inventory.getSlots()) {
            return false;
        }
        return this.inventory.getStackInSlot(slot).m_41720_() instanceof SerumContainer;
    }

    public boolean isValidSlotIndex(int slot) {
        return slot >= 0 && slot < this.inventory.getSlots();
    }

    public int getVialColor(int slot) {
        if (slot < 0 || slot >= this.inventory.getSlots()) {
            return -1;
        }
        Item item = this.inventory.getStackInSlot(slot).m_41720_();
        if (item instanceof SerumContainer) {
            SerumContainer container = (SerumContainer)item;
            return container.getSerum().getColor();
        }
        return -1;
    }
}

