/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.client.gui;

import com.github.elenterius.biomancy.BiomancyMod;
import com.github.elenterius.biomancy.api.serum.SerumContainer;
import com.github.elenterius.biomancy.client.util.GuiRenderUtil;
import com.github.elenterius.biomancy.client.util.GuiUtil;
import com.github.elenterius.biomancy.item.ItemCharge;
import com.github.elenterius.biomancy.item.injector.InjectorItem;
import com.github.elenterius.biomancy.item.weapon.gun.Gun;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public final class IngameOverlays {
    public static final ResourceLocation INJECTOR_COOL_DOWN = BiomancyMod.createRL("textures/gui/indicator_injector_cooldown.png");
    public static final ResourceLocation ORNATE_CORNER_BOTTOM_RIGHT = BiomancyMod.createRL("textures/gui/ornate_corner_br.png");
    public static final ResourceLocation CHARGE_BAR = BiomancyMod.createRL("textures/gui/charge_bar.png");
    public static final ResourceLocation ATTACK_REACH = BiomancyMod.createRL("textures/gui/indicator_attack_reach.png");
    public static final IGuiOverlay GUN_OVERLAY = (gui, poseStack, partialTicks, screenWidth, screenHeight) -> {
        Minecraft minecraft = Minecraft.m_91087_();
        if (!minecraft.f_91066_.f_92062_ && minecraft.f_91074_ != null) {
            Item patt1845$temp;
            ItemStack itemStack = minecraft.f_91074_.m_21205_();
            if (itemStack.m_41619_() || !((patt1845$temp = itemStack.m_41720_()) instanceof Gun)) {
                return;
            }
            Gun gun = (Gun)patt1845$temp;
            gui.setupOverlayRenderState(true, false);
            IngameOverlays.renderGunOverlay(gui, poseStack, screenWidth, screenHeight, -90, minecraft.f_91074_, itemStack, gun);
        }
    };
    public static final IGuiOverlay INJECTOR_OVERLAY = (gui, guiGraphics, partialTicks, screenWidth, screenHeight) -> {
        Minecraft minecraft = Minecraft.m_91087_();
        if (!minecraft.f_91066_.f_92062_ && minecraft.f_91074_ != null) {
            Item patt2375$temp;
            ItemStack itemStack = minecraft.f_91074_.m_21205_();
            if (itemStack.m_41619_() || !((patt2375$temp = itemStack.m_41720_()) instanceof InjectorItem)) {
                return;
            }
            InjectorItem injector = (InjectorItem)patt2375$temp;
            gui.setupOverlayRenderState(true, false);
            IngameOverlays.renderInjectorOverlay(guiGraphics, gui.m_93082_(), partialTicks, screenWidth, screenHeight, -90, minecraft.f_91074_, itemStack, injector);
        }
    };
    public static final IGuiOverlay CHARGE_BAR_OVERLAY = (gui, guiGraphics, partialTicks, screenWidth, screenHeight) -> {
        Minecraft minecraft = Minecraft.m_91087_();
        if (!minecraft.f_91066_.f_92062_ && minecraft.f_91074_ != null) {
            Item patt2945$temp;
            ItemStack stack = minecraft.f_91074_.m_21205_();
            if (stack.m_41619_() || !((patt2945$temp = stack.m_41720_()) instanceof ItemCharge)) {
                return;
            }
            ItemCharge abilityCharge = (ItemCharge)patt2945$temp;
            if (GuiUtil.isFirstPersonView()) {
                gui.setupOverlayRenderState(true, false);
                IngameOverlays.renderChargeBar(guiGraphics, gui.m_93082_(), screenWidth, screenHeight, -90, abilityCharge.getCharge(stack), abilityCharge.getChargePct(stack));
            }
        }
    };

    private IngameOverlays() {
    }

    static void renderGunOverlay(ForgeGui gui, GuiGraphics guiGraphics, int screenWidth, int screenHeight, int zDepth, LocalPlayer player, ItemStack stack, Gun gun) {
        IngameOverlays.renderAmmoOverlay(guiGraphics, gui.m_93082_(), screenWidth, screenHeight, zDepth, stack, gun);
        if (GuiUtil.isFirstPersonView()) {
            IngameOverlays.renderReloadIndicator(guiGraphics, screenWidth, screenHeight, zDepth, player, stack, gun);
        }
    }

    static void renderInjectorOverlay(GuiGraphics guiGraphics, Font font, float partialTicks, int screenWidth, int screenHeight, int zDepth, LocalPlayer player, ItemStack stack, InjectorItem injector) {
        if (GuiUtil.isFirstPersonView()) {
            SerumContainer container;
            ItemStack serumItemStack;
            Item item;
            float progress = 1.0f - player.m_36335_().m_41521_((Item)injector, partialTicks);
            if (progress < 1.0f) {
                int x = screenWidth / 2 - 8;
                int y = screenHeight / 2 - 7 - 8;
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                guiGraphics.m_280398_(INJECTOR_COOL_DOWN, x, y, zDepth, 0.0f, 0.0f, 16, 7, 16, 16);
                guiGraphics.m_280398_(INJECTOR_COOL_DOWN, x, y, zDepth, 0.0f, 7.0f, (int)(progress * 16.0f), 7, 16, 16);
                RenderSystem.defaultBlendFunc();
            }
            if ((item = (serumItemStack = injector.getSerumItemStack(stack)).m_41720_()) instanceof SerumContainer && !(container = (SerumContainer)item).getSerum().isEmpty()) {
                int maxAmmo = 16;
                IngameOverlays.renderAmmoCount(guiGraphics, font, screenWidth, screenHeight, zDepth, maxAmmo, serumItemStack.m_41613_(), -65794, -6381922);
            }
        }
    }

    static void renderOrnateCorner(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.m_280163_(ORNATE_CORNER_BOTTOM_RIGHT, x, y, 0.0f, 0.0f, 44, 28, 44, 28);
    }

    static void renderChargeBar(GuiGraphics guiGraphics, Font font, int screenWidth, int screenHeight, int zDepth, int charge, float chargePct) {
        LivingEntity crosshairTarget;
        int x = screenWidth / 2 - 26 + screenWidth % 2;
        int y = screenHeight / 2 + 16;
        guiGraphics.m_280398_(CHARGE_BAR, x, y, zDepth, 6.0f, 6.0f, 51, 5, 64, 16);
        guiGraphics.m_280398_(CHARGE_BAR, x, y, zDepth, 6.0f, 11.0f, (int)(chargePct * 51.0f), 5, 64, 16);
        Entity entity = Minecraft.m_91087_().f_91076_;
        if (entity instanceof LivingEntity && (crosshairTarget = (LivingEntity)entity).m_6084_()) {
            x = screenWidth / 2 - 24;
            y = screenHeight / 2 - 4;
            guiGraphics.m_280398_(ATTACK_REACH, x, y, zDepth, 0.0f, 0.0f, 48, 16, 48, 16);
        }
    }

    static void renderReloadIndicator(GuiGraphics guiGraphics, int screenWidth, int screenHeight, int zDepth, LocalPlayer player, ItemStack stack, Gun gun) {
        Gun.GunState gunState = gun.getGunState(stack);
        if (gunState == Gun.GunState.RELOADING) {
            long elapsedTime = player.f_108545_.m_46467_() - gun.getReloadStartTime(stack);
            float reloadProgress = gun.getReloadProgress(elapsedTime, gun.getReloadDurationTicks(stack));
            GuiRenderUtil.drawSquareProgressBar(guiGraphics, screenWidth / 2, screenHeight / 2, zDepth, 10, reloadProgress);
        } else {
            long elapsedTime = player.f_108545_.m_46467_() - gun.getShootTimestamp(stack);
            IngameOverlays.renderAttackIndicator(guiGraphics, screenWidth, screenHeight, zDepth, player, elapsedTime, gun.getShootDelayTicks(stack));
        }
    }

    static void renderAmmoOverlay(GuiGraphics guiGraphics, Font font, int screenWidth, int screenHeight, int zDepth, ItemStack stack, Gun gun) {
        int maxAmmo = gun.getMaxAmmo(stack);
        int ammo = gun.getAmmo(stack);
        IngameOverlays.renderAmmoCount(guiGraphics, font, screenWidth, screenHeight, zDepth, maxAmmo, ammo, -65794, -6381922);
    }

    static void renderAmmoCount(GuiGraphics guiGraphics, Font font, int screenWidth, int screenHeight, int zDepth, int maxAmmoIn, int ammoIn, int primaryColor, int secondaryColor) {
        String maxAmmo = "/" + maxAmmoIn;
        String ammo = String.valueOf(ammoIn);
        int x = screenWidth - font.m_92895_(maxAmmo) - 4;
        Objects.requireNonNull(font);
        int y = screenHeight - 9 - 4;
        guiGraphics.m_280488_(font, maxAmmo, x, y, secondaryColor);
        guiGraphics.m_280168_().m_85836_();
        float scale = 1.5f;
        PoseStack poseStack = guiGraphics.m_280168_();
        float f = (float)x - (float)font.m_92895_(ammo) * scale;
        float f2 = y;
        Objects.requireNonNull(font);
        poseStack.m_252880_(f, f2 - 9.0f * scale * 0.5f, (float)zDepth);
        guiGraphics.m_280168_().m_85841_(scale, scale, 0.0f);
        guiGraphics.m_280488_(font, ammo, 0, 0, primaryColor);
        guiGraphics.m_280168_().m_85849_();
    }

    public static void renderAttackIndicator(GuiGraphics guiGraphics, int screenWidth, int screenHeight, int zDepth, LocalPlayer player, long elapsedTime, int shootDelay) {
        float progress;
        if (elapsedTime < (long)shootDelay && GuiUtil.canDrawAttackIndicator(player) && (progress = (float)elapsedTime / (float)shootDelay) < 1.0f) {
            int x = screenWidth / 2 - 8;
            int y = screenHeight / 2 - 7 + 16;
            GuiRenderUtil.drawAttackIndicator(guiGraphics, x, y, progress);
        }
    }
}

