/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.client.gui.tooltip;

import com.github.elenterius.biomancy.BiomancyMod;
import com.github.elenterius.biomancy.inventory.itemhandler.EnhancedItemHandler;
import com.github.elenterius.biomancy.tooltip.StorageSacTooltipComponent;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class StorageSacTooltipClientComponent
implements ClientTooltipComponent {
    public static final ResourceLocation TEXTURE = BiomancyMod.createRL("textures/gui/tooltip_storage_sac.png");
    private static final int OFFSET = 2;
    @Nullable
    private final EnhancedItemHandler itemHandler;
    private final boolean isStorageSacEmpty;

    public StorageSacTooltipClientComponent(StorageSacTooltipComponent tooltip) {
        this.itemHandler = tooltip.getItemHandler();
        this.isStorageSacEmpty = this.itemHandler == null || this.itemHandler.isEmpty();
    }

    public int m_142103_() {
        return this.isStorageSacEmpty ? 0 : 60;
    }

    public int m_142069_(Font font) {
        return this.isStorageSacEmpty ? 0 : 92;
    }

    public void m_183452_(Font font, int posX, int posY, GuiGraphics guiGraphics) {
        if (this.itemHandler == null || this.isStorageSacEmpty) {
            return;
        }
        guiGraphics.m_280163_(TEXTURE, posX, posY + 2, 0.0f, 0.0f, 92, 56, 128, 64);
        boolean drawHighlight = true;
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            int x = posX + 2 + 18 * (i % 5);
            int y = posY + 2 + 2 + 18 * (i / 5);
            guiGraphics.m_280256_(stack, x, y, i);
            guiGraphics.m_280370_(font, stack, x, y);
            if (!drawHighlight) continue;
            AbstractContainerScreen.m_280359_((GuiGraphics)guiGraphics, (int)x, (int)y, (int)0);
            drawHighlight = false;
        }
    }
}

