/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class VanillaDripParticle
extends TextureSheetParticle {
    protected final Fluid type;
    private boolean isGlowing;

    protected VanillaDripParticle(ClientLevel level, double x, double y, double z, Fluid fluid) {
        super(level, x, y, z);
        this.m_107250_(0.01f, 0.01f);
        this.f_107226_ = 0.06f;
        this.type = fluid;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    protected void setGlowing(boolean glowing) {
        this.isGlowing = glowing;
    }

    public int m_6355_(float partialTick) {
        return this.isGlowing ? 240 : super.m_6355_(partialTick);
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.preMoveUpdate();
        if (!this.f_107220_) {
            this.f_107216_ -= (double)this.f_107226_;
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            this.postMoveUpdate();
            if (!this.f_107220_) {
                this.f_107215_ *= (double)0.98f;
                this.f_107216_ *= (double)0.98f;
                this.f_107217_ *= (double)0.98f;
                BlockPos blockPos = BlockPos.m_274561_((double)this.f_107212_, (double)this.f_107213_, (double)this.f_107214_);
                FluidState fluidState = this.f_107208_.m_6425_(blockPos);
                if (fluidState.m_76152_() == this.type && this.f_107213_ < (double)((float)blockPos.m_123342_() + fluidState.m_76155_((BlockGetter)this.f_107208_, blockPos))) {
                    this.m_107274_();
                }
            }
        }
    }

    protected void preMoveUpdate() {
        if (this.f_107225_-- <= 0) {
            this.m_107274_();
        }
    }

    protected void postMoveUpdate() {
    }

    protected void setColorRGB(int color) {
        this.f_107227_ = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
        this.f_107228_ = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
        this.f_107229_ = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
    }

    protected void setColorARGB(int color) {
        this.f_107227_ = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
        this.f_107228_ = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
        this.f_107229_ = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
        this.f_107230_ = (float)FastColor.ARGB32.m_13655_((int)color) / 255.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static class AcidFallAndLandParticle
    extends FallAndLandParticle {
        protected AcidFallAndLandParticle(ClientLevel level, double x, double y, double z, Fluid fluid, ParticleOptions landParticle) {
            super(level, x, y, z, fluid, landParticle);
        }

        @Override
        protected void postMoveUpdate() {
            if (this.f_107218_) {
                this.m_107274_();
                this.f_107208_.m_7106_(this.landParticle, this.f_107212_, this.f_107213_, this.f_107214_, 0.0, 0.0, 0.0);
                if (this.f_107223_.m_188503_(4) == 0) {
                    float volume = Mth.m_216283_((RandomSource)this.f_107223_, (float)0.4f, (float)0.6f);
                    float pitch = Mth.m_216283_((RandomSource)this.f_107223_, (float)1.8f, (float)3.4f);
                    this.f_107208_.m_7785_(this.f_107212_, this.f_107213_, this.f_107214_, SoundEvents.f_12031_, SoundSource.BLOCKS, volume, pitch, false);
                    for (int i = 0; i < 4; ++i) {
                        this.f_107208_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.f_107212_ + this.f_107223_.m_188500_(), this.f_107213_ + (double)0.2f, this.f_107214_ + this.f_107223_.m_188500_(), 0.0, 0.0, 0.0);
                    }
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static class FallAndLandParticle
    extends FallingParticle {
        protected final ParticleOptions landParticle;

        protected FallAndLandParticle(ClientLevel level, double x, double y, double z, Fluid fluid, ParticleOptions landParticle) {
            super(level, x, y, z, fluid);
            this.landParticle = landParticle;
        }

        @Override
        protected void postMoveUpdate() {
            if (this.f_107218_) {
                this.m_107274_();
                this.f_107208_.m_7106_(this.landParticle, this.f_107212_, this.f_107213_, this.f_107214_, 0.0, 0.0, 0.0);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static class FallingParticle
    extends VanillaDripParticle {
        protected FallingParticle(ClientLevel level, double x, double y, double z, Fluid fluid) {
            this(level, x, y, z, fluid, (int)(64.0 / (Math.random() * (double)0.8f + (double)0.2f)));
        }

        protected FallingParticle(ClientLevel level, double x, double y, double z, Fluid fluid, int lifetime) {
            super(level, x, y, z, fluid);
            this.f_107225_ = lifetime;
        }

        @Override
        protected void postMoveUpdate() {
            if (this.f_107218_) {
                this.m_107274_();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static class DripHangParticle
    extends VanillaDripParticle {
        protected final ParticleOptions fallingParticle;

        protected DripHangParticle(ClientLevel level, double x, double y, double z, Fluid fluid, ParticleOptions fallingParticle) {
            super(level, x, y, z, fluid);
            this.fallingParticle = fallingParticle;
            this.f_107226_ *= 0.02f;
            this.f_107225_ = 40;
        }

        @Override
        protected void preMoveUpdate() {
            if (this.f_107225_-- <= 0) {
                this.m_107274_();
                this.f_107208_.m_7106_(this.fallingParticle, this.f_107212_, this.f_107213_, this.f_107214_, this.f_107215_, this.f_107216_, this.f_107217_);
            }
        }

        @Override
        protected void postMoveUpdate() {
            this.f_107215_ *= 0.02;
            this.f_107216_ *= 0.02;
            this.f_107217_ *= 0.02;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static class DripLandParticle
    extends VanillaDripParticle {
        protected DripLandParticle(ClientLevel level, double x, double y, double z, Fluid fluid) {
            super(level, x, y, z, fluid);
            this.f_107225_ = (int)(16.0 / (Math.random() * (double)0.8f + (double)0.2f));
        }
    }
}

